/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import org.apache.camel.util.function.ThrowingRunnable;
import org.apache.camel.util.function.ThrowingSupplier;

public final class LockHelper {
    private LockHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doWithReadLock(StampedLock lock, Runnable task) {
        long stamp = lock.readLock();
        try {
            task.run();
        }
        finally {
            lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R callWithReadLock(StampedLock lock, Callable<R> task) throws Exception {
        long stamp = lock.readLock();
        try {
            R r = task.call();
            return r;
        }
        finally {
            lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Throwable> void doWithReadLockT(StampedLock lock, ThrowingRunnable<T> task) throws T {
        long stamp = lock.readLock();
        try {
            task.run();
        }
        finally {
            lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R supplyWithReadLock(StampedLock lock, Supplier<R> task) {
        long stamp = lock.readLock();
        try {
            R r = task.get();
            return r;
        }
        finally {
            lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, T extends Throwable> R supplyWithReadLockT(StampedLock lock, ThrowingSupplier<R, T> task) throws T {
        long stamp = lock.readLock();
        try {
            R r = task.get();
            return r;
        }
        finally {
            lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doWithWriteLock(StampedLock lock, Runnable task) {
        long stamp = lock.writeLock();
        try {
            task.run();
        }
        finally {
            lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R callWithWriteLock(StampedLock lock, Callable<R> task) throws Exception {
        long stamp = lock.writeLock();
        try {
            R r = task.call();
            return r;
        }
        finally {
            lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R supplyWithWriteLock(StampedLock lock, Supplier<R> task) {
        long stamp = lock.writeLock();
        try {
            R r = task.get();
            return r;
        }
        finally {
            lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Throwable> void doWithWriteLockT(StampedLock lock, ThrowingRunnable<T> task) throws T {
        long stamp = lock.writeLock();
        try {
            task.run();
        }
        finally {
            lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, T extends Throwable> R supplyWithWriteLockT(StampedLock lock, ThrowingSupplier<R, T> task) throws T {
        long stamp = lock.writeLock();
        try {
            R r = task.get();
            return r;
        }
        finally {
            lock.unlockWrite(stamp);
        }
    }
}

