/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBindingPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerConsumerPlugin;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumerConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumerManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationGenericConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationLocalPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationQueueConsumer;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromQueuePolicy;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AMQPFederationQueuePolicyManager
extends AMQPFederationLocalPolicyManager
implements ActiveMQServerConsumerPlugin,
ActiveMQServerBindingPlugin {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final FederationReceiveFromQueuePolicy policy;
    protected final Map<FederationConsumerInfo, AMQPFederationQueueConsumerManager> federationConsumers = new HashMap<FederationConsumerInfo, AMQPFederationQueueConsumerManager>();
    private final String CONSUMER_INFO_ATTACHMENT_KEY = UUID.randomUUID().toString();

    public AMQPFederationQueuePolicyManager(AMQPFederation federation, AMQPFederationMetrics metrics, FederationReceiveFromQueuePolicy queuePolicy) throws ActiveMQException {
        super(federation, metrics, queuePolicy);
        Objects.requireNonNull(queuePolicy, "The Queue match policy cannot be null");
        this.policy = queuePolicy;
    }

    @Override
    public FederationReceiveFromQueuePolicy getPolicy() {
        return this.policy;
    }

    @Override
    protected void safeCleanupManagerResources(boolean force) {
        try {
            this.federationConsumers.values().forEach(entry -> {
                if (entry != null) {
                    if (this.isConnected() && !force) {
                        entry.shutdown();
                    } else {
                        entry.shutdownNow();
                    }
                }
            });
        }
        finally {
            this.federationConsumers.clear();
        }
    }

    public synchronized void afterCreateConsumer(ServerConsumer consumer) {
        if (this.isActive()) {
            this.reactIfConsumerMatchesPolicy(consumer);
        }
    }

    public synchronized void afterCloseConsumer(ServerConsumer consumer, boolean failed) {
        FederationConsumerInfo consumerInfo;
        if (this.isActive() && (consumerInfo = (FederationConsumerInfo)consumer.getAttachment(this.CONSUMER_INFO_ATTACHMENT_KEY)) != null && this.federationConsumers.containsKey(consumerInfo)) {
            AMQPFederationQueueConsumerManager entry = this.federationConsumers.get(consumerInfo);
            logger.trace("Reducing demand on federated queue {}", (Object)entry.getQueueName());
            entry.removeDemand(consumer);
        }
    }

    public synchronized void afterRemoveBinding(Binding binding, Transaction tx, boolean deleteData) throws ActiveMQException {
        if (binding instanceof QueueBinding) {
            QueueBinding queueBinding = (QueueBinding)binding;
            String queueName = queueBinding.getQueue().getName().toString();
            this.federationConsumers.values().removeIf(entry -> {
                if (entry.getQueueName().equals(queueName)) {
                    logger.trace("Federated queue {} was removed, closing federation consumer", (Object)queueName);
                    entry.shutdownNow();
                    return true;
                }
                return false;
            });
        }
    }

    @Override
    protected void scanAllBindings() {
        this.server.getPostOffice().getAllBindings().filter(b -> b instanceof QueueBinding).map(b -> (QueueBinding)b).forEach(b -> this.checkQueueForMatch(b.getQueue()));
    }

    @Override
    protected void updateStateAfterConnect(AMQPFederationConsumerConfiguration configuration, AMQPSessionContext session) {
    }

    private void checkQueueForMatch(Queue queue) {
        queue.getConsumers().stream().filter(consumer -> consumer instanceof ServerConsumer).map(c -> (ServerConsumer)c).forEach(this::reactIfConsumerMatchesPolicy);
    }

    private void reactIfConsumerMatchesPolicy(ServerConsumer consumer) {
        String queueName = consumer.getQueue().getName().toString();
        if (this.testIfQueueMatchesPolicy(consumer.getQueueAddress().toString(), queueName)) {
            AMQPFederationQueueConsumerManager entry;
            boolean federationConsumer = this.isFederationConsumer(consumer);
            if (federationConsumer && !this.policy.isIncludeFederated()) {
                return;
            }
            logger.trace("Federation Policy matched on consumer for binding: {}", (Object)consumer.getBinding());
            FederationConsumerInfo consumerInfo = this.createConsumerInfo(consumer, federationConsumer);
            if (this.federationConsumers.containsKey(consumerInfo)) {
                logger.trace("Federation Queue Policy manager found existing demand for queue: {}, adding demand", (Object)queueName);
                entry = this.federationConsumers.get(consumerInfo);
            } else {
                entry = new AMQPFederationQueueConsumerManager(this, this.CONSUMER_INFO_ATTACHMENT_KEY, consumerInfo, consumer.getQueue());
                this.federationConsumers.put(consumerInfo, entry);
            }
            entry.addDemand(consumer);
        }
    }

    public synchronized void afterRemoteQueueAdded(String addressName, String queueName) throws Exception {
        Queue queue;
        if (this.isActive() && this.testIfQueueMatchesPolicy(queueName) && (queue = this.server.locateQueue(queueName)) != null) {
            this.federationConsumers.forEach((k, v) -> {
                if (k.getQueueName().equals(queueName)) {
                    v.recover();
                }
            });
        }
    }

    private boolean testIfQueueMatchesPolicy(String address, String queueName) {
        return this.policy.test(address, queueName);
    }

    private boolean testIfQueueMatchesPolicy(String queueName) {
        return this.policy.testQueue(queueName);
    }

    private FederationConsumerInfo createConsumerInfo(ServerConsumer consumer, boolean federationConsumer) {
        Queue queue = consumer.getQueue();
        String queueName = queue.getName().toString();
        String address = queue.getAddress().toString();
        int priority = this.selectPriority(consumer, federationConsumer);
        String filterString = this.selectFilter(consumer);
        return new AMQPFederationGenericConsumerInfo(FederationConsumerInfo.Role.QUEUE_CONSUMER, address, queueName, queue.getRoutingType(), filterString, CompositeAddress.toFullyQualified((String)address, (String)queueName), priority);
    }

    private String selectFilter(ServerConsumer consumer) {
        Filter queueFilter = consumer.getQueue().getFilter();
        Filter consumerFilter = !this.configuration.isIgnoreSubscriptionFilters() ? consumer.getFilter() : null;
        if (consumerFilter != null) {
            return consumerFilter.getFilterString().toString();
        }
        if (queueFilter != null) {
            return queueFilter.getFilterString().toString();
        }
        return null;
    }

    private int selectPriority(ServerConsumer consumer, boolean federationConsumer) {
        if (federationConsumer) {
            return consumer.getPriority();
        }
        if (this.configuration.isIgnoreSubscriptionPriorities()) {
            return ActiveMQDefaultConfiguration.getDefaultConsumerPriority() + this.policy.getPriorityAjustment();
        }
        return consumer.getPriority() + this.policy.getPriorityAjustment();
    }

    private boolean isFederationConsumer(ServerConsumer consumer) {
        ServerSession serverSession = this.server.getSessionByID(consumer.getSessionID());
        if (serverSession != null && serverSession.getMetaData() != null) {
            return serverSession.getMetaData("federation-name") != null;
        }
        return false;
    }

    private static class AMQPFederationQueueConsumerManager
    extends AMQPFederationConsumerManager<ServerConsumer, AMQPFederationQueueConsumer> {
        private final AMQPFederation federation;
        private final AMQPFederationQueuePolicyManager manager;
        private final FederationReceiveFromQueuePolicy policy;
        private final Queue queue;
        private final FederationConsumerInfo consumerInfo;
        private final String policyInfoKey;

        AMQPFederationQueueConsumerManager(AMQPFederationQueuePolicyManager manager, String policyInfoKey, FederationConsumerInfo consumerInfo, Queue queue) {
            super(manager);
            this.federation = manager.getFederation();
            this.policy = manager.getPolicy();
            this.manager = manager;
            this.queue = queue;
            this.consumerInfo = consumerInfo;
            this.policyInfoKey = policyInfoKey;
        }

        public String getQueueName() {
            return this.queue.getName().toString();
        }

        @Override
        protected AMQPFederationQueueConsumer createFederationConsumer(Set<ServerConsumer> demand) {
            if (logger.isTraceEnabled()) {
                logger.trace("AMQP Federation {} creating queue consumer: {} for policy: {}", new Object[]{this.federation.getName(), this.consumerInfo, this.policy.getPolicyName()});
            }
            return new AMQPFederationQueueConsumer(this.manager, this.manager.getConfiguration(), this.federation.getSessionContext(), this.consumerInfo, this.manager.getMetrics().newConsumerMetrics());
        }

        @Override
        protected boolean isPluginBlockingFederationConsumerCreate() {
            return this.manager.isPluginBlockingFederationConsumerCreate(this.queue);
        }

        @Override
        protected void whenDemandTrackingEntryRemoved(ServerConsumer serverConsumer, AMQPFederationQueueConsumer consumer) {
            serverConsumer.removeAttachment(this.policyInfoKey);
        }

        @Override
        protected void whenDemandTrackingEntryAdded(ServerConsumer serverConsumer, AMQPFederationQueueConsumer consumer) {
            serverConsumer.addAttachment(this.policyInfoKey, (Object)this.consumerInfo);
        }
    }
}

