<!--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

# How to publish docs

## Overview

We publish our official docs to the following locations:

* https://arrow.apache.org/js/current/ : For the current release
* https://arrow.apache.org/js/${VERSION} : For the specified version such as `21.0.0`
* https://arrow.apache.org/js/main/ : For the `main` branch

We also publish docs for fork repositories for preview. It uses the
following locations:

* https://${GITHUB_ID}.github.io/arrow-js/ : List all available docs
* https://${GITHUB_ID}.github.io/arrow-js/${BRANCH}/ : For the `${BRANCH}` branch

All of them are automated. This documentation describes how it works.

### apache/arrow-js

apache/arrow-js uses the ASF provided Apache to host generated
documentation. In general, the `asf-site` branch is used for it. See
the `publish.whoami` configuration in the top-level `.asf.yaml`.

Note that we don't need to touch the `asf-site` branch manually. It's
completely maintained automatically. If the `asf-site` branch doesn't
exist, it's created automatically.

If we update the `asf-site` branch, the `asf-site` branch contents
will be published to https://arrow.apache.org/js/ automatically.

https://arrow.apache.org/js/ is always redirected to
https://arrow.apache.org/js/current/ that provides the current release
documentation. It's implemented by `.htaccess`. `.htaccess` is
generated by `ci/scripts/update_docs.sh`.

The `asf-site` branch is updated when:

* We push a release tag
* We push a commit to the `main` branch (We merge a PR to the `main` branch)

Note that the `asf-site` branch isn't updated when we push an RC
tag. We just build documentation and upload to a GitHub Release when
we push an RC tag. We add the built documentation to the `asf-site`
branch when we push a release tag. In this case, `current/` and
`${VERSION}/` directories in the `asf-site` branch are updated.

We build documentation and add the built documentation to the
`asf-site` when we push a commit to the `main` branch. In this case,
`main/` directory in the `asf-site` branch is updated.

See also `ci/scripts/update_docs.sh`.

### Fork repositories

Fork repositories use GitHub Pages to host generated
documentation. The `gh-pages` branch is used for it.

Note that we don't need to touch the `gh-pages` branch manually. It's
completely maintained automatically. If the `gh-pages` branch doesn't
exist, it's created automatically. If your fork repository's size
becomes bigger by the `gh-pages` branch, you can delete the `gh-pages`
branch. Because it has only temporary data and can be generated
automatically.

You need to enable GitHub Pages on your fork repository. See
[DEVELOP.md](../../DEVELOP.md#how-to-preview-documentation-on-your-fork-repository) how to enable GitHub Pages on your fork repository.

If we update the `gh-pages` branch, the `gh-page` branch contents will
be published to https://${GITHUB_ID}.github.io/arrow-js/
automatically.

https://${GITHUB_ID}.github.io/arrow-js/ shows all available
previews. https://${GITHUB_ID}.github.io/arrow-js/${BRANCH} has a
preview of the `${BRANCH}` branch. If the `${BRANCH}` branch is
deleted, the `${BRANCH}` directory is also deleted from the `gh-pages`
branch when you push a commit to your fork repository.

The `gh-pages` branch is updated when you push a commit to your fork
repository. Our workflow generates a preview for the pushed branch and
deletes previews of nonexistent branches.

See also `ci/scripts/update_docs.sh`.
