/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.salesforce.SalesforceComponent;

/**
 * Communicate with Salesforce using Java DTOs.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface SalesforceComponentBuilderFactory {

    /**
     * Salesforce (camel-salesforce)
     * Communicate with Salesforce using Java DTOs.
     * 
     * Category: cloud,saas
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-salesforce
     * 
     * @return the dsl builder
     */
    static SalesforceComponentBuilder salesforce() {
        return new SalesforceComponentBuilderImpl();
    }

    /**
     * Builder for the Salesforce component.
     */
    interface SalesforceComponentBuilder extends ComponentBuilder<SalesforceComponent> {
    
        /**
         * APEX method name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexMethod the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder apexMethod(java.lang.String apexMethod) {
            doSetProperty("apexMethod", apexMethod);
            return this;
        }
    
        /**
         * Query params for APEX method.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexQueryParams the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder apexQueryParams(java.util.Map<java.lang.String, java.lang.Object> apexQueryParams) {
            doSetProperty("apexQueryParams", apexQueryParams);
            return this;
        }
    
        
        /**
         * Salesforce API version.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 56.0
         * Group: common
         * 
         * @param apiVersion the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder apiVersion(java.lang.String apiVersion) {
            doSetProperty("apiVersion", apiVersion);
            return this;
        }
    
        
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param backoffIncrement the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder backoffIncrement(long backoffIncrement) {
            doSetProperty("backoffIncrement", backoffIncrement);
            return this;
        }
    
        /**
         * Bulk API Batch ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param batchId the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder batchId(java.lang.String batchId) {
            doSetProperty("batchId", batchId);
            return this;
        }
    
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.bulk.ContentType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder contentType(org.apache.camel.component.salesforce.api.dto.bulk.ContentType contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
    
        
        /**
         * Default replayId setting if no value is found in initialReplayIdMap.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param defaultReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder defaultReplayId(java.lang.Long defaultReplayId) {
            doSetProperty("defaultReplayId", defaultReplayId);
            return this;
        }
    
        
        /**
         * ReplayId to fall back to after an Invalid Replay Id response.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param fallBackReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder fallBackReplayId(java.lang.Long fallBackReplayId) {
            doSetProperty("fallBackReplayId", fallBackReplayId);
            return this;
        }
    
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON. As of Camel 3.12, this option only applies to the
         * Raw operation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.PayloadFormat&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param format the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder format(org.apache.camel.component.salesforce.internal.PayloadFormat format) {
            doSetProperty("format", format);
            return this;
        }
    
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.SalesforceHttpClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder httpClient(org.apache.camel.component.salesforce.SalesforceHttpClient httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
    
        
        /**
         * Connection timeout used by the HttpClient when connecting to the
         * Salesforce server.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: common
         * 
         * @param httpClientConnectionTimeout the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder httpClientConnectionTimeout(long httpClientConnectionTimeout) {
            doSetProperty("httpClientConnectionTimeout", httpClientConnectionTimeout);
            return this;
        }
    
        
        /**
         * Timeout used by the HttpClient when waiting for response from the
         * Salesforce server.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: common
         * 
         * @param httpClientIdleTimeout the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder httpClientIdleTimeout(long httpClientIdleTimeout) {
            doSetProperty("httpClientIdleTimeout", httpClientIdleTimeout);
            return this;
        }
    
        /**
         * Max content length of an HTTP response.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpMaxContentLength the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder httpMaxContentLength(java.lang.Integer httpMaxContentLength) {
            doSetProperty("httpMaxContentLength", httpMaxContentLength);
            return this;
        }
    
        
        /**
         * HTTP request buffer size. May need to be increased for large SOQL
         * queries.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: common
         * 
         * @param httpRequestBufferSize the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder httpRequestBufferSize(java.lang.Integer httpRequestBufferSize) {
            doSetProperty("httpRequestBufferSize", httpRequestBufferSize);
            return this;
        }
    
        
        /**
         * Timeout value for HTTP requests.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: common
         * 
         * @param httpRequestTimeout the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder httpRequestTimeout(long httpRequestTimeout) {
            doSetProperty("httpRequestTimeout", httpRequestTimeout);
            return this;
        }
    
        
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param includeDetails the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder includeDetails(java.lang.Boolean includeDetails) {
            doSetProperty("includeDetails", includeDetails);
            return this;
        }
    
        /**
         * Replay IDs to start from per channel name.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Long&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param initialReplayIdMap the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder initialReplayIdMap(java.util.Map<java.lang.String, java.lang.Long> initialReplayIdMap) {
            doSetProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }
    
        /**
         * Salesforce1 Analytics report execution instance ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param instanceId the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder instanceId(java.lang.String instanceId) {
            doSetProperty("instanceId", instanceId);
            return this;
        }
    
        /**
         * Bulk API Job ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param jobId the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder jobId(java.lang.String jobId) {
            doSetProperty("jobId", jobId);
            return this;
        }
    
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param limit the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder limit(java.lang.Integer limit) {
            doSetProperty("limit", limit);
            return this;
        }
    
        /**
         * Locator provided by salesforce Bulk 2.0 API for use in getting
         * results for a Query job.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param locator the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder locator(java.lang.String locator) {
            doSetProperty("locator", locator);
            return this;
        }
    
        
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param maxBackoff the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder maxBackoff(long maxBackoff) {
            doSetProperty("maxBackoff", maxBackoff);
            return this;
        }
    
        /**
         * The maximum number of records to retrieve per set of results for a
         * Bulk 2.0 Query. The request is still subject to the size limits. If
         * you are working with a very large number of query results, you may
         * experience a timeout before receiving all the data from Salesforce.
         * To prevent a timeout, specify the maximum number of records your
         * client is expecting to receive in the maxRecords parameter. This
         * splits the results into smaller sets with this value as the maximum
         * size.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxRecords the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder maxRecords(java.lang.Integer maxRecords) {
            doSetProperty("maxRecords", maxRecords);
            return this;
        }
    
        
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.NotFoundBehaviour&lt;/code&gt; type.
         * 
         * Default: EXCEPTION
         * Group: common
         * 
         * @param notFoundBehaviour the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder notFoundBehaviour(org.apache.camel.component.salesforce.NotFoundBehaviour notFoundBehaviour) {
            doSetProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }
    
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForFields the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder notifyForFields(org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum notifyForFields) {
            doSetProperty("notifyForFields", notifyForFields);
            return this;
        }
    
        
        /**
         * Notify for create operation, defaults to false (API version &amp;gt;=
         * 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param notifyForOperationCreate the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder notifyForOperationCreate(java.lang.Boolean notifyForOperationCreate) {
            doSetProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }
    
        
        /**
         * Notify for delete operation, defaults to false (API version &amp;gt;=
         * 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param notifyForOperationDelete the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder notifyForOperationDelete(java.lang.Boolean notifyForOperationDelete) {
            doSetProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }
    
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version &amp;lt; 29.0).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperations the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder notifyForOperations(org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum notifyForOperations) {
            doSetProperty("notifyForOperations", notifyForOperations);
            return this;
        }
    
        
        /**
         * Notify for un-delete operation, defaults to false (API version
         * &amp;gt;= 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param notifyForOperationUndelete the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder notifyForOperationUndelete(java.lang.Boolean notifyForOperationUndelete) {
            doSetProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }
    
        
        /**
         * Notify for update operation, defaults to false (API version &amp;gt;=
         * 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param notifyForOperationUpdate the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder notifyForOperationUpdate(java.lang.Boolean notifyForOperationUpdate) {
            doSetProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }
    
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         * 
         * The option is a:
         * &lt;code&gt;com.fasterxml.jackson.databind.ObjectMapper&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param objectMapper the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder objectMapper(com.fasterxml.jackson.databind.ObjectMapper objectMapper) {
            doSetProperty("objectMapper", objectMapper);
            return this;
        }
    
        /**
         * In what packages are the generated DTO classes. Typically the classes
         * would be generated using camel-salesforce-maven-plugin. Set it if
         * using the generated DTOs to gain the benefit of using short SObject
         * names in parameters/header values. Multiple packages can be separated
         * by comma.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param packages the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder packages(java.lang.String packages) {
            doSetProperty("packages", packages);
            return this;
        }
    
        
        /**
         * Use PK Chunking. Only for use in original Bulk API. Bulk 2.0 API
         * performs PK chunking automatically, if necessary.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pkChunking the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder pkChunking(java.lang.Boolean pkChunking) {
            doSetProperty("pkChunking", pkChunking);
            return this;
        }
    
        /**
         * Chunk size for use with PK Chunking. If unspecified, salesforce
         * default is 100,000. Maximum size is 250,000.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunkingChunkSize the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder pkChunkingChunkSize(java.lang.Integer pkChunkingChunkSize) {
            doSetProperty("pkChunkingChunkSize", pkChunkingChunkSize);
            return this;
        }
    
        /**
         * Specifies the parent object when you're enabling PK chunking for
         * queries on sharing objects. The chunks are based on the parent
         * object's records rather than the sharing object's records. For
         * example, when querying on AccountShare, specify Account as the parent
         * object. PK chunking is supported for sharing objects as long as the
         * parent object is supported.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunkingParent the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder pkChunkingParent(java.lang.String pkChunkingParent) {
            doSetProperty("pkChunkingParent", pkChunkingParent);
            return this;
        }
    
        /**
         * Specifies the 15-character or 18-character record ID to be used as
         * the lower boundary for the first chunk. Use this parameter to specify
         * a starting ID when restarting a job that failed between batches.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunkingStartRow the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder pkChunkingStartRow(java.lang.String pkChunkingStartRow) {
            doSetProperty("pkChunkingStartRow", pkChunkingStartRow);
            return this;
        }
    
        /**
         * Query Locator provided by salesforce for use when a query results in
         * more records than can be retrieved in a single call. Use this value
         * in a subsequent call to retrieve additional records.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queryLocator the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder queryLocator(java.lang.String queryLocator) {
            doSetProperty("queryLocator", queryLocator);
            return this;
        }
    
        
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param rawPayload the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder rawPayload(boolean rawPayload) {
            doSetProperty("rawPayload", rawPayload);
            return this;
        }
    
        /**
         * Salesforce1 Analytics report Id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportId the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder reportId(java.lang.String reportId) {
            doSetProperty("reportId", reportId);
            return this;
        }
    
        /**
         * Salesforce1 Analytics report metadata for filtering.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportMetadata the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder reportMetadata(org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata reportMetadata) {
            doSetProperty("reportMetadata", reportMetadata);
            return this;
        }
    
        /**
         * Bulk API Result ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resultId the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder resultId(java.lang.String resultId) {
            doSetProperty("resultId", resultId);
            return this;
        }
    
        /**
         * SObject blob field name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectBlobFieldName the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder sObjectBlobFieldName(java.lang.String sObjectBlobFieldName) {
            doSetProperty("sObjectBlobFieldName", sObjectBlobFieldName);
            return this;
        }
    
        /**
         * Fully qualified SObject class name, usually generated using
         * camel-salesforce-maven-plugin.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectClass the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder sObjectClass(java.lang.String sObjectClass) {
            doSetProperty("sObjectClass", sObjectClass);
            return this;
        }
    
        /**
         * SObject fields to retrieve.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectFields the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder sObjectFields(java.lang.String sObjectFields) {
            doSetProperty("sObjectFields", sObjectFields);
            return this;
        }
    
        /**
         * SObject ID if required by API.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectId the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder sObjectId(java.lang.String sObjectId) {
            doSetProperty("sObjectId", sObjectId);
            return this;
        }
    
        /**
         * SObject external ID field name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectIdName the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder sObjectIdName(java.lang.String sObjectIdName) {
            doSetProperty("sObjectIdName", sObjectIdName);
            return this;
        }
    
        /**
         * SObject external ID field value.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectIdValue the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder sObjectIdValue(java.lang.String sObjectIdValue) {
            doSetProperty("sObjectIdValue", sObjectIdValue);
            return this;
        }
    
        /**
         * SObject name if required or supported by API.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectName the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder sObjectName(java.lang.String sObjectName) {
            doSetProperty("sObjectName", sObjectName);
            return this;
        }
    
        /**
         * Salesforce SOQL query string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectQuery the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder sObjectQuery(java.lang.String sObjectQuery) {
            doSetProperty("sObjectQuery", sObjectQuery);
            return this;
        }
    
        /**
         * Salesforce SOSL search string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectSearch the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder sObjectSearch(java.lang.String sObjectSearch) {
            doSetProperty("sObjectSearch", sObjectSearch);
            return this;
        }
    
        
        /**
         * If true, streams SOQL query result and transparently handles
         * subsequent requests if there are multiple pages. Otherwise, results
         * are returned one page at a time.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param streamQueryResult the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder streamQueryResult(java.lang.Boolean streamQueryResult) {
            doSetProperty("streamQueryResult", streamQueryResult);
            return this;
        }
    
        
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param updateTopic the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder updateTopic(boolean updateTopic) {
            doSetProperty("updateTopic", updateTopic);
            return this;
        }
    
        /**
         * Global endpoint configuration - use to set values that are common to
         * all endpoints.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.SalesforceEndpointConfig&lt;/code&gt; type.
         * 
         * Group: common (advanced)
         * 
         * @param config the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder config(org.apache.camel.component.salesforce.SalesforceEndpointConfig config) {
            doSetProperty("config", config);
            return this;
        }
    
        /**
         * Used to set any properties that can be configured on the underlying
         * HTTP client. Have a look at properties of SalesforceHttpClient and
         * the Jetty HttpClient for all available options.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common (advanced)
         * 
         * @param httpClientProperties the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder httpClientProperties(java.util.Map<java.lang.String, java.lang.Object> httpClientProperties) {
            doSetProperty("httpClientProperties", httpClientProperties);
            return this;
        }
    
        /**
         * Used to set any properties that can be configured on the
         * LongPollingTransport used by the BayeuxClient (CometD) used by the
         * streaming api.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common (advanced)
         * 
         * @param longPollingTransportProperties the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder longPollingTransportProperties(java.util.Map<java.lang.String, java.lang.Object> longPollingTransportProperties) {
            doSetProperty("longPollingTransportProperties", longPollingTransportProperties);
            return this;
        }
    
        
        /**
         * Maximum size of the thread pool used to handle HTTP responses.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 20
         * Group: common (advanced)
         * 
         * @param workerPoolMaxSize the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder workerPoolMaxSize(int workerPoolMaxSize) {
            doSetProperty("workerPoolMaxSize", workerPoolMaxSize);
            return this;
        }
    
        
        /**
         * Size of the thread pool used to handle HTTP responses.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: common (advanced)
         * 
         * @param workerPoolSize the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder workerPoolSize(int workerPoolSize) {
            doSetProperty("workerPoolSize", workerPoolSize);
            return this;
        }
    
        
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    
        
        /**
         * Whether the pub/sub consumer needs to fallback to the latest replay
         * id when the provided id is not valid. If set to false, the component
         * will keep retrying; in order to treat this as an exception you can
         * use BridgeExceptionHandlerToErrorHandler and handle the exception in
         * the route.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param fallbackToLatestReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder fallbackToLatestReplayId(boolean fallbackToLatestReplayId) {
            doSetProperty("fallbackToLatestReplayId", fallbackToLatestReplayId);
            return this;
        }
    
        
        /**
         * Max number of events to receive in a batch from the Pub/Sub API.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: consumer
         * 
         * @param pubSubBatchSize the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder pubSubBatchSize(int pubSubBatchSize) {
            doSetProperty("pubSubBatchSize", pubSubBatchSize);
            return this;
        }
    
        
        /**
         * How to deserialize events consume from the Pub/Sub API. AVRO will try
         * a SpecificRecord subclass if found, otherwise GenericRecord.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.PubSubDeserializeType&lt;/code&gt; type.
         * 
         * Default: AVRO
         * Group: consumer
         * 
         * @param pubSubDeserializeType the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder pubSubDeserializeType(org.apache.camel.component.salesforce.PubSubDeserializeType pubSubDeserializeType) {
            doSetProperty("pubSubDeserializeType", pubSubDeserializeType);
            return this;
        }
    
        /**
         * Fully qualified class name to deserialize Pub/Sub API event to.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param pubSubPojoClass the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder pubSubPojoClass(java.lang.String pubSubPojoClass) {
            doSetProperty("pubSubPojoClass", pubSubPojoClass);
            return this;
        }
    
        
        /**
         * Replay preset for Pub/Sub API.
         * 
         * The option is a:
         * &lt;code&gt;com.salesforce.eventbus.protobuf.ReplayPreset&lt;/code&gt; type.
         * 
         * Default: LATEST
         * Group: consumer
         * 
         * @param replayPreset the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder replayPreset(com.salesforce.eventbus.protobuf.ReplayPreset replayPreset) {
            doSetProperty("replayPreset", replayPreset);
            return this;
        }
    
        
        /**
         * Use thread pool for processing received Salesforce events, for
         * example to process events in parallel.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param consumerWorkerPoolEnabled the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder consumerWorkerPoolEnabled(boolean consumerWorkerPoolEnabled) {
            doSetProperty("consumerWorkerPoolEnabled", consumerWorkerPoolEnabled);
            return this;
        }
    
        /**
         * To use a custom thread pool for processing received Salesforce
         * events, for example to process events in parallel.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ExecutorService&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param consumerWorkerPoolExecutorService the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder consumerWorkerPoolExecutorService(java.util.concurrent.ExecutorService consumerWorkerPoolExecutorService) {
            doSetProperty("consumerWorkerPoolExecutorService", consumerWorkerPoolExecutorService);
            return this;
        }
    
        
        /**
         * Maximum thread pool size size for consumer worker pool.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 20
         * Group: consumer (advanced)
         * 
         * @param consumerWorkerPoolMaxSize the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder consumerWorkerPoolMaxSize(int consumerWorkerPoolMaxSize) {
            doSetProperty("consumerWorkerPoolMaxSize", consumerWorkerPoolMaxSize);
            return this;
        }
    
        
        /**
         * Core thread pool size size for consumer worker pool.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: consumer (advanced)
         * 
         * @param consumerWorkerPoolSize the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder consumerWorkerPoolSize(int consumerWorkerPoolSize) {
            doSetProperty("consumerWorkerPoolSize", consumerWorkerPoolSize);
            return this;
        }
    
        
        /**
         * Timeout in seconds to validate when a custom pubSubReplayId has been
         * configured, when starting the Camel Salesforce consumer.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30
         * Group: consumer (advanced)
         * 
         * @param initialReplyIdTimeout the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder initialReplyIdTimeout(int initialReplyIdTimeout) {
            doSetProperty("initialReplyIdTimeout", initialReplyIdTimeout);
            return this;
        }
    
        
        /**
         * Composite API option to indicate to rollback all records if any are
         * not successful.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param allOrNone the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder allOrNone(boolean allOrNone) {
            doSetProperty("allOrNone", allOrNone);
            return this;
        }
    
        /**
         * APEX method URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param apexUrl the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder apexUrl(java.lang.String apexUrl) {
            doSetProperty("apexUrl", apexUrl);
            return this;
        }
    
        /**
         * Composite (raw) method.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param compositeMethod the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder compositeMethod(java.lang.String compositeMethod) {
            doSetProperty("compositeMethod", compositeMethod);
            return this;
        }
    
        /**
         * Name of Platform Event, Change Data Capture Event, custom event, etc.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param eventName the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder eventName(java.lang.String eventName) {
            doSetProperty("eventName", eventName);
            return this;
        }
    
        /**
         * EXPANDED: Apache Avro format but doesn't strictly adhere to the
         * record complex type. COMPACT: Apache Avro, adheres to the
         * specification for the record complex type. This parameter is
         * available in API version 43.0 and later.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.EventSchemaFormatEnum&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param eventSchemaFormat the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder eventSchemaFormat(org.apache.camel.component.salesforce.internal.dto.EventSchemaFormatEnum eventSchemaFormat) {
            doSetProperty("eventSchemaFormat", eventSchemaFormat);
            return this;
        }
    
        /**
         * The ID of the event schema.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param eventSchemaId the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder eventSchemaId(java.lang.String eventSchemaId) {
            doSetProperty("eventSchemaId", eventSchemaId);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        /**
         * Comma separated list of message headers to include as HTTP parameters
         * for Raw operation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param rawHttpHeaders the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder rawHttpHeaders(java.lang.String rawHttpHeaders) {
            doSetProperty("rawHttpHeaders", rawHttpHeaders);
            return this;
        }
    
        /**
         * HTTP method to use for the Raw operation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param rawMethod the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder rawMethod(java.lang.String rawMethod) {
            doSetProperty("rawMethod", rawMethod);
            return this;
        }
    
        /**
         * The portion of the endpoint URL after the domain name. E.g.,
         * '/services/data/v52.0/sobjects/Account/'.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param rawPath the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder rawPath(java.lang.String rawPath) {
            doSetProperty("rawPath", rawPath);
            return this;
        }
    
        /**
         * Comma separated list of message headers to include as query
         * parameters for Raw operation. Do not url-encode values as this will
         * be done automatically.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param rawQueryParameters the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder rawQueryParameters(java.lang.String rawQueryParameters) {
            doSetProperty("rawQueryParameters", rawQueryParameters);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        /**
         * A list of addresses for which HTTP proxy server should not be used.
         * 
         * The option is a:
         * &lt;code&gt;java.util.Set&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyExcludedAddresses the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder httpProxyExcludedAddresses(java.util.Set<java.lang.String> httpProxyExcludedAddresses) {
            doSetProperty("httpProxyExcludedAddresses", httpProxyExcludedAddresses);
            return this;
        }
    
        /**
         * Hostname of the HTTP proxy server to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyHost the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder httpProxyHost(java.lang.String httpProxyHost) {
            doSetProperty("httpProxyHost", httpProxyHost);
            return this;
        }
    
        /**
         * A list of addresses for which HTTP proxy server should be used.
         * 
         * The option is a:
         * &lt;code&gt;java.util.Set&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyIncludedAddresses the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder httpProxyIncludedAddresses(java.util.Set<java.lang.String> httpProxyIncludedAddresses) {
            doSetProperty("httpProxyIncludedAddresses", httpProxyIncludedAddresses);
            return this;
        }
    
        /**
         * Port number of the HTTP proxy server to use.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyPort the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder httpProxyPort(java.lang.Integer httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
    
        
        /**
         * If set to true the configures the HTTP proxy to use as a SOCKS4
         * proxy.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: proxy
         * 
         * @param httpProxySocks4 the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder httpProxySocks4(boolean httpProxySocks4) {
            doSetProperty("httpProxySocks4", httpProxySocks4);
            return this;
        }
    
        
        /**
         * Allow the Pub/Sub API client to use the proxy detected by
         * java.net.ProxySelector. If false then no proxy server will be used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: proxy
         * 
         * @param pubsubAllowUseSystemProxy the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder pubsubAllowUseSystemProxy(boolean pubsubAllowUseSystemProxy) {
            doSetProperty("pubsubAllowUseSystemProxy", pubsubAllowUseSystemProxy);
            return this;
        }
    
        /**
         * Explicit authentication method to be used, one of USERNAME_PASSWORD,
         * REFRESH_TOKEN, CLIENT_CREDENTIALS, or JWT. Salesforce component can
         * auto-determine the authentication method to use from the properties
         * set, set this property to eliminate any ambiguity.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.AuthenticationType&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param authenticationType the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder authenticationType(org.apache.camel.component.salesforce.AuthenticationType authenticationType) {
            doSetProperty("authenticationType", authenticationType);
            return this;
        }
    
        /**
         * OAuth Consumer Key of the connected app configured in the Salesforce
         * instance setup. Typically a connected app needs to be configured but
         * one can be provided by installing a package.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder clientId(java.lang.String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
    
        /**
         * OAuth Consumer Secret of the connected app configured in the
         * Salesforce instance setup.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param clientSecret the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder clientSecret(java.lang.String clientSecret) {
            doSetProperty("clientSecret", clientSecret);
            return this;
        }
    
        /**
         * Used in authentication against the HTTP proxy server, needs to match
         * the URI of the proxy server in order for the httpProxyUsername and
         * httpProxyPassword to be used for authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param httpProxyAuthUri the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder httpProxyAuthUri(java.lang.String httpProxyAuthUri) {
            doSetProperty("httpProxyAuthUri", httpProxyAuthUri);
            return this;
        }
    
        /**
         * Password to use to authenticate against the HTTP proxy server.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param httpProxyPassword the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder httpProxyPassword(java.lang.String httpProxyPassword) {
            doSetProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }
    
        /**
         * Realm of the proxy server, used in preemptive Basic/Digest
         * authentication methods against the HTTP proxy server.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param httpProxyRealm the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder httpProxyRealm(java.lang.String httpProxyRealm) {
            doSetProperty("httpProxyRealm", httpProxyRealm);
            return this;
        }
    
        
        /**
         * If set to false disables the use of TLS when accessing the HTTP
         * proxy.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: security
         * 
         * @param httpProxySecure the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder httpProxySecure(boolean httpProxySecure) {
            doSetProperty("httpProxySecure", httpProxySecure);
            return this;
        }
    
        
        /**
         * If set to true Digest authentication will be used when authenticating
         * to the HTTP proxy, otherwise Basic authorization method will be used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param httpProxyUseDigestAuth the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder httpProxyUseDigestAuth(boolean httpProxyUseDigestAuth) {
            doSetProperty("httpProxyUseDigestAuth", httpProxyUseDigestAuth);
            return this;
        }
    
        /**
         * Username to use to authenticate against the HTTP proxy server.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param httpProxyUsername the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder httpProxyUsername(java.lang.String httpProxyUsername) {
            doSetProperty("httpProxyUsername", httpProxyUsername);
            return this;
        }
    
        /**
         * URL of the Salesforce instance used after authentication, by default
         * received from Salesforce on successful authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param instanceUrl the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder instanceUrl(java.lang.String instanceUrl) {
            doSetProperty("instanceUrl", instanceUrl);
            return this;
        }
    
        /**
         * Value to use for the Audience claim (aud) when using OAuth JWT flow.
         * If not set, the login URL will be used, which is appropriate in most
         * cases.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param jwtAudience the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder jwtAudience(java.lang.String jwtAudience) {
            doSetProperty("jwtAudience", jwtAudience);
            return this;
        }
    
        /**
         * KeyStore parameters to use in OAuth JWT flow. The KeyStore should
         * contain only one entry with private key and certificate. Salesforce
         * does not verify the certificate chain, so this can easily be a
         * selfsigned certificate. Make sure that you upload the certificate to
         * the corresponding connected app.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.KeyStoreParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keystore the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder keystore(org.apache.camel.support.jsse.KeyStoreParameters keystore) {
            doSetProperty("keystore", keystore);
            return this;
        }
    
        
        /**
         * If set to true prevents the component from authenticating to
         * Salesforce with the start of the component. You would generally set
         * this to the (default) false and authenticate early and be immediately
         * aware of any authentication issues. Lazy login is not supported by
         * salesforce consumers.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param lazyLogin the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder lazyLogin(boolean lazyLogin) {
            doSetProperty("lazyLogin", lazyLogin);
            return this;
        }
    
        /**
         * All authentication configuration in one nested bean, all properties
         * set there can be set directly on the component as well.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.SalesforceLoginConfig&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param loginConfig the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder loginConfig(org.apache.camel.component.salesforce.SalesforceLoginConfig loginConfig) {
            doSetProperty("loginConfig", loginConfig);
            return this;
        }
    
        
        /**
         * URL of the Salesforce instance used for authentication, by default
         * set to https://login.salesforce.com.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://login.salesforce.com
         * Group: security
         * 
         * @param loginUrl the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder loginUrl(java.lang.String loginUrl) {
            doSetProperty("loginUrl", loginUrl);
            return this;
        }
    
        /**
         * Password used in OAuth flow to gain access to access token. It's easy
         * to get started with password OAuth flow, but in general one should
         * avoid it as it is deemed less secure than other flows. Make sure that
         * you append security token to the end of the password if using one.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder password(java.lang.String password) {
            doSetProperty("password", password);
            return this;
        }
    
        
        /**
         * Pub/Sub host.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: api.pubsub.salesforce.com
         * Group: security
         * 
         * @param pubSubHost the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder pubSubHost(java.lang.String pubSubHost) {
            doSetProperty("pubSubHost", pubSubHost);
            return this;
        }
    
        
        /**
         * Pub/Sub port.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 7443
         * Group: security
         * 
         * @param pubSubPort the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder pubSubPort(int pubSubPort) {
            doSetProperty("pubSubPort", pubSubPort);
            return this;
        }
    
        /**
         * Refresh token already obtained in the refresh token OAuth flow. One
         * needs to setup a web application and configure a callback URL to
         * receive the refresh token, or configure using the builtin callback at
         * https://login.salesforce.com/services/oauth2/success or
         * https://test.salesforce.com/services/oauth2/success and then retrive
         * the refresh_token from the URL at the end of the flow. Note that in
         * development organizations Salesforce allows hosting the callback web
         * application at localhost.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param refreshToken the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder refreshToken(java.lang.String refreshToken) {
            doSetProperty("refreshToken", refreshToken);
            return this;
        }
    
        /**
         * SSL parameters to use, see SSLContextParameters class for all
         * available options.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder sslContextParameters(org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    
        
        /**
         * Enable usage of global SSL context parameters.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useGlobalSslContextParameters the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    
        /**
         * Username used in OAuth flow to gain access to access token. It's easy
         * to get started with password OAuth flow, but in general one should
         * avoid it as it is deemed less secure than other flows.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default SalesforceComponentBuilder userName(java.lang.String userName) {
            doSetProperty("userName", userName);
            return this;
        }
    }

    class SalesforceComponentBuilderImpl
            extends AbstractComponentBuilder<SalesforceComponent>
            implements SalesforceComponentBuilder {
        @Override
        protected SalesforceComponent buildConcreteComponent() {
            return new SalesforceComponent();
        }
        private org.apache.camel.component.salesforce.SalesforceEndpointConfig getOrCreateConfiguration(SalesforceComponent component) {
            if (component.getConfig() == null) {
                component.setConfig(new org.apache.camel.component.salesforce.SalesforceEndpointConfig());
            }
            return component.getConfig();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "apexMethod": getOrCreateConfiguration((SalesforceComponent) component).setApexMethod((java.lang.String) value); return true;
            case "apexQueryParams": getOrCreateConfiguration((SalesforceComponent) component).setApexQueryParams((java.util.Map) value); return true;
            case "apiVersion": getOrCreateConfiguration((SalesforceComponent) component).setApiVersion((java.lang.String) value); return true;
            case "backoffIncrement": getOrCreateConfiguration((SalesforceComponent) component).setBackoffIncrement((long) value); return true;
            case "batchId": getOrCreateConfiguration((SalesforceComponent) component).setBatchId((java.lang.String) value); return true;
            case "contentType": getOrCreateConfiguration((SalesforceComponent) component).setContentType((org.apache.camel.component.salesforce.api.dto.bulk.ContentType) value); return true;
            case "defaultReplayId": getOrCreateConfiguration((SalesforceComponent) component).setDefaultReplayId((java.lang.Long) value); return true;
            case "fallBackReplayId": getOrCreateConfiguration((SalesforceComponent) component).setFallBackReplayId((java.lang.Long) value); return true;
            case "format": getOrCreateConfiguration((SalesforceComponent) component).setFormat((org.apache.camel.component.salesforce.internal.PayloadFormat) value); return true;
            case "httpClient": getOrCreateConfiguration((SalesforceComponent) component).setHttpClient((org.apache.camel.component.salesforce.SalesforceHttpClient) value); return true;
            case "httpClientConnectionTimeout": ((SalesforceComponent) component).setHttpClientConnectionTimeout((long) value); return true;
            case "httpClientIdleTimeout": ((SalesforceComponent) component).setHttpClientIdleTimeout((long) value); return true;
            case "httpMaxContentLength": ((SalesforceComponent) component).setHttpMaxContentLength((java.lang.Integer) value); return true;
            case "httpRequestBufferSize": ((SalesforceComponent) component).setHttpRequestBufferSize((java.lang.Integer) value); return true;
            case "httpRequestTimeout": ((SalesforceComponent) component).setHttpRequestTimeout((long) value); return true;
            case "includeDetails": getOrCreateConfiguration((SalesforceComponent) component).setIncludeDetails((java.lang.Boolean) value); return true;
            case "initialReplayIdMap": getOrCreateConfiguration((SalesforceComponent) component).setInitialReplayIdMap((java.util.Map) value); return true;
            case "instanceId": getOrCreateConfiguration((SalesforceComponent) component).setInstanceId((java.lang.String) value); return true;
            case "jobId": getOrCreateConfiguration((SalesforceComponent) component).setJobId((java.lang.String) value); return true;
            case "limit": getOrCreateConfiguration((SalesforceComponent) component).setLimit((java.lang.Integer) value); return true;
            case "locator": getOrCreateConfiguration((SalesforceComponent) component).setLocator((java.lang.String) value); return true;
            case "maxBackoff": getOrCreateConfiguration((SalesforceComponent) component).setMaxBackoff((long) value); return true;
            case "maxRecords": getOrCreateConfiguration((SalesforceComponent) component).setMaxRecords((java.lang.Integer) value); return true;
            case "notFoundBehaviour": getOrCreateConfiguration((SalesforceComponent) component).setNotFoundBehaviour((org.apache.camel.component.salesforce.NotFoundBehaviour) value); return true;
            case "notifyForFields": getOrCreateConfiguration((SalesforceComponent) component).setNotifyForFields((org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum) value); return true;
            case "notifyForOperationCreate": getOrCreateConfiguration((SalesforceComponent) component).setNotifyForOperationCreate((java.lang.Boolean) value); return true;
            case "notifyForOperationDelete": getOrCreateConfiguration((SalesforceComponent) component).setNotifyForOperationDelete((java.lang.Boolean) value); return true;
            case "notifyForOperations": getOrCreateConfiguration((SalesforceComponent) component).setNotifyForOperations((org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum) value); return true;
            case "notifyForOperationUndelete": getOrCreateConfiguration((SalesforceComponent) component).setNotifyForOperationUndelete((java.lang.Boolean) value); return true;
            case "notifyForOperationUpdate": getOrCreateConfiguration((SalesforceComponent) component).setNotifyForOperationUpdate((java.lang.Boolean) value); return true;
            case "objectMapper": getOrCreateConfiguration((SalesforceComponent) component).setObjectMapper((com.fasterxml.jackson.databind.ObjectMapper) value); return true;
            case "packages": ((SalesforceComponent) component).setPackages((java.lang.String) value); return true;
            case "pkChunking": getOrCreateConfiguration((SalesforceComponent) component).setPkChunking((java.lang.Boolean) value); return true;
            case "pkChunkingChunkSize": getOrCreateConfiguration((SalesforceComponent) component).setPkChunkingChunkSize((java.lang.Integer) value); return true;
            case "pkChunkingParent": getOrCreateConfiguration((SalesforceComponent) component).setPkChunkingParent((java.lang.String) value); return true;
            case "pkChunkingStartRow": getOrCreateConfiguration((SalesforceComponent) component).setPkChunkingStartRow((java.lang.String) value); return true;
            case "queryLocator": getOrCreateConfiguration((SalesforceComponent) component).setQueryLocator((java.lang.String) value); return true;
            case "rawPayload": getOrCreateConfiguration((SalesforceComponent) component).setRawPayload((boolean) value); return true;
            case "reportId": getOrCreateConfiguration((SalesforceComponent) component).setReportId((java.lang.String) value); return true;
            case "reportMetadata": getOrCreateConfiguration((SalesforceComponent) component).setReportMetadata((org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata) value); return true;
            case "resultId": getOrCreateConfiguration((SalesforceComponent) component).setResultId((java.lang.String) value); return true;
            case "sObjectBlobFieldName": getOrCreateConfiguration((SalesforceComponent) component).setSObjectBlobFieldName((java.lang.String) value); return true;
            case "sObjectClass": getOrCreateConfiguration((SalesforceComponent) component).setSObjectClass((java.lang.String) value); return true;
            case "sObjectFields": getOrCreateConfiguration((SalesforceComponent) component).setSObjectFields((java.lang.String) value); return true;
            case "sObjectId": getOrCreateConfiguration((SalesforceComponent) component).setSObjectId((java.lang.String) value); return true;
            case "sObjectIdName": getOrCreateConfiguration((SalesforceComponent) component).setSObjectIdName((java.lang.String) value); return true;
            case "sObjectIdValue": getOrCreateConfiguration((SalesforceComponent) component).setSObjectIdValue((java.lang.String) value); return true;
            case "sObjectName": getOrCreateConfiguration((SalesforceComponent) component).setSObjectName((java.lang.String) value); return true;
            case "sObjectQuery": getOrCreateConfiguration((SalesforceComponent) component).setSObjectQuery((java.lang.String) value); return true;
            case "sObjectSearch": getOrCreateConfiguration((SalesforceComponent) component).setSObjectSearch((java.lang.String) value); return true;
            case "streamQueryResult": getOrCreateConfiguration((SalesforceComponent) component).setStreamQueryResult((java.lang.Boolean) value); return true;
            case "updateTopic": getOrCreateConfiguration((SalesforceComponent) component).setUpdateTopic((boolean) value); return true;
            case "config": ((SalesforceComponent) component).setConfig((org.apache.camel.component.salesforce.SalesforceEndpointConfig) value); return true;
            case "httpClientProperties": ((SalesforceComponent) component).setHttpClientProperties((java.util.Map) value); return true;
            case "longPollingTransportProperties": ((SalesforceComponent) component).setLongPollingTransportProperties((java.util.Map) value); return true;
            case "workerPoolMaxSize": ((SalesforceComponent) component).setWorkerPoolMaxSize((int) value); return true;
            case "workerPoolSize": ((SalesforceComponent) component).setWorkerPoolSize((int) value); return true;
            case "bridgeErrorHandler": ((SalesforceComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "fallbackToLatestReplayId": getOrCreateConfiguration((SalesforceComponent) component).setFallbackToLatestReplayId((boolean) value); return true;
            case "pubSubBatchSize": getOrCreateConfiguration((SalesforceComponent) component).setPubSubBatchSize((int) value); return true;
            case "pubSubDeserializeType": getOrCreateConfiguration((SalesforceComponent) component).setPubSubDeserializeType((org.apache.camel.component.salesforce.PubSubDeserializeType) value); return true;
            case "pubSubPojoClass": getOrCreateConfiguration((SalesforceComponent) component).setPubSubPojoClass((java.lang.String) value); return true;
            case "replayPreset": getOrCreateConfiguration((SalesforceComponent) component).setReplayPreset((com.salesforce.eventbus.protobuf.ReplayPreset) value); return true;
            case "consumerWorkerPoolEnabled": ((SalesforceComponent) component).setConsumerWorkerPoolEnabled((boolean) value); return true;
            case "consumerWorkerPoolExecutorService": ((SalesforceComponent) component).setConsumerWorkerPoolExecutorService((java.util.concurrent.ExecutorService) value); return true;
            case "consumerWorkerPoolMaxSize": ((SalesforceComponent) component).setConsumerWorkerPoolMaxSize((int) value); return true;
            case "consumerWorkerPoolSize": ((SalesforceComponent) component).setConsumerWorkerPoolSize((int) value); return true;
            case "initialReplyIdTimeout": ((SalesforceComponent) component).setInitialReplyIdTimeout((int) value); return true;
            case "allOrNone": getOrCreateConfiguration((SalesforceComponent) component).setAllOrNone((boolean) value); return true;
            case "apexUrl": getOrCreateConfiguration((SalesforceComponent) component).setApexUrl((java.lang.String) value); return true;
            case "compositeMethod": getOrCreateConfiguration((SalesforceComponent) component).setCompositeMethod((java.lang.String) value); return true;
            case "eventName": getOrCreateConfiguration((SalesforceComponent) component).setEventName((java.lang.String) value); return true;
            case "eventSchemaFormat": getOrCreateConfiguration((SalesforceComponent) component).setEventSchemaFormat((org.apache.camel.component.salesforce.internal.dto.EventSchemaFormatEnum) value); return true;
            case "eventSchemaId": getOrCreateConfiguration((SalesforceComponent) component).setEventSchemaId((java.lang.String) value); return true;
            case "lazyStartProducer": ((SalesforceComponent) component).setLazyStartProducer((boolean) value); return true;
            case "rawHttpHeaders": getOrCreateConfiguration((SalesforceComponent) component).setRawHttpHeaders((java.lang.String) value); return true;
            case "rawMethod": getOrCreateConfiguration((SalesforceComponent) component).setRawMethod((java.lang.String) value); return true;
            case "rawPath": getOrCreateConfiguration((SalesforceComponent) component).setRawPath((java.lang.String) value); return true;
            case "rawQueryParameters": getOrCreateConfiguration((SalesforceComponent) component).setRawQueryParameters((java.lang.String) value); return true;
            case "autowiredEnabled": ((SalesforceComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "httpProxyExcludedAddresses": ((SalesforceComponent) component).setHttpProxyExcludedAddresses((java.util.Set) value); return true;
            case "httpProxyHost": ((SalesforceComponent) component).setHttpProxyHost((java.lang.String) value); return true;
            case "httpProxyIncludedAddresses": ((SalesforceComponent) component).setHttpProxyIncludedAddresses((java.util.Set) value); return true;
            case "httpProxyPort": ((SalesforceComponent) component).setHttpProxyPort((java.lang.Integer) value); return true;
            case "httpProxySocks4": ((SalesforceComponent) component).setHttpProxySocks4((boolean) value); return true;
            case "pubsubAllowUseSystemProxy": ((SalesforceComponent) component).setPubsubAllowUseSystemProxy((boolean) value); return true;
            case "authenticationType": ((SalesforceComponent) component).setAuthenticationType((org.apache.camel.component.salesforce.AuthenticationType) value); return true;
            case "clientId": ((SalesforceComponent) component).setClientId((java.lang.String) value); return true;
            case "clientSecret": ((SalesforceComponent) component).setClientSecret((java.lang.String) value); return true;
            case "httpProxyAuthUri": ((SalesforceComponent) component).setHttpProxyAuthUri((java.lang.String) value); return true;
            case "httpProxyPassword": ((SalesforceComponent) component).setHttpProxyPassword((java.lang.String) value); return true;
            case "httpProxyRealm": ((SalesforceComponent) component).setHttpProxyRealm((java.lang.String) value); return true;
            case "httpProxySecure": ((SalesforceComponent) component).setHttpProxySecure((boolean) value); return true;
            case "httpProxyUseDigestAuth": ((SalesforceComponent) component).setHttpProxyUseDigestAuth((boolean) value); return true;
            case "httpProxyUsername": ((SalesforceComponent) component).setHttpProxyUsername((java.lang.String) value); return true;
            case "instanceUrl": ((SalesforceComponent) component).setInstanceUrl((java.lang.String) value); return true;
            case "jwtAudience": ((SalesforceComponent) component).setJwtAudience((java.lang.String) value); return true;
            case "keystore": ((SalesforceComponent) component).setKeystore((org.apache.camel.support.jsse.KeyStoreParameters) value); return true;
            case "lazyLogin": ((SalesforceComponent) component).setLazyLogin((boolean) value); return true;
            case "loginConfig": ((SalesforceComponent) component).setLoginConfig((org.apache.camel.component.salesforce.SalesforceLoginConfig) value); return true;
            case "loginUrl": ((SalesforceComponent) component).setLoginUrl((java.lang.String) value); return true;
            case "password": ((SalesforceComponent) component).setPassword((java.lang.String) value); return true;
            case "pubSubHost": ((SalesforceComponent) component).setPubSubHost((java.lang.String) value); return true;
            case "pubSubPort": ((SalesforceComponent) component).setPubSubPort((int) value); return true;
            case "refreshToken": ((SalesforceComponent) component).setRefreshToken((java.lang.String) value); return true;
            case "sslContextParameters": ((SalesforceComponent) component).setSslContextParameters((org.apache.camel.support.jsse.SSLContextParameters) value); return true;
            case "useGlobalSslContextParameters": ((SalesforceComponent) component).setUseGlobalSslContextParameters((boolean) value); return true;
            case "userName": ((SalesforceComponent) component).setUserName((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}