/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.lang.reflect.Method;
import java.util.function.Function;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.MethodEncoder;
import net.openhft.chronicle.bytes.MethodId;
import net.openhft.chronicle.core.util.Annotations;

public enum MethodEncoderLookup implements Function<Method, MethodEncoder>
{
    BY_ANNOTATION;


    @Override
    public MethodEncoder apply(Method method) {
        MethodId methodId = (MethodId)Annotations.getAnnotation((Method)method, MethodId.class);
        if (methodId == null) {
            return null;
        }
        final long messageId = methodId.value();
        return new MethodEncoder(){

            @Override
            public long messageId() {
                return messageId;
            }

            @Override
            public void encode(Object[] objects, BytesOut out) {
                for (Object object : objects) {
                    if (!(object instanceof BytesMarshallable)) {
                        throw new IllegalArgumentException("Object type " + object + " not supported");
                    }
                    ((BytesMarshallable)object).writeMarshallable(out);
                }
            }

            @Override
            public Object[] decode(Object[] lastObjects, BytesIn in) {
                for (Object lastObject : lastObjects) {
                    ((BytesMarshallable)lastObject).readMarshallable(in);
                }
                return lastObjects;
            }
        };
    }
}

