/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import java.io.IOException;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.UnfilteredValidation;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.io.sstable.AbstractSSTableIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.big.IndexState;
import org.apache.cassandra.io.sstable.format.big.RowIndexEntry;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileHandle;

public class SSTableIterator
extends AbstractSSTableIterator<RowIndexEntry> {
    private int slice;

    public SSTableIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, RowIndexEntry indexEntry, Slices slices, ColumnFilter columns, FileHandle ifile) {
        super(sstable, file, key, indexEntry, slices, columns, ifile);
    }

    @Override
    protected AbstractSSTableIterator.Reader createReaderInternal(RowIndexEntry indexEntry, FileDataInput file, boolean shouldCloseFile, Version version) {
        return indexEntry.isIndexed() ? new ForwardIndexedReader(indexEntry, file, shouldCloseFile) : new AbstractSSTableIterator.ForwardReader(file, shouldCloseFile);
    }

    @Override
    protected int nextSliceIndex() {
        int next = this.slice++;
        return next;
    }

    @Override
    protected boolean hasMoreSlices() {
        return this.slice < this.slices.size();
    }

    @Override
    public boolean isReverseOrder() {
        return false;
    }

    private class ForwardIndexedReader
    extends AbstractSSTableIterator.ForwardReader {
        private final IndexState indexState;
        private int lastBlockIdx;

        private ForwardIndexedReader(RowIndexEntry indexEntry, FileDataInput file, boolean shouldCloseFile) {
            super(file, shouldCloseFile);
            this.indexState = new IndexState(this, ((SSTableIterator)SSTableIterator.this).metadata.comparator, indexEntry, false, SSTableIterator.this.ifile);
            this.lastBlockIdx = this.indexState.blocksCount();
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.indexState.close();
        }

        @Override
        public void setForSlice(Slice slice) throws IOException {
            super.setForSlice(slice);
            if (this.indexState.isDone()) {
                this.sliceDone = true;
                return;
            }
            int startIdx = this.indexState.findBlockIndex(slice.start(), this.indexState.currentBlockIdx());
            if (startIdx >= this.indexState.blocksCount()) {
                this.sliceDone = true;
                return;
            }
            this.lastBlockIdx = this.indexState.findBlockIndex(slice.end(), startIdx);
            if (this.lastBlockIdx < 0) {
                assert (startIdx < 0);
                this.sliceDone = true;
                return;
            }
            if (startIdx < 0) {
                startIdx = 0;
            }
            if (startIdx != this.indexState.currentBlockIdx()) {
                this.indexState.setToBlock(startIdx);
            }
            if (this.indexState.currentBlockIdx() == this.lastBlockIdx && SSTableIterator.this.metadata().comparator.compare(slice.end(), this.indexState.currentIndex().firstName) < 0 && this.openMarker == null) {
                this.sliceDone = true;
            }
        }

        @Override
        protected Unfiltered computeNext() throws IOException {
            Unfiltered next;
            do {
                this.indexState.updateBlock();
                if (this.indexState.isDone() || this.indexState.currentBlockIdx() > this.lastBlockIdx || !this.deserializer.hasNext() || this.indexState.currentBlockIdx() == this.lastBlockIdx && this.deserializer.compareNextTo(this.end) >= 0) {
                    return null;
                }
                next = this.deserializer.readNext();
                UnfilteredValidation.maybeValidateUnfiltered(next, SSTableIterator.this.metadata(), SSTableIterator.this.key, SSTableIterator.this.sstable);
            } while (next.isEmpty());
            if (next.kind() == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
                this.updateOpenMarker((RangeTombstoneMarker)next);
            }
            return next;
        }
    }
}

