/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.formatter.TableBuilder;

@Command(name="compactionstats", description="Print statistics on compactions")
public class CompactionStats
extends NodeTool.NodeToolCmd {
    @Option(title="human_readable", name={"-H", "--human-readable"}, description="Display bytes in human readable form, i.e. KiB, MiB, GiB, TiB")
    private boolean humanReadable = false;
    @Option(title="vtable_output", name={"-V", "--vtable"}, description="Display fields matching vtable output")
    private boolean vtableOutput = false;

    @Override
    public void execute(NodeProbe probe) {
        PrintStream out = probe.output().out;
        TableBuilder tableBuilder = new TableBuilder();
        this.pendingTasksAndConcurrentCompactorsStats(probe, tableBuilder);
        this.compactionsStats(probe, tableBuilder);
        CompactionStats.reportCompactionTable(probe.getCompactionManagerProxy().getCompactions(), probe.getCompactionThroughputBytes(), this.humanReadable, this.vtableOutput, out, tableBuilder);
    }

    private void pendingTasksAndConcurrentCompactorsStats(NodeProbe probe, TableBuilder tableBuilder) {
        Map pendingTaskNumberByTable = (Map)probe.getCompactionMetric("PendingTasksByTableName");
        tableBuilder.add("concurrent compactors", Integer.toString(probe.getConcurrentCompactors()));
        tableBuilder.add("pending tasks", Integer.toString(this.numPendingTasks(pendingTaskNumberByTable)));
        for (Map.Entry ksEntry : pendingTaskNumberByTable.entrySet()) {
            for (Map.Entry tableEntry : ((Map)ksEntry.getValue()).entrySet()) {
                tableBuilder.add((String)ksEntry.getKey(), (String)tableEntry.getKey(), ((Integer)tableEntry.getValue()).toString());
            }
        }
    }

    private int numPendingTasks(Map<String, Map<String, Integer>> pendingTaskNumberByTable) {
        int numTotalPendingTasks = 0;
        for (Map.Entry<String, Map<String, Integer>> ksEntry : pendingTaskNumberByTable.entrySet()) {
            for (Map.Entry<String, Integer> tableEntry : ksEntry.getValue().entrySet()) {
                numTotalPendingTasks += tableEntry.getValue().intValue();
            }
        }
        return numTotalPendingTasks;
    }

    private void compactionsStats(NodeProbe probe, TableBuilder tableBuilder) {
        CassandraMetricsRegistry.JmxMeterMBean totalCompactionsCompletedMetrics = (CassandraMetricsRegistry.JmxMeterMBean)probe.getCompactionMetric("TotalCompactionsCompleted");
        tableBuilder.add("compactions completed", String.valueOf(totalCompactionsCompletedMetrics.getCount()));
        CassandraMetricsRegistry.JmxCounterMBean bytesCompacted = (CassandraMetricsRegistry.JmxCounterMBean)probe.getCompactionMetric("BytesCompacted");
        if (this.humanReadable) {
            tableBuilder.add("data compacted", FileUtils.stringifyFileSize(Double.parseDouble(Long.toString(bytesCompacted.getCount()))));
        } else {
            tableBuilder.add("data compacted", Long.toString(bytesCompacted.getCount()));
        }
        CassandraMetricsRegistry.JmxCounterMBean compactionsAborted = (CassandraMetricsRegistry.JmxCounterMBean)probe.getCompactionMetric("CompactionsAborted");
        tableBuilder.add("compactions aborted", Long.toString(compactionsAborted.getCount()));
        CassandraMetricsRegistry.JmxCounterMBean compactionsReduced = (CassandraMetricsRegistry.JmxCounterMBean)probe.getCompactionMetric("CompactionsReduced");
        tableBuilder.add("compactions reduced", Long.toString(compactionsReduced.getCount()));
        CassandraMetricsRegistry.JmxCounterMBean sstablesDroppedFromCompaction = (CassandraMetricsRegistry.JmxCounterMBean)probe.getCompactionMetric("SSTablesDroppedFromCompaction");
        tableBuilder.add("sstables dropped from compaction", Long.toString(sstablesDroppedFromCompaction.getCount()));
        DecimalFormat formatter = new DecimalFormat("0.00");
        tableBuilder.add("15 minute rate", String.format("%s/minute", formatter.format(totalCompactionsCompletedMetrics.getFifteenMinuteRate() * 60.0)));
        tableBuilder.add("mean rate", String.format("%s/hour", formatter.format(totalCompactionsCompletedMetrics.getMeanRate() * 60.0 * 60.0)));
        double configured = probe.getStorageService().getCompactionThroughtputMibPerSecAsDouble();
        tableBuilder.add("compaction throughput (MiB/s)", configured == 0.0 ? "throttling disabled (0)" : Double.toString(configured));
    }

    public static void reportCompactionTable(List<Map<String, String>> compactions, long compactionThroughputInBytes, boolean humanReadable, PrintStream out, TableBuilder table) {
        CompactionStats.reportCompactionTable(compactions, compactionThroughputInBytes, humanReadable, false, out, table);
    }

    public static void reportCompactionTable(List<Map<String, String>> compactions, long compactionThroughputInBytes, boolean humanReadable, boolean vtableOutput, PrintStream out, TableBuilder table) {
        if (compactions.isEmpty()) {
            table.printTo(out);
            return;
        }
        long remainingBytes = 0L;
        if (vtableOutput) {
            table.add("keyspace", "table", "task id", "completion ratio", "kind", "progress", "sstables", "total", "unit", "target directory");
        } else {
            table.add("id", "compaction type", "keyspace", "table", "completed", "total", "unit", "progress");
        }
        for (Map<String, String> c : compactions) {
            long total = Long.parseLong(c.get("total"));
            long completed = Long.parseLong(c.get("completed"));
            String taskType = c.get("taskType");
            String keyspace = c.get("keyspace");
            String columnFamily = c.get("columnfamily");
            String unit = c.get("unit");
            boolean toFileSize = humanReadable && CompactionInfo.Unit.isFileSize(unit);
            String[] tables = c.get("sstables").split(",");
            String progressStr = toFileSize ? FileUtils.stringifyFileSize(completed) : Long.toString(completed);
            String totalStr = toFileSize ? FileUtils.stringifyFileSize(total) : Long.toString(total);
            String percentComplete = total == 0L ? "n/a" : new DecimalFormat("0.00").format((double)completed / (double)total * 100.0) + "%";
            String id = c.get("compactionId");
            if (vtableOutput) {
                String targetDirectory = c.get("targetDirectory");
                table.add(keyspace, columnFamily, id, percentComplete, taskType, progressStr, String.valueOf(tables.length), totalStr, unit, targetDirectory);
            } else {
                table.add(id, taskType, keyspace, columnFamily, progressStr, totalStr, unit, percentComplete);
            }
            remainingBytes += total - completed;
        }
        String remainingTime = "n/a";
        if (compactionThroughputInBytes != 0L) {
            long remainingTimeInSecs = remainingBytes / compactionThroughputInBytes;
            remainingTime = String.format("%dh%02dm%02ds", remainingTimeInSecs / 3600L, remainingTimeInSecs % 3600L / 60L, remainingTimeInSecs % 60L);
        }
        table.add("active compaction remaining time", remainingTime);
        table.printTo(out);
    }
}

