/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.math.BigDecimal;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.AbstractNumberConverterTest;
import org.apache.commons.beanutils2.converters.BigDecimalConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BigDecimalConverterTest
extends AbstractNumberConverterTest<BigDecimal> {
    private Converter<BigDecimal> converter;

    @Override
    protected Class<BigDecimal> getExpectedType() {
        return BigDecimal.class;
    }

    protected BigDecimalConverter makeConverter() {
        return new BigDecimalConverter();
    }

    protected BigDecimalConverter makeConverter(BigDecimal defaultValue) {
        return new BigDecimalConverter(defaultValue);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = new BigDecimal("-12");
        this.numbers[1] = new BigDecimal("13");
        this.numbers[2] = new BigDecimal("-22");
        this.numbers[3] = new BigDecimal("23");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Test
    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double", "from BigDecimal", "from BigDecimal extension"};
        Object[] input = new Object[]{"-17.2", "-1.1", "0.0", "1.1", "17.2", (byte)7, (short)8, 9, 10L, Float.valueOf("11.1"), Double.valueOf("12.2"), new BigDecimal("3200.11"), new ExtendingBigDecimal("3200.11")};
        BigDecimal[] expected = new BigDecimal[]{new BigDecimal("-17.2"), new BigDecimal("-1.1"), new BigDecimal("0.0"), new BigDecimal("1.1"), new BigDecimal("17.2"), new BigDecimal("7"), new BigDecimal("8"), new BigDecimal("9"), new BigDecimal("10"), new BigDecimal("11.1"), new BigDecimal("12.2"), new BigDecimal("3200.11"), new BigDecimal("3200.11")};
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)this.converter.convert(BigDecimal.class, input[i]), (String)(message[i] + " to BigDecimal"));
            Assertions.assertEquals((Object)expected[i], (Object)this.converter.convert(null, input[i]), (String)(message[i] + " to null type"));
        }
    }

    private static class ExtendingBigDecimal
    extends BigDecimal {
        private static final long serialVersionUID = 1L;

        private ExtendingBigDecimal(String val) {
            super(val);
        }
    }
}

