/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider;

import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import org.apache.harmony.jndi.internal.nls.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericURLContextFactory
implements ObjectFactory {
    protected GenericURLContextFactory() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws NamingException {
        Context context = this.createURLContext(environment);
        if (obj == null) {
            return context;
        }
        try {
            if (obj instanceof String) {
                Object object = context.lookup((String)obj);
                return object;
            }
            if (!(obj instanceof String[])) throw new IllegalArgumentException(Messages.getString("jndi.2D", obj));
            String[] strings = (String[])obj;
            if (strings.length < 1) {
                throw new ConfigurationException(Messages.getString("jndi.2C"));
            }
            NamingException exception = null;
            String[] stringArray = strings;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String element = stringArray[n];
                try {
                    Object object = context.lookup(element);
                    return object;
                }
                catch (NamingException e) {
                    exception = e;
                    ++n;
                    continue;
                    throw exception;
                }
            }
        }
        finally {
            context.close();
        }
    }

    protected abstract Context createURLContext(Hashtable<?, ?> var1);
}

