/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.ProviderMgr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SList {
    public static int NETWORK_FAILURE = 0x7FFFFFFC;
    public static int TIMEOUT = 0x7FFFFFFD;
    public static int SERVER_FAILURE = 0x7FFFFFFE;
    public static int UNKNOWN = 0;
    private Hashtable<String, Vector<Entry>> zones = new Hashtable();
    private Vector<Server> servers = new Vector();
    private static SList instance = new SList();

    private SList() {
    }

    static SList getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateEntry(String zone, Server server, int responseTime) {
        String normZoneName = ProviderMgr.normalizeName(zone);
        Entry entryToAdd = new Entry(normZoneName, this.getServerNum(server), responseTime);
        Hashtable<String, Vector<Entry>> hashtable = this.zones;
        synchronized (hashtable) {
            Vector<Entry> vect = this.zones.get(ProviderMgr.normalizeName(normZoneName));
            if (vect == null) {
                vect = new Vector();
                vect.addElement(entryToAdd);
                this.zones.put(normZoneName, vect);
            } else {
                Entry curEntry;
                boolean added = false;
                int i = 0;
                while (i < vect.size()) {
                    curEntry = vect.elementAt(i);
                    if (server.equals(this.serverAtNum(curEntry.getServerNum()))) {
                        vect.removeElementAt(i);
                        break;
                    }
                    ++i;
                }
                i = 0;
                while (i < vect.size()) {
                    curEntry = vect.elementAt(i);
                    if (responseTime < curEntry.getResponseTime()) {
                        vect.insertElementAt(entryToAdd, i);
                        added = true;
                        break;
                    }
                    ++i;
                }
                if (!added) {
                    vect.addElement(entryToAdd);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Server getBestGuess(String zone, Hashtable<Server, ?> serversToIgnore) {
        Hashtable<String, Vector<Entry>> hashtable = this.zones;
        synchronized (hashtable) {
            Vector<Entry> vect = this.zones.get(ProviderMgr.normalizeName(zone));
            if (vect != null && vect.size() > 0) {
                int i = 0;
                while (i < vect.size()) {
                    Entry entry = vect.elementAt(i);
                    if (serversToIgnore == null || serversToIgnore.get(this.serverAtNum(entry.getServerNum())) == null) {
                        return this.serverAtNum(entry.getServerNum());
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropServer(String zone, Server server) {
        Hashtable<String, Vector<Entry>> hashtable = this.zones;
        synchronized (hashtable) {
            Vector<Entry> vect = this.zones.get(ProviderMgr.normalizeName(zone));
            if (vect != null) {
                int i = 0;
                while (i < vect.size()) {
                    Entry entry = vect.elementAt(i);
                    if (server.equals(this.serverAtNum(entry.getServerNum()))) {
                        vect.removeElementAt(i);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasServer(String zone, Server server) {
        Hashtable<String, Vector<Entry>> hashtable = this.zones;
        synchronized (hashtable) {
            Vector<Entry> vect = this.zones.get(ProviderMgr.normalizeName(zone));
            if (vect == null) return false;
            int i = 0;
            while (true) {
                if (i >= vect.size()) {
                    return false;
                }
                Entry entry = vect.elementAt(i);
                if (server.equals(this.serverAtNum(entry.getServerNum()))) {
                    return true;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Server getServerByName(String zone, String name, int port) {
        Hashtable<String, Vector<Entry>> hashtable = this.zones;
        synchronized (hashtable) {
            Vector<Entry> vect = this.zones.get(ProviderMgr.normalizeName(zone));
            if (vect != null) {
                int i = 0;
                while (i < vect.size()) {
                    Entry entry = vect.elementAt(i);
                    if (ProviderMgr.namesAreEqual(name, this.serverAtNum(entry.getServerNum()).getName()) && port == this.serverAtNum(entry.getServerNum()).getPort()) {
                        return this.serverAtNum(entry.getServerNum());
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Server getServerByIP(String zone, String ip, int port) {
        Hashtable<String, Vector<Entry>> hashtable = this.zones;
        synchronized (hashtable) {
            Vector<Entry> vect = this.zones.get(ProviderMgr.normalizeName(zone));
            if (vect != null) {
                int i = 0;
                while (i < vect.size()) {
                    Entry entry = vect.elementAt(i);
                    if (ip.equals(this.serverAtNum(entry.getServerNum()).getIP()) && port == this.serverAtNum(entry.getServerNum()).getPort()) {
                        return this.serverAtNum(entry.getServerNum());
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Server getServerByServer(String zone, Server server) {
        Hashtable<String, Vector<Entry>> hashtable = this.zones;
        synchronized (hashtable) {
            Vector<Entry> vect = this.zones.get(ProviderMgr.normalizeName(zone));
            if (vect != null) {
                int i = 0;
                while (i < vect.size()) {
                    Entry entry = vect.elementAt(i);
                    if (server.equals(this.serverAtNum(entry.getServerNum()))) {
                        return this.serverAtNum(entry.getServerNum());
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Hashtable<String, Vector<Entry>> hashtable = this.zones;
        synchronized (hashtable) {
            this.zones = new Hashtable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getServerNum(Server server) {
        if (this.servers.contains(server)) {
            return this.servers.indexOf(server);
        }
        Vector<Server> vector = this.servers;
        synchronized (vector) {
            this.servers.addElement(server);
            return this.servers.size() - 1;
        }
    }

    private Server serverAtNum(int num) {
        if (num < this.servers.size()) {
            return this.servers.elementAt(num);
        }
        return null;
    }

    boolean hasServer(String hostname) {
        return this.servers.contains(new Server(hostname, null, 53));
    }

    Enumeration<Server> getServersByName(String name) {
        Vector<Server> result = new Vector<Server>();
        if (name == null) {
            throw new NullPointerException(Messages.getString("jndi.34"));
        }
        int i = 0;
        while (i < this.servers.size()) {
            Server curServ = this.servers.get(i);
            if (curServ.getName() != null && ProviderMgr.namesAreEqual(name, curServ.getName())) {
                result.addElement(curServ);
            }
            ++i;
        }
        return result.elements();
    }

    void setServerIP(String hostname, String newIP) {
        String nameNorm = ProviderMgr.normalizeName(hostname);
        int i = 0;
        while (i < this.servers.size()) {
            Server serv = this.servers.elementAt(i);
            if (nameNorm.equals(serv.getName()) && serv.getIP() == null) {
                serv.setIP(newIP);
                break;
            }
            ++i;
        }
    }

    static class Entry {
        private String zoneName;
        private int serverNum;
        private int responseTime;

        public Entry(String zoneName, int serverNum, int respTime) {
            this.zoneName = zoneName;
            this.serverNum = serverNum;
            this.responseTime = respTime;
        }

        public int getResponseTime() {
            return this.responseTime;
        }

        public void setResponseTime(int responseTime) {
            this.responseTime = responseTime;
        }

        public int getServerNum() {
            return this.serverNum;
        }

        public void setServerNum(int serverNum) {
            this.serverNum = serverNum;
        }

        public String getZoneName() {
            return this.zoneName;
        }

        public void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }
    }

    static class Server {
        private String serverName;
        private String serverIP;
        private int serverPort;

        public Server(String serverName, String serverIP, int serverPort) {
            this.serverName = ProviderMgr.normalizeName(serverName);
            this.serverIP = serverIP;
            this.serverPort = serverPort;
        }

        public boolean equals(Object obj) {
            Server srv = null;
            if (!(obj instanceof Server)) {
                return false;
            }
            srv = (Server)obj;
            if (this.serverIP == null || srv.getIP() == null) {
                if (this.getName() == null || srv.getName() == null) {
                    return false;
                }
                return ProviderMgr.namesAreEqual(this.getName(), srv.getName()) && this.getPort() == srv.getPort();
            }
            return this.getIP().equals(srv.getIP()) && this.getPort() == srv.getPort();
        }

        public String getIP() {
            return this.serverIP;
        }

        public String getName() {
            return this.serverName;
        }

        public int getPort() {
            return this.serverPort;
        }

        public void setIP(String serverIP) {
            this.serverIP = serverIP;
        }

        public void setName(String serverName) {
            this.serverName = ProviderMgr.normalizeName(serverName);
        }

        public void setPort(int serverPort) {
            this.serverPort = serverPort;
        }

        public String toString() {
            if (this.serverName != null) {
                return String.valueOf(this.serverName) + ":" + this.serverPort;
            }
            return String.valueOf(this.serverIP) + ":" + this.serverPort;
        }
    }
}

