/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.infoset;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.daffodil.api.Daffodil;
import org.apache.daffodil.api.DataProcessor;
import org.apache.daffodil.api.infoset.InfosetInputter;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Coroutine;
import org.apache.daffodil.lib.util.Maybe;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.dpath.NodeInfo$;
import org.apache.daffodil.runtime1.iapi.DFDL;
import org.apache.daffodil.runtime1.infoset.IllegalContentWhereEventExpected;
import org.apache.daffodil.runtime1.infoset.InvalidInfosetException;
import org.apache.daffodil.runtime1.infoset.NonTextFoundInSimpleContentException;
import org.apache.daffodil.runtime1.infoset.SAXInfosetEvent;
import org.apache.daffodil.runtime1.processors.DaffodilUnparseContentHandlerImpl;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.package$;
import scala.runtime.Statics;

public class SAXInfosetInputter
extends InfosetInputter
implements Coroutine<SAXInfosetEvent[]> {
    private int org$apache$daffodil$lib$util$Coroutine$$queueCapacity;
    private ArrayBlockingQueue org$apache$daffodil$lib$util$Coroutine$$inboundQueue;
    private Coroutine org$apache$daffodil$lib$util$Coroutine$$self;
    private Option org$apache$daffodil$lib$util$Coroutine$$thread_;
    private final DaffodilUnparseContentHandlerImpl unparseContentHandler;
    private final DataProcessor dp;
    private final WritableByteChannel output;
    private final boolean resolveRelativeInfosetBlobURIs;
    private int currentIndex;
    private SAXInfosetEvent[] batchedInfosetEvents;

    public SAXInfosetInputter(DaffodilUnparseContentHandlerImpl unparseContentHandler, DataProcessor dp, WritableByteChannel output, boolean resolveRelativeInfosetBlobURIs) {
        this.unparseContentHandler = unparseContentHandler;
        this.dp = dp;
        this.output = output;
        this.resolveRelativeInfosetBlobURIs = resolveRelativeInfosetBlobURIs;
        Coroutine.$init$(this);
        this.currentIndex = 0;
        Statics.releaseFence();
    }

    @Override
    public int org$apache$daffodil$lib$util$Coroutine$$queueCapacity() {
        return this.org$apache$daffodil$lib$util$Coroutine$$queueCapacity;
    }

    @Override
    public ArrayBlockingQueue org$apache$daffodil$lib$util$Coroutine$$inboundQueue() {
        return this.org$apache$daffodil$lib$util$Coroutine$$inboundQueue;
    }

    @Override
    public Coroutine org$apache$daffodil$lib$util$Coroutine$$self() {
        return this.org$apache$daffodil$lib$util$Coroutine$$self;
    }

    @Override
    public Option org$apache$daffodil$lib$util$Coroutine$$thread_() {
        return this.org$apache$daffodil$lib$util$Coroutine$$thread_;
    }

    @Override
    public void org$apache$daffodil$lib$util$Coroutine$$thread__$eq(Option x$1) {
        this.org$apache$daffodil$lib$util$Coroutine$$thread_ = x$1;
    }

    @Override
    public void org$apache$daffodil$lib$util$Coroutine$_setter_$org$apache$daffodil$lib$util$Coroutine$$queueCapacity_$eq(int x$0) {
        this.org$apache$daffodil$lib$util$Coroutine$$queueCapacity = x$0;
    }

    @Override
    public void org$apache$daffodil$lib$util$Coroutine$_setter_$org$apache$daffodil$lib$util$Coroutine$$inboundQueue_$eq(ArrayBlockingQueue x$0) {
        this.org$apache$daffodil$lib$util$Coroutine$$inboundQueue = x$0;
    }

    @Override
    public void org$apache$daffodil$lib$util$Coroutine$_setter_$org$apache$daffodil$lib$util$Coroutine$$self_$eq(Coroutine x$0) {
        this.org$apache$daffodil$lib$util$Coroutine$$self = x$0;
    }

    private SAXInfosetEvent currentEvent() {
        return this.batchedInfosetEvents[this.currentIndex];
    }

    @Override
    public Daffodil.InfosetInputterEventType getEventType() {
        Object object = this.currentEvent().eventType();
        return (Daffodil.InfosetInputterEventType)((Object)Maybe$.MODULE$.get$extension(object));
    }

    @Override
    public String getLocalName() {
        Object object = this.currentEvent().localName();
        return (String)Maybe$.MODULE$.get$extension(object);
    }

    @Override
    public String getNamespaceURI() {
        Object object = this.currentEvent().namespaceURI();
        return (String)Maybe$.MODULE$.orNull$extension(object);
    }

    @Override
    public String getSimpleText(NodeInfo.Kind primType, Map<String, String> runtimeProperties) {
        Object object = this.currentEvent().simpleText();
        if (!Maybe$.MODULE$.isDefined$extension(object)) {
            throw new NonTextFoundInSimpleContentException(this.getLocalName());
        }
        Object object2 = this.currentEvent().simpleText();
        String res = (String)Maybe$.MODULE$.get$extension(object2);
        if (primType == NodeInfo$.MODULE$.String()) {
            String remapped = XMLUtils$.MODULE$.remapPUAToXMLIllegalCharacters(res);
            return remapped;
        }
        if (this.resolveRelativeInfosetBlobURIs && primType == NodeInfo$.MODULE$.AnyURI() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(res))) {
            String absUri = this.resolveRelativeBlobURIs(res);
            return absUri;
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean isNilled() {
        Boolean bl;
        String nilValue;
        block8: {
            block7: {
                Object object = this.currentEvent().nilValue();
                if (!Maybe$.MODULE$.isDefined$extension(object)) return null;
                Object object2 = this.currentEvent().nilValue();
                String string = nilValue = (String)Maybe$.MODULE$.get$extension(object2);
                String string2 = "true";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block7;
                String string3 = nilValue;
                String string4 = "1";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block8;
            }
            bl = Predef$.MODULE$.boolean2Boolean(true);
            return bl;
        }
        String string = nilValue;
        String string5 = "false";
        if (string == null ? string5 != null : !string.equals(string5)) {
            String string6 = nilValue;
            String string7 = "0";
            if (string6 == null) {
                if (string7 != null) {
                    throw new InvalidInfosetException("xsi:nil property is not a valid boolean: '" + nilValue + "' for element " + this.getLocalName());
                }
            } else if (!string6.equals(string7)) throw new InvalidInfosetException("xsi:nil property is not a valid boolean: '" + nilValue + "' for element " + this.getLocalName());
        }
        bl = Predef$.MODULE$.boolean2Boolean(false);
        return bl;
    }

    @Override
    public boolean hasNext() {
        Object object = this.currentEvent().eventType();
        return (Daffodil.InfosetInputterEventType)((Object)Maybe$.MODULE$.get$extension(object)) != Daffodil.InfosetInputterEventType.EndDocument;
    }

    @Override
    public void next() {
        if (!this.hasNext()) {
            throw Assert$.MODULE$.usageError("SAXInfosetInputter.this.hasNext()");
        }
        this.currentEvent().clear();
        if (this.currentIndex == this.batchedInfosetEvents.length - 1) {
            this.batchedInfosetEvents = (SAXInfosetEvent[])this.resume((Coroutine)this.unparseContentHandler, new Maybe(Maybe$.MODULE$.Nope()));
            this.currentIndex = 0;
        } else {
            ++this.currentIndex;
        }
        Object object = this.currentEvent().mixedContent();
        if (Maybe$.MODULE$.isDefined$extension(object)) {
            Object object2 = this.currentEvent().eventType();
            String eventType = (Daffodil.InfosetInputterEventType)((Object)Maybe$.MODULE$.get$extension(object2)) == Daffodil.InfosetInputterEventType.StartElement ? "start" : "end";
            Object object3 = this.currentEvent().namespaceURI();
            Object object4 = this.currentEvent().localName();
            String element = "{" + (String)Maybe$.MODULE$.get$extension(object3) + "}" + (String)Maybe$.MODULE$.get$extension(object4);
            String msg = "Mixed content found prior to " + eventType + " of " + element;
            throw new IllegalContentWhereEventExpected(msg);
        }
    }

    private String resolveRelativeBlobURIs(String res) {
        String string;
        block3: {
            try {
                URI uri = new URI(res);
                if (!uri.getPath().startsWith("/")) {
                    Option<URI> abs = Misc$.MODULE$.searchResourceOption(uri.getPath(), (Option<URI>)None$.MODULE$);
                    string = ((URI)abs.get()).toString();
                    break block3;
                }
                string = res;
            }
            catch (URISyntaxException uRISyntaxException) {
                string = res;
            }
        }
        return string;
    }

    @Override
    public boolean getSupportsNamespaces() {
        return true;
    }

    @Override
    public void fini() {
    }

    @Override
    public void run() {
        try {
            this.batchedInfosetEvents = (SAXInfosetEvent[])this.waitForResume();
            DFDL.UnparseResult unparseResult = (DFDL.UnparseResult)this.dp.unparse(this, this.output);
            this.resumeFinal((Coroutine)this.unparseContentHandler, new Maybe(Maybe$One$.MODULE$.apply(package$.MODULE$.Right().apply((Object)unparseResult))));
        }
        catch (Exception e) {
            this.resumeFinal((Coroutine)this.unparseContentHandler, new Maybe(Maybe$One$.MODULE$.apply(package$.MODULE$.Left().apply((Object)e))));
        }
    }
}

