/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.main.api.sax;

import com.siemens.ct.exi.core.Constants;
import com.siemens.ct.exi.core.EXIBodyDecoder;
import com.siemens.ct.exi.core.EXIFactory;
import com.siemens.ct.exi.core.EXIStreamDecoder;
import com.siemens.ct.exi.core.SchemaIdResolver;
import com.siemens.ct.exi.core.container.DocType;
import com.siemens.ct.exi.core.container.NamespaceDeclaration;
import com.siemens.ct.exi.core.container.ProcessingInstruction;
import com.siemens.ct.exi.core.context.QNameContext;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.grammars.event.EventType;
import com.siemens.ct.exi.core.values.ListValue;
import com.siemens.ct.exi.core.values.Value;
import com.siemens.ct.exi.core.values.ValueType;
import com.siemens.ct.exi.main.helpers.DefaultSchemaIdResolver;
import com.siemens.ct.exi.main.util.NoEntityResolver;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.List;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXDecoder
implements XMLReader {
    protected EXIFactory noOptionsFactory;
    protected EXIStreamDecoder exiStream;
    protected ContentHandler contentHandler;
    protected DTDHandler dtdHandler;
    protected LexicalHandler lexicalHandler;
    protected DeclHandler declHandler;
    protected ErrorHandler errorHandler;
    protected static final String ATTRIBUTE_TYPE = "CDATA";
    protected static final int DEFAULT_CHAR_BUFFER_SIZE = 4096;
    protected char[] cbuffer;
    protected boolean namespaces = true;
    protected boolean namespacePrefixes = false;
    protected boolean exiBodyOnly = false;
    protected StringBuilder sbHelper;

    protected SAXDecoder(EXIFactory noOptionsFactory, char[] cbuffer) throws EXIException {
        this.noOptionsFactory = noOptionsFactory;
        if (noOptionsFactory.getSchemaIdResolver() == null) {
            noOptionsFactory.setSchemaIdResolver((SchemaIdResolver)new DefaultSchemaIdResolver());
        }
        this.exiStream = noOptionsFactory.createEXIStreamDecoder();
        if (noOptionsFactory.getFidelityOptions().isFidelityEnabled("PRESERVE_PREFIXES")) {
            this.namespacePrefixes = true;
        }
        this.cbuffer = cbuffer;
    }

    public SAXDecoder(EXIFactory noOptionsFactory) throws EXIException {
        this(noOptionsFactory, new char[4096]);
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            return this.namespaces;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            return this.namespacePrefixes;
        }
        return false;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            this.namespaces = value;
        } else if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            this.namespacePrefixes = value;
        } else if ("http://www.w3.org/exi/features/exi-body-only".equals(name)) {
            this.exiBodyOnly = value;
        } else {
            throw new SAXNotRecognizedException(name);
        }
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            this.lexicalHandler = (LexicalHandler)value;
        } else if ("http://xml.org/sax/properties/declaration-handler".equals(name)) {
            this.declHandler = (DeclHandler)value;
        } else {
            throw new SAXNotRecognizedException(name);
        }
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            return this.lexicalHandler;
        }
        if ("http://xml.org/sax/properties/declaration-handler".equals(name)) {
            return this.declHandler;
        }
        return null;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        FileInputStream fis = new FileInputStream(systemId);
        InputSource is = new InputSource(fis);
        this.parse(is);
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        assert (inputSource != null);
        assert (this.exiStream != null);
        if (this.contentHandler == null) {
            throw new SAXException("No content handler set!");
        }
        try {
            InputStream is = inputSource.getByteStream();
            if (is == null && inputSource.getSystemId() != null) {
                is = new FileInputStream(inputSource.getSystemId());
            }
            if (is == null) {
                throw new EXIException("No valid input source " + is);
            }
            EXIBodyDecoder decoder = this.exiBodyOnly ? this.exiStream.getBodyOnlyDecoder(is) : this.exiStream.decodeHeader(is);
            this.parseEXIEvents(decoder);
        }
        catch (EXIException e) {
            throw new SAXException("EXI " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (IllegalArgumentException i) {
            throw new SAXException("Error decoding EXI file: " + i.getLocalizedMessage());
        }
    }

    protected void parseEXIEvents(EXIBodyDecoder decoder) throws IOException, EXIException, SAXException {
        EventType eventType;
        QNameContext deferredStartElement = null;
        boolean isStartElementDeferred = false;
        AttributesImpl attributes = new AttributesImpl();
        block23: while ((eventType = decoder.next()) != null) {
            switch (eventType) {
                case START_DOCUMENT: {
                    decoder.decodeStartDocument();
                    this.contentHandler.startDocument();
                    continue block23;
                }
                case END_DOCUMENT: {
                    decoder.decodeEndDocument();
                    this.contentHandler.endDocument();
                    continue block23;
                }
                case ATTRIBUTE_XSI_NIL: {
                    this.handleAttribute(decoder, decoder.decodeAttributeXsiNil(), attributes);
                    continue block23;
                }
                case ATTRIBUTE_XSI_TYPE: {
                    this.handleAttribute(decoder, decoder.decodeAttributeXsiType(), attributes);
                    continue block23;
                }
                case ATTRIBUTE: 
                case ATTRIBUTE_NS: 
                case ATTRIBUTE_GENERIC: 
                case ATTRIBUTE_GENERIC_UNDECLARED: 
                case ATTRIBUTE_INVALID_VALUE: 
                case ATTRIBUTE_ANY_INVALID_VALUE: {
                    this.handleAttribute(decoder, decoder.decodeAttribute(), attributes);
                    continue block23;
                }
                case NAMESPACE_DECLARATION: {
                    decoder.decodeNamespaceDeclaration();
                    continue block23;
                }
                case SELF_CONTAINED: {
                    decoder.decodeStartSelfContainedFragment();
                    continue block23;
                }
                case START_ELEMENT: 
                case START_ELEMENT_NS: 
                case START_ELEMENT_GENERIC: 
                case START_ELEMENT_GENERIC_UNDECLARED: {
                    if (isStartElementDeferred) {
                        this.handleDeferredStartElement(decoder, deferredStartElement, attributes);
                    }
                    deferredStartElement = decoder.decodeStartElement();
                    isStartElementDeferred = true;
                    continue block23;
                }
                case END_ELEMENT: 
                case END_ELEMENT_UNDECLARED: {
                    if (isStartElementDeferred) {
                        this.handleDeferredStartElement(decoder, deferredStartElement, attributes);
                        isStartElementDeferred = false;
                    }
                    List eePrefixes = null;
                    if (this.namespaces) {
                        eePrefixes = decoder.getDeclaredPrefixDeclarations();
                    }
                    String eeQNameAsString = decoder.getElementQNameAsString();
                    QNameContext eeQName = decoder.decodeEndElement();
                    this.contentHandler.endElement(eeQName.getNamespaceUri(), eeQName.getLocalName(), eeQNameAsString);
                    if (!this.namespaces || eePrefixes == null) continue block23;
                    for (int i = 0; i < eePrefixes.size(); ++i) {
                        NamespaceDeclaration ns = (NamespaceDeclaration)eePrefixes.get(i);
                        this.contentHandler.endPrefixMapping(ns.prefix);
                    }
                    continue block23;
                }
                case CHARACTERS: 
                case CHARACTERS_GENERIC: 
                case CHARACTERS_GENERIC_UNDECLARED: {
                    if (isStartElementDeferred) {
                        this.handleDeferredStartElement(decoder, deferredStartElement, attributes);
                        isStartElementDeferred = false;
                    }
                    Value val = decoder.decodeCharacters();
                    switch (val.getValueType()) {
                        case BOOLEAN: 
                        case STRING: {
                            char[] chars = val.getCharacters();
                            this.contentHandler.characters(chars, 0, chars.length);
                            break;
                        }
                        case LIST: {
                            char[] chars;
                            ListValue lv = (ListValue)val;
                            Value[] values = lv.toValues();
                            if (values.length <= 0) continue block23;
                            ValueType vt = values[0].getValueType();
                            block25: for (int i = 0; i < values.length; ++i) {
                                Value val2 = values[i];
                                switch (vt) {
                                    case BOOLEAN: 
                                    case STRING: {
                                        chars = val2.getCharacters();
                                        this.contentHandler.characters(chars, 0, chars.length);
                                        this.contentHandler.characters(Constants.XSD_LIST_DELIM_CHAR_ARRAY, 0, Constants.XSD_LIST_DELIM_CHAR_ARRAY.length);
                                        continue block25;
                                    }
                                    default: {
                                        int offset = 0;
                                        int len = val2.getCharactersLength();
                                        if (this.cbuffer.length < offset + len + 1) {
                                            this.contentHandler.characters(this.cbuffer, 0, offset);
                                            offset = 0;
                                        }
                                        val2.getCharacters(this.cbuffer, offset);
                                        offset += len;
                                        this.cbuffer[offset++] = 32;
                                        this.contentHandler.characters(this.cbuffer, 0, offset);
                                    }
                                }
                            }
                            continue block23;
                        }
                        default: {
                            int slen = val.getCharactersLength();
                            this.ensureBufferCapacity(slen);
                            val.getCharacters(this.cbuffer, 0);
                            this.contentHandler.characters(this.cbuffer, 0, slen);
                        }
                    }
                    continue block23;
                }
                case DOC_TYPE: {
                    if (isStartElementDeferred) {
                        this.handleDeferredStartElement(decoder, deferredStartElement, attributes);
                        isStartElementDeferred = false;
                    }
                    this.handleDocType(decoder.decodeDocType());
                    continue block23;
                }
                case ENTITY_REFERENCE: {
                    if (isStartElementDeferred) {
                        this.handleDeferredStartElement(decoder, deferredStartElement, attributes);
                        isStartElementDeferred = false;
                    }
                    this.handleEntityReference(decoder.decodeEntityReference());
                    continue block23;
                }
                case COMMENT: {
                    if (isStartElementDeferred) {
                        this.handleDeferredStartElement(decoder, deferredStartElement, attributes);
                        isStartElementDeferred = false;
                    }
                    this.handleComment(decoder.decodeComment());
                    continue block23;
                }
                case PROCESSING_INSTRUCTION: {
                    if (isStartElementDeferred) {
                        this.handleDeferredStartElement(decoder, deferredStartElement, attributes);
                        isStartElementDeferred = false;
                    }
                    ProcessingInstruction pi = decoder.decodeProcessingInstruction();
                    this.contentHandler.processingInstruction(pi.target, pi.data);
                    continue block23;
                }
            }
            throw new RuntimeException("Unexpected EXI Event '" + eventType + "' ");
        }
    }

    protected void handleDeferredStartElement(EXIBodyDecoder decoder, QNameContext deferredStartElement, AttributesImpl attributes) throws SAXException, IOException, EXIException {
        List prefixes;
        if (this.namespaces && (prefixes = decoder.getDeclaredPrefixDeclarations()) != null) {
            for (int i = 0; i < prefixes.size(); ++i) {
                NamespaceDeclaration ns = (NamespaceDeclaration)prefixes.get(i);
                this.contentHandler.startPrefixMapping(ns.prefix, ns.namespaceURI);
            }
        }
        String seQNameAsString = decoder.getElementQNameAsString();
        this.contentHandler.startElement(deferredStartElement.getNamespaceUri(), deferredStartElement.getLocalName(), seQNameAsString, attributes);
        attributes.clear();
    }

    protected void ensureBufferCapacity(int reqSize) {
        if (reqSize > this.cbuffer.length) {
            int newSize = this.cbuffer.length;
            while ((newSize <<= 2) < reqSize) {
            }
            this.cbuffer = new char[newSize];
        }
    }

    protected void handleAttribute(EXIBodyDecoder decoder, QNameContext atQName, AttributesImpl attributes) throws SAXException, IOException, EXIException {
        String sVal;
        Value val = decoder.getAttributeValue();
        switch (val.getValueType()) {
            case BOOLEAN: 
            case STRING: {
                sVal = val.toString();
                break;
            }
            case LIST: {
                ListValue lv = (ListValue)val;
                if (lv.getNumberOfValues() > 0) {
                    if (this.sbHelper == null) {
                        this.sbHelper = new StringBuilder();
                    } else {
                        this.sbHelper.setLength(0);
                    }
                    Value[] values = lv.toValues();
                    ValueType vt = values[0].getValueType();
                    block7: for (int i = 0; i < values.length; ++i) {
                        Value val2 = values[i];
                        switch (vt) {
                            case BOOLEAN: 
                            case STRING: {
                                this.sbHelper.append(val2.getCharacters());
                                this.sbHelper.append(' ');
                                continue block7;
                            }
                            default: {
                                int slen = val2.getCharactersLength();
                                this.ensureBufferCapacity(slen);
                                val2.getCharacters(this.cbuffer, 0);
                                this.sbHelper.append(this.cbuffer, 0, slen);
                                this.sbHelper.append(' ');
                            }
                        }
                    }
                    sVal = this.sbHelper.toString();
                    break;
                }
                sVal = "";
                break;
            }
            default: {
                int slen = val.getCharactersLength();
                this.ensureBufferCapacity(slen);
                sVal = val.toString(this.cbuffer, 0);
            }
        }
        String atQNameAsString = decoder.getAttributeQNameAsString();
        attributes.addAttribute(atQName.getNamespaceUri(), atQName.getLocalName(), atQNameAsString, ATTRIBUTE_TYPE, sVal);
    }

    protected void handleDocType(DocType docType) throws SAXException, IOException {
        if (this.lexicalHandler != null) {
            String name = new String(docType.name);
            String publicId = docType.publicID.length == 0 ? null : new String(docType.publicID);
            String systemId = docType.systemID.length == 0 ? null : new String(docType.systemID);
            this.contentHandler.characters(new char[0], 0, 0);
            this.lexicalHandler.startDTD(name, publicId, systemId);
            if (docType.text.length > 0) {
                DeclHandler dh = null;
                if (this.declHandler != null) {
                    dh = this.declHandler;
                } else if (this.lexicalHandler instanceof DeclHandler) {
                    dh = (DeclHandler)((Object)this.lexicalHandler);
                }
                if (dh != null) {
                    DocTypeTextLexicalHandler dttlh = new DocTypeTextLexicalHandler(dh);
                    dttlh.parse(docType.text);
                }
            }
            this.lexicalHandler.endDTD();
        }
    }

    protected void handleEntityReference(char[] erName) throws SAXException {
        String entityReferenceName = new String(erName);
        this.contentHandler.skippedEntity(entityReferenceName);
    }

    protected void handleComment(char[] comment) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(comment, 0, comment.length);
        }
    }

    static class DocTypeTextLexicalHandler {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();

        public DocTypeTextLexicalHandler(DeclHandler dh) throws SAXException {
            this.xmlReader.setFeature("http://xml.org/sax/features/resolve-dtd-uris", false);
            this.xmlReader.setEntityResolver(new NoEntityResolver());
            this.xmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", dh);
        }

        public void parse(char[] docTypeText) throws IOException, SAXException {
            StringBuilder dt = new StringBuilder();
            dt.append("<!DOCTYPE foo_name [ ");
            dt.append(docTypeText);
            dt.append("]>");
            dt.append("<foo />");
            StringReader r = new StringReader(dt.toString());
            this.xmlReader.parse(new InputSource(r));
        }
    }
}

