/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.outlet;

import java.util.Arrays;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.torque.generator.GeneratorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutletResult {
    private String stringResult;
    private byte[] byteArrayResult;

    public OutletResult(String stringResult) {
        this.stringResult = stringResult;
    }

    public OutletResult(byte[] byteArrayResult) {
        this.byteArrayResult = byteArrayResult;
    }

    public String getStringResult() {
        return this.stringResult;
    }

    public byte[] getByteArrayResult() {
        return this.byteArrayResult;
    }

    public boolean isStringResult() {
        return this.byteArrayResult == null;
    }

    public boolean isByteArrayResult() {
        return this.stringResult == null;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder().append((Object)this.stringResult).append(this.byteArrayResult);
        return hashCodeBuilder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OutletResult other = (OutletResult)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder().append((Object)this.stringResult, (Object)other.stringResult).append(this.byteArrayResult, other.byteArrayResult);
        return equalsBuilder.isEquals();
    }

    public static OutletResult concatenate(OutletResult ... input) throws GeneratorException {
        if (input == null) {
            throw new NullPointerException("input must not be null");
        }
        return OutletResult.concatenate(Arrays.asList(input));
    }

    public static OutletResult concatenate(Iterable<OutletResult> input) throws GeneratorException {
        if (input == null) {
            throw new NullPointerException("input must not be null");
        }
        if (!input.iterator().hasNext()) {
            throw new IllegalArgumentException("input must not be empty");
        }
        Boolean isStringResult = null;
        for (OutletResult part : input) {
            if (!part.isByteArrayResult()) {
                isStringResult = true;
                break;
            }
            if (part.isStringResult()) continue;
            isStringResult = false;
            break;
        }
        if (isStringResult == null) {
            return new OutletResult((String)null);
        }
        if (Boolean.TRUE.equals(isStringResult)) {
            StringBuilder result = new StringBuilder();
            for (OutletResult part : input) {
                if (!part.isStringResult()) {
                    throw new GeneratorException("first OutletResult to concatenate is a String result but a following result is a byte array. All concatenated results must be of the same type");
                }
                String partContent = part.getStringResult();
                if (partContent == null) continue;
                result.append(partContent);
            }
            return new OutletResult(result.toString());
        }
        int totalLength = 0;
        for (OutletResult part : input) {
            if (!part.isByteArrayResult()) {
                throw new GeneratorException("first OutletResult to concatenate is a byte array result but a following result is a String result. All concatenated results must be of the same type");
            }
            byte[] partContent = part.getByteArrayResult();
            if (partContent == null) continue;
            totalLength += partContent.length;
        }
        byte[] result = new byte[totalLength];
        int alreadyFilledBytes = 0;
        for (OutletResult part : input) {
            byte[] partContent = part.getByteArrayResult();
            if (partContent == null) continue;
            System.arraycopy(partContent, 0, result, alreadyFilledBytes, partContent.length);
            alreadyFilledBytes += partContent.length;
        }
        return new OutletResult(result);
    }
}

