/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceException;
import org.apache.torque.generator.source.SourceImpl;
import org.apache.torque.generator.source.stream.SourceToXml;
import org.apache.torque.generator.source.stream.StreamSourceFormat;

public class FileSource
extends SourceImpl {
    private static Log log = LogFactory.getLog(FileSource.class);
    private final StreamSourceFormat format;
    private final File path;
    private final ControllerState controllerState;

    public FileSource(StreamSourceFormat format, File path, ControllerState controllerState) {
        if (path == null) {
            throw new NullPointerException("path must not be null");
        }
        if (format == null) {
            throw new NullPointerException("format must not be null");
        }
        if (controllerState == null) {
            throw new NullPointerException("controllerState must not be null");
        }
        this.format = format;
        this.path = path;
        this.controllerState = controllerState;
    }

    public StreamSourceFormat getSourceFormat() {
        return this.format;
    }

    public File getPath() {
        return this.path;
    }

    public SourceElement createRootElement() throws SourceException {
        SourceElement result;
        if (log.isDebugEnabled()) {
            log.debug((Object)"start creating root Element");
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this.path);
            log.debug((Object)("Reading file " + this.path.getAbsolutePath() + " of type " + this.format.getKey()));
            result = this.format.parse(inputStream, this.controllerState);
        }
        catch (FileNotFoundException e) {
            throw new SourceException("File not found: " + this.path.getAbsolutePath(), e);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    log.error((Object)"error closing input stream", (Throwable)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("finished creating root Element, source is\n" + new SourceToXml().toXml(result, true)));
        }
        return result;
    }

    public String getDescription() {
        return this.path.getAbsolutePath();
    }

    public File getSourceFile() {
        return this.path;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("(path=").append(this.path).append(",type=").append(this.format);
        return result.toString();
    }
}

