/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class VarIntUtils {
    public static int varIntLength(long val) {
        ++val;
        int len = 0;
        while ((val & 0xFFFFFFFFFFFFFF80L) != 0L) {
            ++len;
            val >>>= 7;
        }
        return len + 1;
    }

    public static int writeVarInt(long val, DataOutput out) throws IOException {
        ++val;
        int written = 0;
        while ((val & 0xFFFFFFFFFFFFFF80L) != 0L) {
            byte b = (byte)(val | 0x80L);
            out.writeByte(b);
            val >>>= 7;
            ++written;
        }
        out.writeByte((byte)val);
        return written + 1;
    }

    public static int putVarIntToBytes(long val, byte[] bytes, int off) {
        ++val;
        int pos = off;
        while ((val & 0xFFFFFFFFFFFFFF80L) != 0L) {
            byte b = (byte)(val | 0x80L);
            bytes[pos++] = b;
            val >>>= 7;
        }
        bytes[pos++] = (byte)val;
        return pos - off;
    }

    public static long readVarInt(ByteBuffer buf) {
        long res = 0L;
        int shift = 0;
        while (true) {
            byte b = buf.get();
            res |= ((long)b & 0x7FL) << shift;
            if (b >= 0) break;
            shift += 7;
        }
        return res - 1L;
    }

    public static long readVarInt(byte[] bytes, int off) {
        long res = 0L;
        int index = off;
        int shift = 0;
        while (true) {
            byte b = bytes[index++];
            res |= ((long)b & 0x7FL) << shift;
            if (b >= 0) break;
            shift += 7;
        }
        return res - 1L;
    }

    public static long readVarInt(DataInput in) throws IOException {
        long res = 0L;
        int shift = 0;
        while (true) {
            byte b = in.readByte();
            res |= ((long)b & 0x7FL) << shift;
            if (b >= 0) break;
            shift += 7;
        }
        return res - 1L;
    }
}

