/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class SlidingAverageValueTracker {
    private final AtomicLongArray buffer;
    private final int capacity;
    private final int minValuesCount;
    private final double defaultValue;
    private final AtomicInteger limitedCount = new AtomicInteger(0);
    private final AtomicInteger index = new AtomicInteger(0);
    private final AtomicLong sum = new AtomicLong(0L);

    public SlidingAverageValueTracker(int capacity, int minValuesCount, double defaultValue) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be > 0.");
        }
        this.capacity = capacity;
        this.minValuesCount = minValuesCount;
        this.defaultValue = defaultValue;
        this.buffer = new AtomicLongArray(capacity);
    }

    public void record(long value) {
        int i = this.index.getAndUpdate(n -> (n + 1) % this.capacity);
        long old = this.buffer.getAndSet(i, value);
        int cnt = this.limitedCount.updateAndGet(n -> n < this.capacity ? n + 1 : n);
        if (cnt == this.capacity) {
            this.sum.addAndGet(value - old);
        } else {
            this.sum.addAndGet(value);
        }
    }

    public double avg() {
        if (this.limitedCount.get() < this.minValuesCount) {
            return this.defaultValue;
        }
        return (double)this.sum.get() / (double)this.limitedCount.get();
    }
}

