/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.MetricSource;
import org.jetbrains.annotations.Nullable;

public class PartitionModificationCounterMetricSource
implements MetricSource {
    public static final String METRIC_COUNTER = "modificationCount";
    public static final String METRIC_NEXT_MILESTONE = "nextMilestone";
    public static final String METRIC_LAST_MILESTONE_TIMESTAMP = "lastMilestoneTimestamp";
    private final Map<String, Metric> metrics = new HashMap<String, Metric>();
    private final String metricSourceName;
    private boolean enabled;

    public PartitionModificationCounterMetricSource(int tableId, int partitionId) {
        this.metricSourceName = PartitionModificationCounterMetricSource.formatSourceName(tableId, partitionId);
    }

    public String name() {
        return this.metricSourceName;
    }

    @Nullable
    public MetricSet enable() {
        if (this.enabled) {
            return null;
        }
        this.enabled = true;
        return new MetricSet(this.metricSourceName, Map.copyOf(this.metrics));
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void addMetric(Metric metric) {
        assert (!this.enabled) : "Metrics can be added only before enabling the metric source";
        this.metrics.put(metric.name(), metric);
    }

    public static String formatSourceName(int tableId, int partitionId) {
        return IgniteStringFormatter.format((String)"partition.statistics.table.{}.partition.{}", (Object[])new Object[]{tableId, partitionId});
    }
}

