/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.rules.ImmutableJoinConditionExpandIsNotDistinctFromRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.immutables.value.Value;

@Value.Enclosing
public final class JoinConditionExpandIsNotDistinctFromRule
extends RelRule<Config>
implements TransformationRule {
    JoinConditionExpandIsNotDistinctFromRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        RexNode oldJoinCond = join.getCondition();
        RexCall found = RexUtil.findOperatorCall(SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, oldJoinCond);
        if (found == null) {
            return;
        }
        for (RexNode op : found.getOperands()) {
            if (op.getType().getSqlTypeName() != SqlTypeName.MAP) continue;
            return;
        }
        RemoveIsNotDistinctFromRexShuttle rewriteShuttle = new RemoveIsNotDistinctFromRexShuttle(join.getCluster().getRexBuilder());
        RelNode newJoin = join.accept(rewriteShuttle);
        assert (newJoin instanceof Join);
        if (((Join)newJoin).getCondition().equals(join.getCondition())) {
            return;
        }
        call.transformTo(newJoin);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableJoinConditionExpandIsNotDistinctFromRule.Config.of().withOperandSupplier(b -> b.operand(Join.class).anyInputs());

        @Override
        default public JoinConditionExpandIsNotDistinctFromRule toRule() {
            return new JoinConditionExpandIsNotDistinctFromRule(this);
        }
    }

    private static class RemoveIsNotDistinctFromRexShuttle
    extends RexShuttle {
        final RexBuilder rexBuilder;

        RemoveIsNotDistinctFromRexShuttle(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            RexNode newCall = super.visitCall(call);
            if (call.getOperator() == SqlStdOperatorTable.IS_NOT_DISTINCT_FROM) {
                RexCall tmpCall = (RexCall)newCall;
                RexNode operand0 = (RexNode)tmpCall.operands.get(0);
                RexNode operand1 = (RexNode)tmpCall.operands.get(1);
                RexNode operand0Zero = this.rexBuilder.makeZeroRexNode(operand0.getType());
                RexNode operand1Zero = this.rexBuilder.makeZeroRexNode(operand1.getType());
                RexNode coalesceCondition = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.COALESCE, operand0, operand0Zero), this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.COALESCE, operand1, operand1Zero));
                RexNode isNullCondition = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, operand0), this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, operand1));
                newCall = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, coalesceCondition, isNullCondition);
            }
            return newCall;
        }
    }
}

