/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.util.Objects;
import org.apache.ignite.internal.catalog.commands.DefaultValue;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntry;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class CatalogTableColumnDescriptor
implements MarshallableEntry {
    private final String name;
    private final ColumnType type;
    private final boolean nullable;
    private final int length;
    private final int precision;
    private final int scale;
    private final DefaultValue defaultValue;

    public CatalogTableColumnDescriptor(String name, ColumnType type, boolean nullable, int precision, int scale, int length, @Nullable DefaultValue defaultValue) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type);
        this.nullable = nullable;
        this.precision = precision;
        this.scale = scale;
        this.length = length;
        this.defaultValue = defaultValue;
    }

    public String name() {
        return this.name;
    }

    public boolean nullable() {
        return this.nullable;
    }

    public ColumnType type() {
        return this.type;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }

    public int length() {
        return this.length;
    }

    @Nullable
    public DefaultValue defaultValue() {
        return this.defaultValue;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DESCRIPTOR_TABLE_COLUMN.id();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogTableColumnDescriptor that = (CatalogTableColumnDescriptor)o;
        if (this.nullable != that.nullable) {
            return false;
        }
        if (this.length != that.length) {
            return false;
        }
        if (this.precision != that.precision) {
            return false;
        }
        if (this.scale != that.scale) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return this.defaultValue != null ? this.defaultValue.equals(that.defaultValue) : that.defaultValue == null;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.nullable ? 1 : 0);
        result = 31 * result + this.length;
        result = 31 * result + this.precision;
        result = 31 * result + this.scale;
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        return result;
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

