/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.eventlog.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.notifications.ConfigurationListener;
import org.apache.ignite.internal.eventlog.api.EventChannel;
import org.apache.ignite.internal.eventlog.config.schema.ChannelView;
import org.apache.ignite.internal.eventlog.config.schema.EventLogConfiguration;
import org.apache.ignite.internal.eventlog.impl.ChannelRegistry;
import org.apache.ignite.internal.eventlog.impl.EventChannelImpl;
import org.apache.ignite.internal.eventlog.impl.SinkRegistry;
import org.jetbrains.annotations.Nullable;

class ConfigurationBasedChannelRegistry
implements ChannelRegistry {
    private final EventLogConfiguration cfg;
    private final ConfigurationListener<NamedListView<ChannelView>> listener = ConfigurationListener.fromNewValueConsumer(this::updateCache);
    private volatile Map<String, EventChannel> cache;
    private volatile Map<String, Set<EventChannel>> typeCache;
    private final SinkRegistry sinkRegistry;

    ConfigurationBasedChannelRegistry(EventLogConfiguration cfg, SinkRegistry sinkRegistry) {
        this.cfg = cfg;
        this.cache = new HashMap<String, EventChannel>();
        this.typeCache = new HashMap<String, Set<EventChannel>>();
        this.sinkRegistry = sinkRegistry;
    }

    @Override
    public EventChannel getByName(String name) {
        return this.cache.get(name);
    }

    @Override
    @Nullable
    public Set<EventChannel> findAllChannelsByEventType(String igniteEventType) {
        return this.typeCache.get(igniteEventType);
    }

    @Override
    public void start() {
        this.sinkRegistry.start();
        this.updateCache((NamedListView<ChannelView>)((NamedListView)this.cfg.channels().value()));
        this.cfg.channels().listen(this.listener);
    }

    @Override
    public void stop() {
        this.cfg.channels().stopListen(this.listener);
        this.sinkRegistry.stop();
    }

    private void updateCache(@Nullable NamedListView<ChannelView> newListValue) {
        HashMap<String, EventChannel> newCache = new HashMap<String, EventChannel>();
        HashMap<String, Set<EventChannel>> newTypeCache = new HashMap<String, Set<EventChannel>>();
        if (newListValue != null) {
            newListValue.forEach(view -> {
                if (view.enabled()) {
                    EventChannel channel = this.createChannel((ChannelView)view);
                    newCache.put(view.name(), channel);
                    for (String eventType : view.events()) {
                        newTypeCache.computeIfAbsent(eventType.trim(), t -> new HashSet()).add(channel);
                    }
                }
            });
        }
        this.cache = newCache;
        this.typeCache = newTypeCache;
    }

    private EventChannel createChannel(ChannelView view) {
        Set<String> types = Arrays.stream(view.events()).map(String::trim).collect(Collectors.toSet());
        return new EventChannelImpl(view.name(), types, this.sinkRegistry);
    }
}

