/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.tree.DeclarationStatement;
import org.apache.calcite.linq4j.tree.Evaluator;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Visitor;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BlockStatement
extends Statement {
    public final List<Statement> statements;
    private int hash;

    BlockStatement(List<Statement> statements, Type type) {
        super(ExpressionType.Block, type);
        this.statements = Objects.requireNonNull(statements, "statements");
        assert (this.distinctVariables(true));
    }

    private boolean distinctVariables(@UnderInitialization(value=BlockStatement.class) BlockStatement this, boolean fail) {
        HashSet<String> names = new HashSet<String>();
        for (Statement statement : this.statements) {
            String name;
            if (!(statement instanceof DeclarationStatement) || names.add(name = ((DeclarationStatement)statement).parameter.name)) continue;
            assert (!fail) : "duplicate variable " + name;
            return false;
        }
        return true;
    }

    @Override
    public BlockStatement accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        List<Statement> newStatements = Expressions.acceptStatements(this.statements, shuttle);
        return shuttle.visit(this, newStatements);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept0(ExpressionWriter writer) {
        if (this.statements.isEmpty()) {
            writer.append("{}");
            return;
        }
        writer.begin("{\n");
        for (Statement node : this.statements) {
            node.accept(writer, 0, 0);
        }
        writer.end("}\n");
    }

    @Override
    public @Nullable Object evaluate(Evaluator evaluator) {
        Object o = null;
        for (Statement statement : this.statements) {
            o = statement.evaluate(evaluator);
        }
        return o;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BlockStatement that = (BlockStatement)o;
        return this.statements.equals(that.statements);
    }

    @Override
    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            result = Objects.hash(new Object[]{this.nodeType, this.type, this.statements});
            if (result == 0) {
                result = 1;
            }
            this.hash = result;
        }
        return result;
    }
}

