/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.index.sorted;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.datapage.DataPageReader;
import org.apache.ignite.internal.pagememory.reuse.ReuseList;
import org.apache.ignite.internal.pagememory.tree.BplusTree;
import org.apache.ignite.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite.internal.schema.BinaryTupleComparator;
import org.apache.ignite.internal.schema.PartialBinaryTupleMatcher;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptor;
import org.apache.ignite.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite.internal.storage.pagememory.index.InlineUtils;
import org.apache.ignite.internal.storage.pagememory.index.sorted.SortedIndexRow;
import org.apache.ignite.internal.storage.pagememory.index.sorted.SortedIndexRowKey;
import org.apache.ignite.internal.storage.pagememory.index.sorted.io.SortedIndexTreeInnerIo;
import org.apache.ignite.internal.storage.pagememory.index.sorted.io.SortedIndexTreeIo;
import org.apache.ignite.internal.storage.pagememory.index.sorted.io.SortedIndexTreeLeafIo;
import org.apache.ignite.internal.storage.pagememory.index.sorted.io.SortedIndexTreeMetaIo;
import org.apache.ignite.internal.storage.util.StorageUtils;
import org.jetbrains.annotations.Nullable;

public class SortedIndexTree
extends BplusTree<SortedIndexRowKey, SortedIndexRow> {
    private final DataPageReader dataPageReader;
    @Nullable
    private final BinaryTupleComparator binaryTupleComparator;
    @Nullable
    private final PartialBinaryTupleMatcher partialBinaryTupleMatcher;
    private final int inlineSize;

    private SortedIndexTree(int grpId, String grpName, int partId, PageMemory pageMem, AtomicLong globalRmvId, long metaPageId, @Nullable ReuseList reuseList, StorageSortedIndexDescriptor indexDescriptor, boolean initNew) throws IgniteInternalCheckedException {
        super("SortedIndexTree", grpId, grpName, partId, pageMem, globalRmvId, metaPageId, reuseList);
        this.inlineSize = initNew ? InlineUtils.binaryTupleInlineSize(this.pageSize(), 24, (StorageIndexDescriptor)indexDescriptor) : this.readInlineSizeFromMetaIo();
        this.dataPageReader = new DataPageReader(pageMem, grpId);
        this.binaryTupleComparator = StorageUtils.binaryTupleComparator((List)indexDescriptor.columns());
        this.partialBinaryTupleMatcher = StorageUtils.partialBinaryTupleComparator((List)indexDescriptor.columns());
        this.init(initNew);
    }

    private SortedIndexTree(int grpId, String grpName, int partId, PageMemory pageMem, AtomicLong globalRmvId, long metaPageId, @Nullable ReuseList reuseList) throws IgniteInternalCheckedException {
        super("SortedIndexTree", grpId, grpName, partId, pageMem, globalRmvId, metaPageId, reuseList);
        this.inlineSize = this.readInlineSizeFromMetaIo();
        this.dataPageReader = new DataPageReader(pageMem, grpId);
        this.binaryTupleComparator = null;
        this.partialBinaryTupleMatcher = null;
        this.init(false);
    }

    public static SortedIndexTree createNew(int grpId, String grpName, int partId, PageMemory pageMem, AtomicLong globalRmvId, long metaPageId, @Nullable ReuseList reuseList, StorageSortedIndexDescriptor indexDescriptor) throws IgniteInternalCheckedException {
        return new SortedIndexTree(grpId, grpName, partId, pageMem, globalRmvId, metaPageId, reuseList, indexDescriptor, true);
    }

    public static SortedIndexTree restoreExisting(int grpId, @Nullable String grpName, int partId, PageMemory pageMem, AtomicLong globalRmvId, long metaPageId, @Nullable ReuseList reuseList, StorageSortedIndexDescriptor indexDescriptor) throws IgniteInternalCheckedException {
        return new SortedIndexTree(grpId, grpName, partId, pageMem, globalRmvId, metaPageId, reuseList, indexDescriptor, false);
    }

    public static SortedIndexTree restoreForDestroy(int grpId, String grpName, int partId, PageMemory pageMem, AtomicLong globalRmvId, long metaPageId, @Nullable ReuseList reuseList) throws IgniteInternalCheckedException {
        return new SortedIndexTree(grpId, grpName, partId, pageMem, globalRmvId, metaPageId, reuseList);
    }

    private void init(boolean initNew) throws IgniteInternalCheckedException {
        this.setIos(SortedIndexTreeInnerIo.VERSIONS.get(this.inlineSize), SortedIndexTreeLeafIo.VERSIONS.get(this.inlineSize), SortedIndexTreeMetaIo.VERSIONS);
        this.initTree(initNew);
        if (initNew) {
            this.writeInlineSizeToMetaIo(this.inlineSize);
        }
    }

    public int partitionId() {
        return this.partId;
    }

    public DataPageReader dataPageReader() {
        return this.dataPageReader;
    }

    protected int compare(BplusIo<SortedIndexRowKey> io, long pageAddr, int idx, SortedIndexRowKey row) throws IgniteInternalCheckedException {
        SortedIndexTreeIo sortedIndexTreeIo = (SortedIndexTreeIo)io;
        return sortedIndexTreeIo.compare(this.dataPageReader, (Comparator<ByteBuffer>)this.getBinaryTupleComparator(), this.getPartialBinaryTupleComparator(), this.partId, pageAddr, idx, row);
    }

    public SortedIndexRow getRow(BplusIo<SortedIndexRowKey> io, long pageAddr, int idx, Object x) throws IgniteInternalCheckedException {
        SortedIndexTreeIo sortedIndexTreeIo = (SortedIndexTreeIo)io;
        return sortedIndexTreeIo.getRow(this.dataPageReader, this.partId, pageAddr, idx);
    }

    public int inlineSize() {
        return this.inlineSize;
    }

    private int readInlineSizeFromMetaIo() throws IgniteInternalCheckedException {
        Integer inlineSize = (Integer)this.read(this.metaPageId, (groupId, pageId, page, pageAddr, io, arg, intArg) -> ((SortedIndexTreeMetaIo)io).getInlineSize(pageAddr), null, 0, -1);
        assert (inlineSize != -1);
        return inlineSize;
    }

    private void writeInlineSizeToMetaIo(int inlineSize) throws IgniteInternalCheckedException {
        Boolean result = (Boolean)this.write(this.metaPageId, (groupId, pageId, page, pageAddr, io, arg, intArg) -> {
            ((SortedIndexTreeMetaIo)io).setInlineSize(pageAddr, inlineSize);
            return Boolean.TRUE;
        }, 0, Boolean.FALSE);
        assert (result == Boolean.TRUE) : result;
    }

    BinaryTupleComparator getBinaryTupleComparator() {
        assert (this.binaryTupleComparator != null) : "This index tree must only be used for destruction during recovery";
        return this.binaryTupleComparator;
    }

    PartialBinaryTupleMatcher getPartialBinaryTupleComparator() {
        assert (this.partialBinaryTupleMatcher != null) : "This index tree must only be used for destruction during recovery";
        return this.partialBinaryTupleMatcher;
    }
}

