/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.builder;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.builder.BinaryBuilderReader;
import org.apache.ignite.internal.binary.builder.BinaryBuilderSerializationAware;
import org.apache.ignite.internal.binary.builder.BinaryBuilderSerializer;

class BinaryLazyLinkedList
extends AbstractList<Object>
implements BinaryBuilderSerializationAware {
    private final BinaryBuilderReader reader;
    private final int off;
    private List<Object> delegate;

    BinaryLazyLinkedList(BinaryBuilderReader reader, int size) {
        this.reader = reader;
        this.off = reader.position() - 1 - 4 - 1;
        assert (size >= 0);
        for (int i = 0; i < size; ++i) {
            reader.skipValue();
        }
    }

    private void ensureDelegateInit() {
        if (this.delegate == null) {
            int size = this.reader.readIntPositioned(this.off + 1);
            this.reader.position(this.off + 1 + 4 + 1);
            this.delegate = new LinkedList<Object>();
            for (int i = 0; i < size; ++i) {
                this.delegate.add(this.reader.parseValue());
            }
        }
    }

    @Override
    public Object get(int idx) {
        this.ensureDelegateInit();
        return BinaryUtils.unwrapLazy(this.delegate.get(idx));
    }

    @Override
    public boolean add(Object o) {
        this.ensureDelegateInit();
        return this.delegate.add(o);
    }

    @Override
    public void add(int idx, Object element) {
        this.ensureDelegateInit();
        this.delegate.add(idx, element);
    }

    @Override
    public Object set(int idx, Object element) {
        this.ensureDelegateInit();
        return BinaryUtils.unwrapLazy(this.delegate.set(idx, element));
    }

    @Override
    public Object remove(int idx) {
        this.ensureDelegateInit();
        return BinaryUtils.unwrapLazy(this.delegate.remove(idx));
    }

    @Override
    public void clear() {
        if (this.delegate == null) {
            this.delegate = new LinkedList<Object>();
        } else {
            this.delegate.clear();
        }
    }

    @Override
    public boolean addAll(int idx, Collection<?> c) {
        this.ensureDelegateInit();
        return this.delegate.addAll(idx, c);
    }

    @Override
    protected void removeRange(int fromIdx, int toIdx) {
        this.ensureDelegateInit();
        this.delegate.subList(fromIdx, toIdx).clear();
    }

    @Override
    public int size() {
        if (this.delegate == null) {
            return this.reader.readIntPositioned(this.off + 1);
        }
        return this.delegate.size();
    }

    @Override
    public ListIterator<Object> listIterator(final int idx) {
        this.ensureDelegateInit();
        return new ListIterator<Object>(){
            private final ListIterator<Object> delegate;
            {
                this.delegate = BinaryLazyLinkedList.super.listIterator(idx);
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public Object next() {
                return BinaryUtils.unwrapLazy(this.delegate.next());
            }

            @Override
            public boolean hasPrevious() {
                return this.delegate.hasPrevious();
            }

            @Override
            public Object previous() {
                return BinaryUtils.unwrapLazy(this.delegate.previous());
            }

            @Override
            public int nextIndex() {
                return this.delegate.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.delegate.previousIndex();
            }

            @Override
            public void remove() {
                this.delegate.remove();
            }

            @Override
            public void set(Object o) {
                this.delegate.set(o);
            }

            @Override
            public void add(Object o) {
                this.delegate.add(o);
            }
        };
    }

    @Override
    public Iterator<Object> iterator() {
        this.ensureDelegateInit();
        return BinaryUtils.unwrapLazyIterator(super.iterator());
    }

    @Override
    public void writeTo(BinaryWriterExImpl writer, BinaryBuilderSerializer ctx) {
        if (this.delegate == null) {
            int size = this.reader.readIntPositioned(this.off + 1);
            int hdrSize = 6;
            writer.write(this.reader.array(), this.off, hdrSize);
            this.reader.position(this.off + hdrSize);
            for (int i = 0; i < size; ++i) {
                Object o = this.reader.parseValue();
                ctx.writeValue(writer, o);
            }
        } else {
            writer.writeByte((byte)24);
            writer.writeInt(this.delegate.size());
            byte colType = this.reader.array()[this.off + 1 + 4];
            writer.writeByte(colType);
            for (Object o : this.delegate) {
                ctx.writeValue(writer, o);
            }
        }
    }
}

