/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxFinishRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.PartitionUpdateCountersMessage;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;

public class GridDhtTxFinishRequest
extends GridDistributedTxFinishRequest {
    private static final long serialVersionUID = 0L;
    private UUID nearNodeId;
    private int miniId;
    @GridDirectCollection(value=PartitionUpdateCountersMessage.class)
    private Collection<PartitionUpdateCountersMessage> updCntrs;

    public GridDhtTxFinishRequest() {
    }

    public GridDhtTxFinishRequest(UUID nearNodeId, IgniteUuid futId, int miniId, @NotNull AffinityTopologyVersion topVer, GridCacheVersion xidVer, GridCacheVersion commitVer, long threadId, boolean commit, boolean invalidate, boolean sys, byte plc, boolean sysInvalidate, CacheWriteSynchronizationMode syncMode, GridCacheVersion baseVer, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers, int txSize, int taskNameHash, boolean addDepInfo, boolean retVal, boolean waitRemoteTxs, Collection<PartitionUpdateCountersMessage> updCntrs) {
        super(xidVer, futId, topVer, commitVer, threadId, commit, invalidate, sys, plc, syncMode, baseVer, committedVers, rolledbackVers, taskNameHash, txSize, addDepInfo);
        assert (miniId != 0);
        assert (nearNodeId != null);
        this.nearNodeId = nearNodeId;
        this.miniId = miniId;
        this.updCntrs = updCntrs;
        this.needReturnValue(retVal);
        this.waitRemoteTransactions(waitRemoteTxs);
        this.systemInvalidate(sysInvalidate);
    }

    public int miniId() {
        return this.miniId;
    }

    public UUID nearNodeId() {
        return this.nearNodeId;
    }

    public boolean isSystemInvalidate() {
        return this.isFlag(8);
    }

    private void systemInvalidate(boolean sysInvalidate) {
        this.setFlag(sysInvalidate, 8);
    }

    public boolean checkCommitted() {
        return this.isFlag(2);
    }

    public void checkCommitted(boolean checkCommitted) {
        this.setFlag(checkCommitted, 2);
    }

    public boolean waitRemoteTransactions() {
        return this.isFlag(1);
    }

    private void waitRemoteTransactions(boolean waitRemoteTxs) {
        this.setFlag(waitRemoteTxs, 1);
    }

    public boolean needReturnValue() {
        return this.isFlag(4);
    }

    public void needReturnValue(boolean retVal) {
        this.setFlag(retVal, 4);
    }

    public Collection<PartitionUpdateCountersMessage> updateCounters() {
        return this.updCntrs;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 21: {
                if (!writer.writeInt("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 22: {
                if (!writer.writeUuid("nearNodeId", this.nearNodeId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 23: {
                if (!writer.writeCollection("updCntrs", this.updCntrs, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 21: {
                this.miniId = reader.readInt("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 22: {
                this.nearNodeId = reader.readUuid("nearNodeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 23: {
                this.updCntrs = reader.readCollection("updCntrs", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtTxFinishRequest.class);
    }

    @Override
    public short directType() {
        return 32;
    }

    @Override
    public byte fieldsCount() {
        return 24;
    }

    @Override
    public int partition() {
        return U.safeAbs(this.version().hashCode());
    }

    @Override
    public String toString() {
        return S.toString(GridDhtTxFinishRequest.class, this, super.toString());
    }
}

