/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.call;

import java.io.PrintWriter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import java.util.function.Supplier;
import me.tongfei.progressbar.DelegatingProgressBarConsumer;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarConsumer;
import org.apache.ignite3.internal.cli.core.call.AbstractCallExecutionPipeline;
import org.apache.ignite3.internal.cli.core.call.AsyncCall;
import org.apache.ignite3.internal.cli.core.call.CallInput;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.ProgressBarTracker;
import org.apache.ignite3.internal.cli.core.call.ProgressTracker;
import org.apache.ignite3.internal.cli.core.decorator.Decorator;
import org.apache.ignite3.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite3.internal.cli.core.exception.ExceptionHandlers;

public class AsyncCallExecutionPipeline<I extends CallInput, T>
extends AbstractCallExecutionPipeline<I, T> {
    private final Function<ProgressTracker, AsyncCall<I, T>> callFactory;
    private final ProgressBarBuilder progressBarBuilder;

    AsyncCallExecutionPipeline(Function<ProgressTracker, AsyncCall<I, T>> callFactory, ProgressBarBuilder progressBarBuilder, PrintWriter output, PrintWriter errOutput, ExceptionHandlers exceptionHandlers, Decorator<T, TerminalOutput> decorator, Supplier<I> inputProvider, boolean[] verbose) {
        super(output, errOutput, exceptionHandlers, decorator, inputProvider, verbose);
        this.callFactory = callFactory;
        this.progressBarBuilder = progressBarBuilder;
    }

    @Override
    public int runPipelineInternal() {
        CallInput callInput = (CallInput)this.inputProvider.get();
        this.progressBarBuilder.setConsumer((ProgressBarConsumer)new DelegatingProgressBarConsumer(this::print){

            public void close() {
                AsyncCallExecutionPipeline.this.output.println();
                AsyncCallExecutionPipeline.this.output.flush();
            }
        });
        this.progressBarBuilder.setUpdateIntervalMillis(60);
        try {
            ProgressBarTracker tracker = new ProgressBarTracker(this.progressBarBuilder);
            CallOutput result = (CallOutput)((CompletableFuture)this.callFactory.apply(tracker).execute(callInput).whenComplete((el, err) -> tracker.close())).join();
            return this.handleResult(result);
        }
        catch (CompletionException e) {
            return this.handleException(e.getCause());
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    private void print(String s) {
        this.output.print("\r" + s);
        this.output.flush();
    }
}

