/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metrics.exporters.otlp;

import com.google.auto.service.AutoService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite3.internal.metrics.MetricSet;
import org.apache.ignite3.internal.metrics.exporters.MetricExporter;
import org.apache.ignite3.internal.metrics.exporters.PushMetricExporter;
import org.apache.ignite3.internal.metrics.exporters.configuration.ExporterView;
import org.apache.ignite3.internal.metrics.exporters.configuration.OtlpExporterView;
import org.apache.ignite3.internal.metrics.exporters.otlp.MetricReporter;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@AutoService(value={MetricExporter.class})
public class OtlpPushMetricExporter
extends PushMetricExporter {
    public static final String EXPORTER_NAME = "otlp";
    private final AtomicReference<MetricReporter> reporter = new AtomicReference();

    @Override
    public void stop() {
        super.stop();
        this.changeReporter(null);
    }

    @Override
    public void reconfigure(ExporterView newVal) {
        MetricReporter newReporter = new MetricReporter((OtlpExporterView)newVal, this.clusterIdSupplier(), this.nodeName());
        for (MetricSet metricSet : this.snapshot().metrics().values()) {
            newReporter.addMetricSet(metricSet);
        }
        this.changeReporter(newReporter);
        super.reconfigure(newVal);
    }

    @Override
    public void addMetricSet(MetricSet metricSet) {
        MetricReporter reporter0 = this.reporter.get();
        assert (reporter0 != null);
        reporter0.addMetricSet(metricSet);
    }

    @Override
    public void removeMetricSet(MetricSet metricSet) {
        MetricReporter reporter0 = this.reporter.get();
        assert (reporter0 != null);
        reporter0.removeMetricSet(metricSet.name());
    }

    @Override
    protected long period(ExporterView exporterView) {
        return ((OtlpExporterView)exporterView).periodMillis();
    }

    @Override
    public void report() {
        MetricReporter reporter0 = this.reporter.get();
        assert (reporter0 != null);
        reporter0.report();
    }

    @Override
    public String name() {
        return EXPORTER_NAME;
    }

    @TestOnly
    @Nullable
    MetricReporter reporter() {
        return this.reporter.get();
    }

    private void changeReporter(@Nullable MetricReporter newReporter) {
        MetricReporter oldReporter = this.reporter.getAndSet(newReporter);
        try {
            IgniteUtils.closeAll(oldReporter);
        }
        catch (Exception e) {
            this.log.error("Failed to stop metric exporter: " + this.name(), (Throwable)e);
        }
    }
}

