/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.util.subscription;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.apache.ignite3.internal.util.subscription.AccumulateException;
import org.apache.ignite3.internal.util.subscription.Accumulator;

public class AccumulatorSubscriber<T, R>
implements Flow.Subscriber<T> {
    private final CompletableFuture<R> result;
    private final Accumulator<T, R> accumulator;

    AccumulatorSubscriber(CompletableFuture<R> result, Accumulator<T, R> accumulator) {
        this.result = result;
        this.accumulator = accumulator;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        subscription.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(T item) {
        this.accumulator.accumulate(item);
    }

    @Override
    public void onError(Throwable throwable) {
        this.result.completeExceptionally(throwable);
    }

    @Override
    public void onComplete() {
        try {
            this.result.complete(this.accumulator.get());
        }
        catch (AccumulateException e) {
            this.result.completeExceptionally(e.getCause());
        }
    }
}

