/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.kvstore;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.graph.Shard;
import org.apache.hugegraph.structure.graph.Vertices;
import org.apache.hugegraph.util.E;

public class KvStoreAPI
extends API {
    private static final String PATH = "kvstore";
    private static String batchPath = "";

    public KvStoreAPI(RestClient client) {
        super(client);
        this.path(PATH);
        batchPath = String.join((CharSequence)"/", this.path(), "batch");
    }

    @Override
    protected String type() {
        return PATH;
    }

    public List<Shard> shards(long splitSize) {
        String path = String.join((CharSequence)"/", this.path(), "shards");
        ImmutableMap params = ImmutableMap.of((Object)"split_size", (Object)splitSize);
        RestResult result = this.client.get(path, (Map<String, Object>)params);
        return result.readList("shards", Shard.class);
    }

    public Vertices scan(Shard shard, String page, long pageLimit) {
        E.checkArgument((shard != null ? 1 : 0) != 0, (String)"Shard can't be null", (Object[])new Object[0]);
        String path = String.join((CharSequence)"/", this.path(), "scan");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("start", shard.start());
        params.put("end", shard.end());
        params.put("page", page);
        params.put("page_limit", pageLimit);
        RestResult result = this.client.get(path, params);
        return (Vertices)result.readObject(Vertices.class);
    }

    public Map<String, Object> setBatch(Map<String, Object> data) {
        RestResult result = this.client.post(batchPath, data);
        return (Map)result.readObject(Map.class);
    }
}

