/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.vermeer;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.HugeType;

public class VermeerAPI
extends API {
    private static final String PATH = "vermeer";
    private static final String GET_SYS_CFG = "api/v1.0/memt_clu/config/getsyscfg";

    public VermeerAPI(RestClient client) {
        super(client);
    }

    @Override
    protected String type() {
        return HugeType.VERMEER.string();
    }

    public Map<String, Object> getStatus() {
        ImmutableMap sertMap = ImmutableMap.of((Object)"sertype", (Object)PATH);
        RestResult results = this.client.post(GET_SYS_CFG, sertMap);
        return (Map)results.readObject(Map.class);
    }

    public Map<String, Object> post(Map<String, Object> params) {
        this.path(PATH);
        RestResult results = this.client.post(this.path(), params);
        return (Map)results.readObject(Map.class);
    }

    public Map<String, Object> getGraphsInfo() {
        this.path(String.join((CharSequence)"/", PATH, "vermeergraphs"));
        RestResult results = this.client.get(this.path());
        return (Map)results.readObject(Map.class);
    }

    public Map<String, Object> getGraphInfoByName(String graphName) {
        this.path(String.join((CharSequence)"/", PATH, "vermeergraphs", graphName));
        RestResult results = this.client.get(this.path());
        return (Map)results.readObject(Map.class);
    }

    public Map<String, Object> deleteGraphByName(String graphName) {
        this.path(String.join((CharSequence)"/", PATH, "vermeergraphs", graphName));
        RestResult results = this.client.delete(this.path(), (Map<String, Object>)ImmutableMap.of());
        return (Map)results.readObject(Map.class);
    }

    public Map<String, Object> getTasksInfo() {
        this.path(String.join((CharSequence)"/", PATH, "vermeertasks"));
        RestResult results = this.client.get(this.path());
        return (Map)results.readObject(Map.class);
    }

    public Map<String, Object> getTasksInfoById(String taskId) {
        this.path(String.join((CharSequence)"/", PATH, "vermeertasks", taskId));
        RestResult results = this.client.get(this.path());
        return (Map)results.readObject(Map.class);
    }
}

