/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.client;

import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.stub.AbstractBlockingStub;
import io.grpc.stub.AbstractStub;
import org.apache.hugegraph.pd.client.AbstractClient;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.pd.common.KVPair;
import org.apache.hugegraph.pd.grpc.PDGrpc;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseClient
extends AbstractClient {
    private static final Logger log = LoggerFactory.getLogger(LicenseClient.class);

    public LicenseClient(PDConfig config) {
        super(config);
    }

    @Override
    protected AbstractStub createStub() {
        return PDGrpc.newStub((Channel)this.channel);
    }

    @Override
    protected AbstractBlockingStub createBlockingStub() {
        return PDGrpc.newBlockingStub((Channel)this.channel);
    }

    public Pdpb.PutLicenseResponse putLicense(byte[] content) {
        Pdpb.PutLicenseRequest request = Pdpb.PutLicenseRequest.newBuilder().setContent(ByteString.copyFrom((byte[])content)).build();
        try {
            KVPair<Boolean, Pdpb.PutLicenseResponse> pair = this.concurrentBlockingUnaryCall(PDGrpc.getPutLicenseMethod(), request, rs -> rs.getHeader().getError().getType().equals((Object)Pdpb.ErrorType.OK));
            if (((Boolean)pair.getKey()).booleanValue()) {
                Pdpb.PutLicenseResponse.Builder builder = Pdpb.PutLicenseResponse.newBuilder();
                builder.setHeader(okHeader);
                return builder.build();
            }
            return (Pdpb.PutLicenseResponse)pair.getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.debug("put license with error:{} ", (Throwable)e);
            Pdpb.ResponseHeader rh = LicenseClient.newErrorHeader(107, e.getMessage());
            return Pdpb.PutLicenseResponse.newBuilder().setHeader(rh).build();
        }
    }
}

