/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.source.file;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.hugegraph.loader.source.AbstractSource;
import org.apache.hugegraph.loader.source.SourceType;
import org.apache.hugegraph.loader.source.file.Compression;
import org.apache.hugegraph.loader.source.file.DirFilter;
import org.apache.hugegraph.loader.source.file.FileFilter;
import org.apache.hugegraph.loader.source.file.FileFormat;
import org.apache.hugegraph.loader.source.file.SkippedLine;
import org.apache.hugegraph.loader.util.DateUtil;
import org.apache.hugegraph.util.E;

@JsonPropertyOrder(value={"type", "path", "file_filter"})
public class FileSource
extends AbstractSource {
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="dir_filter")
    private DirFilter dirFilter;
    @JsonProperty(value="file_filter")
    private FileFilter filter;
    @JsonProperty(value="format")
    private FileFormat format;
    @JsonProperty(value="delimiter")
    private String delimiter;
    @JsonProperty(value="date_format")
    private String dateFormat;
    @JsonProperty(value="extra_date_formats")
    private List<String> extraDateFormats;
    @JsonProperty(value="time_zone")
    private String timeZone;
    @JsonProperty(value="skipped_line")
    private SkippedLine skippedLine;
    @JsonProperty(value="compression")
    private Compression compression;
    @JsonProperty(value="batch_size")
    private int batchSize;
    @JsonProperty(value="split_count")
    private int splitCount;
    private final boolean headerCaseSensitive;

    public FileSource() {
        this(null, new DirFilter(), new FileFilter(), FileFormat.CSV, ",", "yyyy-MM-dd HH:mm:ss", (List<String>)ImmutableList.of(), "GMT+8", new SkippedLine(), Compression.NONE, 500);
    }

    @JsonCreator
    public FileSource(@JsonProperty(value="path") String path, @JsonProperty(value="dir_filter") DirFilter dirFilter, @JsonProperty(value="filter") FileFilter filter, @JsonProperty(value="format") FileFormat format, @JsonProperty(value="delimiter") String delimiter, @JsonProperty(value="date_format") String dateFormat, @JsonProperty(value="extra_date_formats") List<String> extraDateFormats, @JsonProperty(value="time_zone") String timeZone, @JsonProperty(value="skipped_line") SkippedLine skippedLine, @JsonProperty(value="compression") Compression compression, @JsonProperty(value="batch_size") Integer batchSize) {
        this.path = path;
        this.dirFilter = dirFilter != null ? dirFilter : new DirFilter();
        this.filter = filter != null ? filter : new FileFilter();
        this.format = format != null ? format : FileFormat.CSV;
        this.delimiter = delimiter != null ? delimiter : this.format.delimiter();
        this.dateFormat = dateFormat != null ? dateFormat : "yyyy-MM-dd HH:mm:ss";
        this.extraDateFormats = extraDateFormats == null || extraDateFormats.isEmpty() ? ImmutableList.of() : extraDateFormats;
        this.timeZone = timeZone != null ? timeZone : "GMT+8";
        this.skippedLine = skippedLine != null ? skippedLine : new SkippedLine();
        this.compression = compression != null ? compression : Compression.NONE;
        this.batchSize = batchSize != null ? batchSize : 500;
        this.headerCaseSensitive = !Compression.ORC.equals((Object)this.compression()) && !Compression.PARQUET.equals((Object)this.compression());
    }

    @Override
    public SourceType type() {
        return SourceType.FILE;
    }

    @Override
    public void check() throws IllegalArgumentException {
        super.check();
        if (this.format == FileFormat.CSV) {
            E.checkArgument((this.delimiter == null || this.delimiter.equals(",") ? 1 : 0) != 0, (String)"The delimiter must be '%s' when file format is %s, but got '%s'", (Object[])new Object[]{",", this.format, this.delimiter});
        }
        E.checkArgument((boolean)DateUtil.checkTimeZone(this.timeZone), (String)"The time_zone '%s' is invalid", (Object[])new Object[]{this.timeZone});
        if (this.listFormat() != null) {
            String elemDelimiter = this.listFormat().elemDelimiter();
            E.checkArgument((!elemDelimiter.equals(this.delimiter) ? 1 : 0) != 0, (String)"The delimiters of fields(%s) and list elements(%s) can't be the same", (Object[])new Object[]{this.delimiter, elemDelimiter});
        }
    }

    public String path() {
        return this.path;
    }

    public void path(String path) {
        this.path = path;
    }

    public DirFilter dirFilter() {
        return this.dirFilter;
    }

    public void setDirFilter(DirFilter dirFilter) {
        this.dirFilter = dirFilter;
    }

    public FileFilter filter() {
        return this.filter;
    }

    public void filter(FileFilter filter) {
        this.filter = filter;
    }

    public FileFormat format() {
        return this.format;
    }

    public void format(FileFormat format) {
        this.format = format;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public void delimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String dateFormat() {
        return this.dateFormat;
    }

    public void dateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public List<String> extraDateFormats() {
        return this.extraDateFormats;
    }

    public void extraDateFormats(List<String> extraDateFormats) {
        this.extraDateFormats = extraDateFormats;
    }

    public String timeZone() {
        return this.timeZone;
    }

    public void timeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public SkippedLine skippedLine() {
        return this.skippedLine;
    }

    public void skippedLine(SkippedLine skippedLine) {
        this.skippedLine = skippedLine;
    }

    public Compression compression() {
        return this.compression;
    }

    public void compression(Compression compression) {
        this.compression = compression;
    }

    public int batchSize() {
        return this.batchSize;
    }

    public void batchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int splitCount() {
        return this.splitCount;
    }

    @Override
    public FileSource asFileSource() {
        FileSource source = new FileSource();
        source.header(this.header());
        source.charset(this.charset());
        source.listFormat(this.listFormat());
        source.path = this.path;
        source.dirFilter = this.dirFilter;
        source.filter = this.filter;
        source.format = this.format;
        source.delimiter = this.delimiter;
        source.dateFormat = this.dateFormat;
        source.extraDateFormats = this.extraDateFormats;
        source.skippedLine = this.skippedLine;
        source.compression = this.compression;
        return source;
    }

    public String toString() {
        return String.format("%s(%s)", new Object[]{this.type(), this.path()});
    }

    @Override
    public boolean headerCaseSensitive() {
        return this.headerCaseSensitive;
    }
}

