/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.pagination;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.DialectModel;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.IDialect;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DialectFactory {
    private static final Map<String, IDialect> DIALECT_CACHE = new ConcurrentHashMap<String, IDialect>();

    public static DialectModel buildPaginationSql(IPage<?> page, String buildSql, DbType dbType, String dialectClazz) {
        return DialectFactory.getDialect(dbType, dialectClazz).buildPaginationSql(buildSql, page.offset(), page.getSize());
    }

    private static IDialect getDialect(DbType dbType, String dialectClazz) {
        return DIALECT_CACHE.computeIfAbsent(dbType.getDb(), key -> {
            IDialect dialect = null;
            String dialectClassName = StringUtils.isBlank((CharSequence)dialectClazz) ? dbType.getDialect() : dialectClazz;
            try {
                Class<?> clazz = Class.forName(dialectClassName);
                if (IDialect.class.isAssignableFrom(clazz)) {
                    dialect = (IDialect)ClassUtils.newInstance(clazz);
                }
            }
            catch (ClassNotFoundException e) {
                throw ExceptionUtils.mpe((String)"Class : %s is not found", (Object[])new Object[]{dialectClazz});
            }
            Assert.notNull((Object)dialect, (String)"The value of the dialect property in mybatis configuration.xml is not defined.", (Object[])new Object[0]);
            return dialect;
        });
    }
}

