<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -->

### 2.0.0

<details>	
  <summary><mark>版本变更</mark></summary>

### Seata-go 2.0.0

Seata-go 2.0.0 发布。

Seata-go 是一款开源的分布式事务解决方案，提供高性能和简单易用的分布式事务服务。

此版本更新如下：

### feature：

- [[#574](https://github.com/apache/incubator-seata-go/pull/574)] 支持本地文件类型和 Nacos 类型的注册中心
- [[#584](https://github.com/apache/incubator-seata-go/pull/584)] 远程调用模块支持 ConsistentHash 负载均衡策略
- [[#585](https://github.com/apache/incubator-seata-go/pull/585)] 远程调用模块支持 LeastActive 负载均衡策略
- [[#605](https://github.com/apache/incubator-seata-go/pull/605)] 支持 Etcd 的服务发现
- [[#622](https://github.com/apache/incubator-seata-go/pull/622)] 远程调用模块增加轮询策略
- [[#659](https://github.com/apache/incubator-seata-go/pull/659)] 支持 AT undo log 的压缩
- [[#691](https://github.com/apache/incubator-seata-go/pull/691)] 支持 protobuf 类型的 undo log 解析
- [[#738](https://github.com/apache/incubator-seata-go/pull/738)] 发送心跳消息失败时移除会话
- [[#739](https://github.com/apache/incubator-seata-go/pull/739)] 支持表元数据缓存的自动刷新功能

### bugfix：

- [[#540](https://github.com/apache/incubator-seata-go/pull/540)] 修复初始化 XA 时的 bug
- [[#590](https://github.com/apache/incubator-seata-go/pull/590)] 修复一些类型的错误
- [[#595](https://github.com/apache/incubator-seata-go/pull/595)] 提交或回滚时检查响应错误是否为 nil
- [[#607](https://github.com/apache/incubator-seata-go/pull/607)] 修复 Jackson 序列化的 bug
- [[#665](https://github.com/apache/incubator-seata-go/pull/665)] 回收心跳响应消息，避免 GettyRemoting.future 的内存泄漏
- [[#672](https://github.com/apache/incubator-seata-go/pull/672)] 修复 AT 回滚的 bug
- [[#674](https://github.com/apache/incubator-seata-go/pull/674)] 修复 XA 回滚的 bug
- [[#690](https://github.com/apache/incubator-seata-go/pull/690)] 修复 AT undo log Jackson 解析器未找到的 bug
- [[#701](https://github.com/apache/incubator-seata-go/pull/701)] 修复 InsertOnDuplicateUpdate 问题，绕过修改主键
- [[#717](https://github.com/apache/incubator-seata-go/pull/717)] 支持 XA 向 TC 报告状态
- [[#724](https://github.com/apache/incubator-seata-go/pull/724)] SQL 解析器支持 ParenthesesExpr
- [[#736](https://github.com/apache/incubator-seata-go/pull/736)] 修复 SQL 语句未关闭的 bug
- [[#743](https://github.com/apache/incubator-seata-go/pull/743)] 修复 gomonkey 的 bug
- [[#749](https://github.com/apache/incubator-seata-go/pull/749)] 修复心跳的 bug


### optimize:

- [[#576](https://github.com/apache/incubator-seata-go/pull/576)] 使用 mirromutth/mysql-action 替代 icomponent/mysql-action
- [[#594](https://github.com/apache/incubator-seata-go/pull/594)] 优化 branch commit procesor 的日志
- [[#621](https://github.com/apache/incubator-seata-go/pull/621)] 为 ci 添加 codeql
- [[#631](https://github.com/apache/incubator-seata-go/pull/631)] 将 crypto 版本从 0.9.0 升级到 0.17.0
- [[#652](https://github.com/apache/incubator-seata-go/pull/652)] 将 gRPC 版本从 1.51.0 升级到 1.56.3
- [[#667](https://github.com/apache/incubator-seata-go/pull/667)] 将通知邮箱从 dev 更新为 notifications
- [[#679](https://github.com/apache/incubator-seata-go/pull/679)] 将 getty 版本从 1.4.9 升级到 1.4.10
- [[#678](https://github.com/apache/incubator-seata-go/pull/678)] 将 module 命名为 seata.apache.org/seata-go
- [[#721](https://github.com/apache/incubator-seata-go/pull/721)] 修复翻译机器人无法工作的问题
- [[#719](https://github.com/apache/incubator-seata-go/pull/719)] Insert SQL 的 undo log 只保留插入的字段
- [[#714](https://github.com/apache/incubator-seata-go/pull/714)] 优化构建锁键的速度
- [[#758](https://github.com/apache/incubator-seata-go/pull/758)] 移除无用的文件

### test:

- [[#570](https://github.com/apache/incubator-seata-go/pull/570)] 添加 collecion 的单元测试
- [[#571](https://github.com/apache/incubator-seata-go/pull/571)] 添加 convert 的单元测试
- [[#572](https://github.com/apache/incubator-seata-go/pull/572)] 添加 reflectx 的单元测试
- [[#5835f0](https://github.com/apache/incubator-seata-go/commit/5835f09ecfd6edeb04c2961163bc4460f578e942)] 添加 random loadbalance 的单元测试
- [[#599](https://github.com/apache/incubator-seata-go/pull/599)] 添加 xid loadbalance 的单元测试


### doc:
- [[#614](https://github.com/apache/incubator-seata-go/pull/614)] 升级未知许可证依赖
- [[#632](https://github.com/apache/incubator-seata-go/pull/632)] 添加 ASF 配置
- [[#633](https://github.com/apache/incubator-seata-go/pull/633)] 优化 ASF 配置，移除上下文检查
- [[#644](https://github.com/apache/incubator-seata-go/pull/644)] 优化 readme 文件
- [[#686](https://github.com/apache/incubator-seata-go/pull/686)] 在 ci 中添加更多的 linter
- [[#737](https://github.com/apache/incubator-seata-go/pull/737)] 更新 readme 文件中已完成的工作
- [[#756](https://github.com/apache/incubator-seata-go/pull/756)] 添加 license 检查逻辑 
- [[#797](https://github.com/apache/incubator-seata-go/pull/797)] 给一些源文件添加 ASF header


### contributors:

非常感谢以下 contributors 的代码贡献。若有无意遗漏，请报告。

- [luky116](https://github.com/luky116)
- [Code-Fight](https://github.com/Code-Fight)
- [wt-better](https://github.com/wt-better)
- [luweiqianyi](https://github.com/luweiqianyi)
- [wang1309](https://github.com/wang1309)
- [576470954](https://github.com/576470954)
- [No-SilverBullet](https://github.com/No-SilverBullet)
- [solisamicus](https://github.com/solisamicus)
- [marsevilspirit](https://github.com/marsevilspirit)
- [lxfeng1997](https://github.com/lxfeng1997)
- [AlexStocks](https://github.com/AlexStocks)
- [smiletrl](https://github.com/smiletrl)
- [ptyin](https://github.com/ptyin)
- [yizhibian](https://github.com/yizhibian)
- [oldmee](https://github.com/oldmee)
- [air-3](https://github.com/air-3)
- [slievrly](https://github.com/slievrly)
- [xjlgod](https://github.com/xjlgod)
- [baerwang](https://github.com/baerwang)
- [xyombo](https://github.com/xyombo)
- [testwill](https://github.com/testwill)
- [jasondeng1997](https://github.com/jasondeng1997)
- [jsbxyyx](https://github.com/jsbxyyx)
- [iSuperCoder](https://github.com/iSuperCoder)
- [georgehao](https://github.com/georgehao)
- [liuyuecai](https://github.com/liuyuecai)
- [106umao](https://github.com/106umao)
- [FinnTew](https://github.com/FinnTew)
- [funky-eyes](https://github.com/funky-eyes)
- [tanzegen](https://github.com/tanzegen)
- [lovepoem](https://github.com/lovepoem)
- [YvCeung](https://github.com/YvCeung)

同时，我们收到了社区反馈的很多有价值的issue和建议，非常感谢大家。

</detail>