/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.apache.jena.sparql.engine.iterator.QueryIterTracked;
import org.apache.jena.sparql.engine.iterator.QueryIteratorBase;
import org.apache.jena.sparql.engine.iterator.QueryIteratorCopy;
import org.apache.jena.sparql.engine.iterator.QueryIteratorMapped;
import org.apache.jena.sparql.serializer.SerializationContext;

public abstract class QueryIter
extends QueryIteratorBase {
    private static volatile int iteratorCounter = 0;
    private int iteratorNumber = iteratorCounter++;
    private ExecutionContext tracker;

    public QueryIter(ExecutionContext execCxt) {
        super(QueryIter.cancelSignal(execCxt));
        this.tracker = execCxt;
        this.register();
    }

    private static AtomicBoolean cancelSignal(ExecutionContext execCxt) {
        if (execCxt == null) {
            return null;
        }
        return execCxt.getCancelSignal();
    }

    public static QueryIter makeTracked(QueryIterator qIter, ExecutionContext execCxt) {
        if (qIter instanceof QueryIter) {
            return (QueryIter)qIter;
        }
        return new QueryIterTracked(qIter, execCxt);
    }

    public static QueryIter materialize(QueryIterator qIter, ExecutionContext execCxt) {
        return QueryIter.makeTracked(QueryIter.materialize(qIter), execCxt);
    }

    public static QueryIterator materialize(QueryIterator qIter) {
        return new QueryIteratorCopy(qIter);
    }

    public static QueryIterator map(QueryIterator qIter, Map<Var, Var> varMapping) {
        return new QueryIteratorMapped(qIter, varMapping);
    }

    public static QueryIter flatMap(QueryIterator input, final Function<Binding, QueryIterator> mapper, ExecutionContext execCxt) {
        return new QueryIterRepeatApply(input, execCxt){

            @Override
            protected QueryIterator nextStage(Binding binding) {
                return (QueryIterator)mapper.apply(binding);
            }
        };
    }

    @Override
    public final void close() {
        super.close();
        this.deregister();
    }

    public ExecutionContext getExecContext() {
        return this.tracker;
    }

    public int getIteratorNumber() {
        return this.iteratorNumber;
    }

    @Override
    public void output(IndentedWriter out) {
        this.output(out, null);
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.println((Object)this.getIteratorNumber());
    }

    private void register() {
        if (this.tracker != null) {
            this.tracker.openIterator(this);
        }
    }

    private void deregister() {
        if (this.tracker != null) {
            this.tracker.closedIterator(this);
        }
    }
}

