/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.sys;

import java.util.Properties;
import java.util.Set;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.tdb1.TDB1;

public class EnvTDB {
    static final String prefix = "tdb:";

    public static void processGlobalSystemProperties() {
        Context context = EnvTDB.processProperties(System.getProperties());
        TDB1.getContext().putAll(context);
    }

    public static Context processProperties(Properties properties) {
        Context context = new Context();
        Set<Object> keys = properties.keySet();
        for (Object key : keys) {
            if (!(key instanceof String)) continue;
            Object keyStr = (String)key;
            if (((String)keyStr).startsWith(prefix)) {
                keyStr = "http://jena.hpl.hp.com/TDB#" + ((String)keyStr).substring(prefix.length());
            }
            if (!((String)keyStr).startsWith("http://jena.hpl.hp.com/TDB#")) continue;
            Object value = properties.get(key);
            Symbol symbol = Symbol.create((String)keyStr);
            context.set(symbol, value);
        }
        return context;
    }
}

