/*
 * Decompiled with CFR 0.152.
 */
package org.castor.transactionmanager;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.transactionmanager.TransactionManagerAcquireException;
import org.castor.transactionmanager.TransactionManagerFactory;

public final class JNDIENCTransactionManagerFactory
implements TransactionManagerFactory {
    private static final Log LOG = LogFactory.getLog((Class)JNDIENCTransactionManagerFactory.class);
    public static final String TRANSACTION_MANAGER_NAME = "java:comp/TransactionManager";
    public static final String NAME = "jndi";

    public String getName() {
        return NAME;
    }

    public TransactionManager getTransactionManager(Properties properties) throws TransactionManagerAcquireException {
        String jndiENC = properties.getProperty("jndiEnc", TRANSACTION_MANAGER_NAME);
        Object found = null;
        TransactionManager transactionManager = null;
        try {
            found = new InitialContext().lookup(jndiENC);
            transactionManager = (TransactionManager)found;
        }
        catch (ClassCastException ex) {
            String msg = "Problem casting instance of " + found.getClass().getName() + " to javax.transaction.TransactionManager.";
            LOG.error((Object)msg);
            throw new TransactionManagerAcquireException(msg, ex);
        }
        catch (Exception ex) {
            String msg = "Unable to acquire instance of javax.transaction.TransactionManager: " + jndiENC;
            LOG.error((Object)msg);
            throw new TransactionManagerAcquireException(msg, ex);
        }
        if (transactionManager == null) {
            String msg = "Unable to acquire instance of javax.transaction.TransactionManager: " + jndiENC;
            LOG.error((Object)msg);
            throw new TransactionManagerAcquireException(msg);
        }
        return transactionManager;
    }
}

