/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.TreePath;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.debugger.treestatus.TreeStatus;
import org.apache.pdfbox.debugger.ui.ArrayEntry;
import org.apache.pdfbox.debugger.ui.FileOpenSaveDialog;
import org.apache.pdfbox.debugger.ui.MapEntry;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.common.PDStream;

public class Tree
extends JTree {
    private final JPopupMenu treePopupMenu = new JPopupMenu();
    private final Object rootNode;

    public Tree(Component parentComponent) {
        this.setComponentPopupMenu(this.treePopupMenu);
        this.rootNode = this.getModel().getRoot();
    }

    @Override
    public Point getPopupLocation(MouseEvent event) {
        if (event != null) {
            TreePath path = this.getClosestPathForLocation(event.getX(), event.getY());
            if (path == null) {
                return null;
            }
            this.setSelectionPath(path);
            this.treePopupMenu.removeAll();
            this.addPopupMenuItems(path);
            return event.getPoint();
        }
        return null;
    }

    private void addPopupMenuItems(TreePath nodePath) {
        JMenuItem open;
        Object obj = nodePath.getLastPathComponent();
        this.treePopupMenu.add(this.getTreePathMenuItem(nodePath));
        if (obj instanceof MapEntry) {
            obj = ((MapEntry)obj).getValue();
        } else if (obj instanceof ArrayEntry) {
            obj = ((ArrayEntry)obj).getValue();
        }
        if (!(obj instanceof COSStream)) {
            return;
        }
        this.treePopupMenu.addSeparator();
        COSStream stream = (COSStream)obj;
        this.treePopupMenu.add(this.getStreamSaveMenu(stream, nodePath));
        if (stream.getFilters() != null) {
            if (stream.getFilters() instanceof COSArray && ((COSArray)stream.getFilters()).size() >= 2) {
                for (JMenuItem menuItem : this.getPartiallyDecodedStreamSaveMenu(stream)) {
                    this.treePopupMenu.add(menuItem);
                }
            }
            this.treePopupMenu.add(this.getRawStreamSaveMenu(stream));
        }
        if ((open = this.getFileOpenMenu(stream, nodePath)) != null) {
            this.treePopupMenu.addSeparator();
            this.treePopupMenu.add(open);
        }
    }

    private JMenuItem getTreePathMenuItem(final TreePath path) {
        JMenuItem copyPathMenuItem = new JMenuItem("Copy Tree Path");
        copyPathMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(new TreeStatus(Tree.this.rootNode).getStringForPath(path)), null);
            }
        });
        return copyPathMenuItem;
    }

    private JMenuItem getRawStreamSaveMenu(final COSStream cosStream) {
        JMenuItem saveMenuItem = new JMenuItem("Save Raw Stream (" + this.getFilters(cosStream) + ") As...");
        saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    byte[] bytes = IOUtils.toByteArray((InputStream)cosStream.createRawInputStream());
                    Tree.this.saveStream(bytes, null, null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        return saveMenuItem;
    }

    private String getFilters(COSStream cosStream) {
        StringBuilder sb = new StringBuilder();
        COSBase filters = cosStream.getFilters();
        if (filters instanceof COSName) {
            sb.append(((COSName)filters).getName());
        } else if (filters instanceof COSArray) {
            COSArray filterArray = (COSArray)filters;
            for (int i = 0; i < filterArray.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(((COSName)filterArray.get(i)).getName());
            }
        }
        return sb.toString();
    }

    private JMenuItem getStreamSaveMenu(final COSStream cosStream, TreePath nodePath) {
        final String extension = this.getFileExtensionForStream(cosStream, nodePath);
        final FileNameExtensionFilter fileFilter = extension != null ? (extension.equals("pdb") ? new FileNameExtensionFilter("Type 1 Font (*.pfb)", "pfb") : (extension.equals("ttf") ? new FileNameExtensionFilter("TrueType Font (*.ttf)", "ttf") : (extension.equals("cff") ? new FileNameExtensionFilter("Compact Font Format (*.cff)", "cff") : (extension.equals("otf") ? new FileNameExtensionFilter("OpenType Font (*.otf)", "otf") : null)))) : null;
        String format = extension != null ? " " + extension.toUpperCase() : "";
        JMenuItem saveMenuItem = new JMenuItem("Save Stream As" + format + "...");
        saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    byte[] bytes = IOUtils.toByteArray((InputStream)cosStream.createInputStream());
                    Tree.this.saveStream(bytes, fileFilter, extension);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        return saveMenuItem;
    }

    private String getFileExtensionForStream(COSStream cosStream, TreePath nodePath) {
        String name = nodePath.getLastPathComponent().toString();
        if (name.equals("FontFile")) {
            return "pfb";
        }
        if (name.equals("FontFile2")) {
            return "ttf";
        }
        if (name.equals("FontFile3")) {
            if (cosStream.getCOSName(COSName.SUBTYPE) == COSName.OPEN_TYPE) {
                return "otf";
            }
            return "cff";
        }
        return null;
    }

    private JMenuItem getFileOpenMenu(final COSStream cosStream, TreePath nodePath) {
        final String extension = this.getFileExtensionForStream(cosStream, nodePath);
        if (extension == null) {
            return null;
        }
        JMenuItem openMenuItem = new JMenuItem("Open with Default Application");
        openMenuItem.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    byte[] bytes = IOUtils.toByteArray((InputStream)cosStream.createInputStream());
                    File temp = File.createTempFile("pdfbox", "." + extension);
                    temp.deleteOnExit();
                    FileOutputStream outputStream = null;
                    try {
                        outputStream = new FileOutputStream(temp);
                        outputStream.write(bytes);
                        Desktop.getDesktop().open(temp);
                    }
                    finally {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        return openMenuItem;
    }

    private List<JMenuItem> getPartiallyDecodedStreamSaveMenu(COSStream cosStream) {
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        PDStream stream = new PDStream(cosStream);
        List filters = stream.getFilters();
        for (int i = filters.size() - 1; i >= 1; --i) {
            menuItems.add(this.getPartialStreamSavingMenuItem(i, stream));
        }
        return menuItems;
    }

    private JMenuItem getPartialStreamSavingMenuItem(int indexOfStopFilter, final PDStream stream) {
        List filters = stream.getFilters();
        final ArrayList<String> stopFilters = new ArrayList<String>(1);
        stopFilters.add(((COSName)filters.get(indexOfStopFilter)).getName());
        StringBuilder nameListBuilder = new StringBuilder();
        for (int i = indexOfStopFilter; i < filters.size(); ++i) {
            nameListBuilder.append(((COSName)filters.get(i)).getName()).append(" & ");
        }
        nameListBuilder.delete(nameListBuilder.lastIndexOf("&"), nameListBuilder.length());
        JMenuItem menuItem = new JMenuItem("Keep " + nameListBuilder.toString() + "...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    InputStream data = stream.createInputStream(stopFilters);
                    Tree.this.saveStream(IOUtils.toByteArray((InputStream)data), null, null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        return menuItem;
    }

    private void saveStream(byte[] bytes, FileFilter filter, String extension) throws IOException {
        FileOpenSaveDialog saveDialog = new FileOpenSaveDialog(this.getParent(), filter);
        saveDialog.saveFile(bytes, extension);
    }
}

