/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.Guard;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class GuardCondition
extends Guard {
    private Expression condition;

    public GuardCondition(HiddenTokenAwareTree underlyingStructure) {
        super(underlyingStructure);
    }

    public GuardCondition(HiddenTokenAwareTree underlyingStructure, Expression condition) {
        super(underlyingStructure);
        this.condition = condition;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.condition);
    }

    @Override
    public Guard.Type getGuardType() {
        return Guard.Type.CONDITION;
    }

    @Override
    public GuardCondition clone() {
        GuardCondition result = (GuardCondition)super.clone();
        result.condition = this.condition == null ? null : this.condition.clone();
        result.configureParentToAllChilds();
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append(this.condition).append("]");
        return builder.toString();
    }
}

