/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.io.Serializable;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.qpid.server.model.ConfiguredObject;

public interface QpidPrincipal
extends Principal,
Serializable {
    public static <P extends Principal> P getSingletonPrincipal(Subject authSubject, boolean isPrincipalOptional, Class<P> principalClazz) {
        if (authSubject == null) {
            throw new IllegalArgumentException("No authenticated subject.");
        }
        Set<P> principals = authSubject.getPrincipals(principalClazz);
        int numberOfAuthenticatedPrincipals = principals.size();
        if (numberOfAuthenticatedPrincipals == 0 && isPrincipalOptional) {
            return null;
        }
        if (numberOfAuthenticatedPrincipals != 1) {
            throw new IllegalArgumentException(String.format("Can't find single %s in the authenticated subject. There were %d %s principals out of a total number of principals of: %s", principalClazz.getSimpleName(), numberOfAuthenticatedPrincipals, principalClazz.getSimpleName(), authSubject.getPrincipals()));
        }
        return (P)((Principal)principals.iterator().next());
    }

    public ConfiguredObject<?> getOrigin();
}

