/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.leader;

import java.io.InterruptedIOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import org.apache.ratis.server.leader.LogAppenderBase;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LogAppenderDaemon {
    public static final Logger LOG = LoggerFactory.getLogger(LogAppenderDaemon.class);
    private final String name;
    private final LifeCycle lifeCycle;
    private final Daemon daemon;
    private final LogAppenderBase logAppender;
    private final CompletableFuture<LifeCycle.State> closeFuture = new CompletableFuture();
    static final UnaryOperator<LifeCycle.State> TRY_TO_RUN = current -> {
        if (current == LifeCycle.State.STARTING) {
            return LifeCycle.State.RUNNING;
        }
        if (LifeCycle.States.CLOSING_OR_CLOSED_OR_EXCEPTION.contains(current)) {
            return current;
        }
        throw new IllegalArgumentException("Cannot to tryToRun from " + (Object)current);
    };
    static final UnaryOperator<LifeCycle.State> TRANSITION_FINALLY = current -> {
        if (LifeCycle.State.isValid(current, LifeCycle.State.CLOSED)) {
            return LifeCycle.State.CLOSED;
        }
        if (LifeCycle.State.isValid(current, LifeCycle.State.EXCEPTION)) {
            return LifeCycle.State.EXCEPTION;
        }
        return current;
    };
    static final UnaryOperator<LifeCycle.State> TRY_TO_CLOSE = current -> {
        if (current == LifeCycle.State.NEW) {
            return LifeCycle.State.CLOSED;
        }
        if (current.isClosingOrClosed()) {
            return current;
        }
        if (LifeCycle.State.isValid(current, LifeCycle.State.CLOSING)) {
            return LifeCycle.State.CLOSING;
        }
        throw new IllegalArgumentException("Cannot to tryToClose from " + (Object)current);
    };

    LogAppenderDaemon(LogAppenderBase logAppender) {
        this.logAppender = logAppender;
        this.name = logAppender + "-" + JavaUtils.getClassSimpleName(this.getClass());
        this.lifeCycle = new LifeCycle(this.name);
        this.daemon = Daemon.newBuilder().setName(this.name).setRunnable(this::run).setThreadGroup(logAppender.getServer().getThreadGroup()).build();
    }

    public boolean isWorking() {
        return !LifeCycle.States.CLOSING_OR_CLOSED_OR_EXCEPTION.contains((Object)this.lifeCycle.getCurrentState());
    }

    public void tryToStart() {
        if (this.lifeCycle.compareAndTransition(LifeCycle.State.NEW, LifeCycle.State.STARTING)) {
            this.daemon.start();
        }
    }

    private void run() {
        try {
            if (this.lifeCycle.transition(TRY_TO_RUN) == LifeCycle.State.RUNNING) {
                this.logAppender.run();
            }
            this.lifeCycle.compareAndTransition(LifeCycle.State.RUNNING, LifeCycle.State.CLOSING);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info(this + " was interrupted: " + e);
        }
        catch (InterruptedIOException e) {
            LOG.info(this + " I/O was interrupted: " + e);
        }
        catch (Throwable e) {
            LOG.warn(this + " failed", e);
            this.lifeCycle.transitionIfValid(LifeCycle.State.EXCEPTION);
        }
        finally {
            LifeCycle.State finalState = this.lifeCycle.transitionAndGet(TRANSITION_FINALLY);
            if (finalState == LifeCycle.State.EXCEPTION) {
                this.logAppender.restart();
            }
            this.closeFuture.complete(finalState);
        }
    }

    public CompletableFuture<LifeCycle.State> tryToClose() {
        LifeCycle.State state = this.lifeCycle.transition(TRY_TO_CLOSE);
        if (state == LifeCycle.State.CLOSING) {
            this.daemon.interrupt();
        } else if (state == LifeCycle.State.CLOSED) {
            this.closeFuture.complete(state);
        }
        return this.closeFuture;
    }

    public String toString() {
        return this.name;
    }
}

