/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics.impl;

import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.ratis.metrics.LongCounter;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.Timekeeper;
import org.apache.ratis.metrics.impl.DefaultTimekeeperImpl;
import org.apache.ratis.thirdparty.com.codahale.metrics.ConsoleReporter;
import org.apache.ratis.thirdparty.com.codahale.metrics.Counter;
import org.apache.ratis.thirdparty.com.codahale.metrics.Gauge;
import org.apache.ratis.thirdparty.com.codahale.metrics.Metric;
import org.apache.ratis.thirdparty.com.codahale.metrics.MetricFilter;
import org.apache.ratis.thirdparty.com.codahale.metrics.MetricRegistry;
import org.apache.ratis.thirdparty.com.codahale.metrics.MetricSet;
import org.apache.ratis.thirdparty.com.codahale.metrics.jmx.JmxReporter;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;

public class RatisMetricRegistryImpl
implements RatisMetricRegistry {
    private final MetricRegistry metricRegistry = new MetricRegistry();
    private final MetricRegistryInfo info;
    private final String namePrefix;
    private final Map<String, String> metricNameCache = new ConcurrentHashMap<String, String>();
    private JmxReporter jmxReporter;
    private ConsoleReporter consoleReporter;

    static RatisMetricRegistryImpl cast(RatisMetricRegistry registry) {
        if (!(registry instanceof RatisMetricRegistryImpl)) {
            throw new IllegalStateException("Unexpected class: " + registry.getClass().getName());
        }
        return (RatisMetricRegistryImpl)registry;
    }

    public RatisMetricRegistryImpl(MetricRegistryInfo info) {
        this.info = Objects.requireNonNull(info, "info == null");
        this.namePrefix = MetricRegistry.name((String)info.getApplicationName(), (String[])new String[]{info.getMetricsComponentName(), info.getPrefix()});
    }

    public Timekeeper timer(String name) {
        return new DefaultTimekeeperImpl(this.metricRegistry.timer(this.getMetricName(name)));
    }

    static LongCounter toLongCounter(final Counter c) {
        return new LongCounter(){

            public void inc(long n) {
                c.inc(n);
            }

            public void dec(long n) {
                c.dec(n);
            }

            public long getCount() {
                return c.getCount();
            }
        };
    }

    public LongCounter counter(String name) {
        return RatisMetricRegistryImpl.toLongCounter(this.metricRegistry.counter(this.getMetricName(name)));
    }

    public boolean remove(String name) {
        return this.metricRegistry.remove(this.getMetricName(name));
    }

    static <T> Gauge<T> toGauge(Supplier<T> supplier) {
        return supplier::get;
    }

    public <T> void gauge(String name, Supplier<Supplier<T>> gaugeSupplier) {
        this.metricRegistry.gauge(this.getMetricName(name), () -> RatisMetricRegistryImpl.toGauge((Supplier)gaugeSupplier.get()));
    }

    public SortedMap<String, Gauge> getGauges(MetricFilter filter) {
        return this.metricRegistry.getGauges(filter);
    }

    @VisibleForTesting
    public Metric get(String shortName) {
        return (Metric)this.metricRegistry.getMetrics().get(this.getMetricName(shortName));
    }

    private String getMetricName(String shortName) {
        return this.metricNameCache.computeIfAbsent(shortName, key -> MetricRegistry.name((String)this.namePrefix, (String[])new String[]{shortName}));
    }

    private <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        return (T)this.metricRegistry.register(this.getMetricName(name), metric);
    }

    public MetricRegistry getDropWizardMetricRegistry() {
        return this.metricRegistry;
    }

    public MetricRegistryInfo getMetricRegistryInfo() {
        return this.info;
    }

    void registerAll(String prefix, MetricSet metricSet) {
        for (Map.Entry entry : metricSet.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet) {
                this.registerAll(prefix + "." + (String)entry.getKey(), (MetricSet)entry.getValue());
                continue;
            }
            this.register(prefix + "." + (String)entry.getKey(), (Metric)entry.getValue());
        }
    }

    void setJmxReporter(JmxReporter jmxReporter) {
        this.jmxReporter = jmxReporter;
    }

    JmxReporter getJmxReporter() {
        return this.jmxReporter;
    }

    void setConsoleReporter(ConsoleReporter consoleReporter) {
        this.consoleReporter = consoleReporter;
    }

    ConsoleReporter getConsoleReporter() {
        return this.consoleReporter;
    }
}

