/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialOperator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.sedona.common.geometryObjects.Circle;
import org.apache.sedona.common.utils.GeomUtils;
import org.apache.sedona.core.enums.DistanceMetric;
import org.apache.sedona.core.enums.IndexType;
import org.apache.sedona.core.enums.JoinBuildSide;
import org.apache.sedona.core.joinJudgement.DedupParams;
import org.apache.sedona.core.joinJudgement.DuplicatesFilter;
import org.apache.sedona.core.joinJudgement.DynamicIndexLookupJudgement;
import org.apache.sedona.core.joinJudgement.KnnJoinIndexJudgement;
import org.apache.sedona.core.joinJudgement.LeftIndexLookupJudgement;
import org.apache.sedona.core.joinJudgement.NestedLoopJudgement;
import org.apache.sedona.core.joinJudgement.RightIndexLookupJudgement;
import org.apache.sedona.core.monitoring.Metrics;
import org.apache.sedona.core.spatialOperator.SpatialPredicate;
import org.apache.sedona.core.spatialPartitioning.SpatialPartitioner;
import org.apache.sedona.core.spatialRDD.CircleRDD;
import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.sedona.core.wrapper.UniqueGeometry;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.util.LongAccumulator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.strtree.STRtree;
import scala.Tuple2;

public class JoinQuery {
    private static final Logger log = LogManager.getLogger(JoinQuery.class);

    private static <U extends Geometry, T extends Geometry> void verifyCRSMatch(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD) throws Exception {
        if (spatialRDD.getCRStransformation() != queryRDD.getCRStransformation()) {
            throw new IllegalArgumentException("[JoinQuery] input RDD doesn't perform necessary CRS transformation. Please check your RDD constructors.");
        }
        if (spatialRDD.getCRStransformation() && queryRDD.getCRStransformation() && !spatialRDD.getTargetEpgsgCode().equalsIgnoreCase(queryRDD.getTargetEpgsgCode())) {
            throw new IllegalArgumentException("[JoinQuery] the EPSG codes of two input RDDs are different. Please check your RDD constructors.");
        }
    }

    private static <U extends Geometry, T extends Geometry> void verifyPartitioningMatch(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD) throws Exception {
        int queryNumPart;
        Objects.requireNonNull(spatialRDD.spatialPartitionedRDD, "[JoinQuery] spatialRDD SpatialPartitionedRDD is null. Please do spatial partitioning.");
        Objects.requireNonNull(queryRDD.spatialPartitionedRDD, "[JoinQuery] queryRDD SpatialPartitionedRDD is null. Please use the spatialRDD's grids to do spatial partitioning.");
        SpatialPartitioner spatialPartitioner = spatialRDD.getPartitioner();
        SpatialPartitioner queryPartitioner = queryRDD.getPartitioner();
        if (!queryPartitioner.equals(spatialPartitioner)) {
            throw new IllegalArgumentException("[JoinQuery] queryRDD is not partitioned by the same grids with spatialRDD. Please make sure they both use the same grids otherwise wrong results will appear.");
        }
        int spatialNumPart = spatialRDD.spatialPartitionedRDD.getNumPartitions();
        if (spatialNumPart != (queryNumPart = queryRDD.spatialPartitionedRDD.getNumPartitions())) {
            throw new IllegalArgumentException("[JoinQuery] numbers of partitions in queryRDD and spatialRDD don't match: " + queryNumPart + " vs. " + spatialNumPart + ". Please make sure they both use the same partitioning otherwise wrong results will appear.");
        }
    }

    private static <U extends Geometry, T extends Geometry> JavaPairRDD<U, List<T>> collectGeometriesByKey(JavaPairRDD<U, T> input) {
        return input.groupBy((Function & Serializable)t -> GeomUtils.hashCode((Geometry)t._1)).values().mapToPair((PairFunction & Serializable)t -> {
            ArrayList<Object> values = new ArrayList<Object>();
            Iterator it = t.iterator();
            Tuple2 firstTpl = (Tuple2)it.next();
            Geometry key = (Geometry)firstTpl._1;
            values.add(firstTpl._2);
            while (it.hasNext()) {
                values.add(((Tuple2)it.next())._2);
            }
            return new Tuple2((Object)key, values);
        });
    }

    private static <U extends Geometry, T extends Geometry> JavaPairRDD<U, Long> countGeometriesByKey(JavaPairRDD<U, T> input) {
        return input.aggregateByKey((Object)0L, new Function2<Long, T, Long>(){

            public Long call(Long count, T t) throws Exception {
                return count + 1L;
            }
        }, (Function2)new Function2<Long, Long, Long>(){

            public Long call(Long count1, Long count2) throws Exception {
                return count1 + count2;
            }
        });
    }

    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, List<T>> SpatialJoinQuery(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD, boolean useIndex, SpatialPredicate spatialPredicate) throws Exception {
        JoinParams joinParams = new JoinParams(useIndex, SpatialPredicate.inverse(spatialPredicate));
        JavaPairRDD<U, T> joinResults = JoinQuery.spatialJoin(queryRDD, spatialRDD, joinParams);
        return JoinQuery.collectGeometriesByKey(joinResults);
    }

    @Deprecated
    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, List<T>> SpatialJoinQuery(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        JoinParams joinParams = new JoinParams(useIndex, considerBoundaryIntersection);
        JavaPairRDD<U, T> joinResults = JoinQuery.spatialJoin(queryRDD, spatialRDD, joinParams);
        return JoinQuery.collectGeometriesByKey(joinResults);
    }

    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, List<T>> SpatialJoinQuery(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD, JoinParams joinParams) throws Exception {
        JavaPairRDD<U, T> joinResults = JoinQuery.spatialJoin(queryRDD, spatialRDD, joinParams);
        return JoinQuery.collectGeometriesByKey(joinResults);
    }

    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, T> SpatialJoinQueryFlat(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD, boolean useIndex, SpatialPredicate spatialPredicate) throws Exception {
        JoinParams params = new JoinParams(useIndex, SpatialPredicate.inverse(spatialPredicate));
        return JoinQuery.spatialJoin(queryRDD, spatialRDD, params);
    }

    @Deprecated
    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, T> SpatialJoinQueryFlat(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        JoinParams params = new JoinParams(useIndex, considerBoundaryIntersection);
        return JoinQuery.spatialJoin(queryRDD, spatialRDD, params);
    }

    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, T> SpatialJoinQueryFlat(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD, JoinParams joinParams) throws Exception {
        return JoinQuery.spatialJoin(queryRDD, spatialRDD, joinParams);
    }

    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, Long> SpatialJoinQueryCountByKey(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD, boolean useIndex, SpatialPredicate spatialPredicate) throws Exception {
        JoinParams joinParams = new JoinParams(useIndex, SpatialPredicate.inverse(spatialPredicate));
        JavaPairRDD<U, T> joinResults = JoinQuery.spatialJoin(queryRDD, spatialRDD, joinParams);
        return JoinQuery.countGeometriesByKey(joinResults);
    }

    @Deprecated
    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, Long> SpatialJoinQueryCountByKey(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        JoinParams joinParams = new JoinParams(useIndex, considerBoundaryIntersection);
        JavaPairRDD<U, T> joinResults = JoinQuery.spatialJoin(queryRDD, spatialRDD, joinParams);
        return JoinQuery.countGeometriesByKey(joinResults);
    }

    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, Long> SpatialJoinQueryCountByKey(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD, JoinParams joinParams) throws Exception {
        JavaPairRDD<U, T> joinResults = JoinQuery.spatialJoin(queryRDD, spatialRDD, joinParams);
        return JoinQuery.countGeometriesByKey(joinResults);
    }

    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, List<T>> KNNJoinQuery(SpatialRDD<T> objectRDD, SpatialRDD<U> queryRDD, IndexType indexType, int k, DistanceMetric distanceMetric) throws Exception {
        JoinParams joinParams = new JoinParams(true, null, IndexType.RTREE, null, k, distanceMetric, null);
        JavaPairRDD<U, T> joinResults = JoinQuery.knnJoin(queryRDD, objectRDD, joinParams, false, false);
        return JoinQuery.collectGeometriesByKey(joinResults);
    }

    public static <T extends Geometry> JavaPairRDD<Geometry, T> DistanceJoinQueryFlat(SpatialRDD<T> spatialRDD, CircleRDD queryRDD, boolean useIndex, SpatialPredicate spatialPredicate) throws Exception {
        if (spatialPredicate != SpatialPredicate.COVERED_BY && spatialPredicate != SpatialPredicate.INTERSECTS) {
            throw new IllegalArgumentException("Spatial predicate for distance join should be one of INTERSECTS and COVERED_BY");
        }
        JoinParams joinParams = new JoinParams(useIndex, SpatialPredicate.inverse(spatialPredicate));
        return JoinQuery.distanceJoin(spatialRDD, queryRDD, joinParams);
    }

    @Deprecated
    public static <T extends Geometry> JavaPairRDD<Geometry, T> DistanceJoinQueryFlat(SpatialRDD<T> spatialRDD, CircleRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        JoinParams joinParams = new JoinParams(useIndex, considerBoundaryIntersection);
        return JoinQuery.distanceJoin(spatialRDD, queryRDD, joinParams);
    }

    public static <T extends Geometry> JavaPairRDD<Geometry, T> DistanceJoinQueryFlat(SpatialRDD<T> spatialRDD, CircleRDD queryRDD, JoinParams joinParams) throws Exception {
        return JoinQuery.distanceJoin(spatialRDD, queryRDD, joinParams);
    }

    public static <T extends Geometry> JavaPairRDD<Geometry, List<T>> DistanceJoinQuery(SpatialRDD<T> spatialRDD, CircleRDD queryRDD, boolean useIndex, SpatialPredicate spatialPredicate) throws Exception {
        if (spatialPredicate != SpatialPredicate.COVERED_BY && spatialPredicate != SpatialPredicate.INTERSECTS) {
            throw new IllegalArgumentException("Spatial predicate for distance join should be one of INTERSECTS and COVERED_BY");
        }
        JoinParams joinParams = new JoinParams(useIndex, SpatialPredicate.inverse(spatialPredicate));
        JavaPairRDD<Geometry, T> joinResults = JoinQuery.distanceJoin(spatialRDD, queryRDD, joinParams);
        return JoinQuery.collectGeometriesByKey(joinResults);
    }

    @Deprecated
    public static <T extends Geometry> JavaPairRDD<Geometry, List<T>> DistanceJoinQuery(SpatialRDD<T> spatialRDD, CircleRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        JoinParams joinParams = new JoinParams(useIndex, considerBoundaryIntersection);
        JavaPairRDD<Geometry, T> joinResults = JoinQuery.distanceJoin(spatialRDD, queryRDD, joinParams);
        return JoinQuery.collectGeometriesByKey(joinResults);
    }

    public static <T extends Geometry> JavaPairRDD<Geometry, List<T>> DistanceJoinQuery(SpatialRDD<T> spatialRDD, CircleRDD queryRDD, JoinParams joinParams) throws Exception {
        JavaPairRDD<Geometry, T> joinResults = JoinQuery.distanceJoin(spatialRDD, queryRDD, joinParams);
        return JoinQuery.collectGeometriesByKey(joinResults);
    }

    public static <T extends Geometry> JavaPairRDD<Geometry, Long> DistanceJoinQueryCountByKey(SpatialRDD<T> spatialRDD, CircleRDD queryRDD, boolean useIndex, SpatialPredicate spatialPredicate) throws Exception {
        if (spatialPredicate != SpatialPredicate.COVERED_BY && spatialPredicate != SpatialPredicate.INTERSECTS) {
            throw new IllegalArgumentException("Spatial predicate for distance join should be one of INTERSECTS and COVERED_BY");
        }
        JoinParams joinParams = new JoinParams(useIndex, SpatialPredicate.inverse(spatialPredicate));
        JavaPairRDD<Geometry, T> joinResults = JoinQuery.distanceJoin(spatialRDD, queryRDD, joinParams);
        return JoinQuery.countGeometriesByKey(joinResults);
    }

    @Deprecated
    public static <T extends Geometry> JavaPairRDD<Geometry, Long> DistanceJoinQueryCountByKey(SpatialRDD<T> spatialRDD, CircleRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        JoinParams joinParams = new JoinParams(useIndex, considerBoundaryIntersection);
        JavaPairRDD<Geometry, T> joinResults = JoinQuery.distanceJoin(spatialRDD, queryRDD, joinParams);
        return JoinQuery.countGeometriesByKey(joinResults);
    }

    public static <T extends Geometry> JavaPairRDD<Geometry, Long> DistanceJoinQueryCountByKey(SpatialRDD<T> spatialRDD, CircleRDD queryRDD, JoinParams joinParams) throws Exception {
        JavaPairRDD<Geometry, T> joinResults = JoinQuery.distanceJoin(spatialRDD, queryRDD, joinParams);
        return JoinQuery.countGeometriesByKey(joinResults);
    }

    public static <T extends Geometry> JavaPairRDD<Geometry, T> distanceJoin(SpatialRDD<T> spatialRDD, CircleRDD queryRDD, JoinParams joinParams) throws Exception {
        JavaPairRDD<Circle, T> joinResults = JoinQuery.spatialJoin(queryRDD, spatialRDD, joinParams);
        return joinResults.mapToPair(new PairFunction<Tuple2<Circle, T>, Geometry, T>(){

            public Tuple2<Geometry, T> call(Tuple2<Circle, T> circleTTuple2) throws Exception {
                return new Tuple2((Object)((Circle)circleTTuple2._1()).getCenterGeometry(), circleTTuple2._2());
            }
        });
    }

    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, T> spatialJoin(SpatialRDD<U> leftRDD, SpatialRDD<T> rightRDD, JoinParams joinParams) throws Exception {
        JavaRDD joinResult;
        JoinQuery.verifyCRSMatch(leftRDD, rightRDD);
        JoinQuery.verifyPartitioningMatch(leftRDD, rightRDD);
        SparkContext sparkContext = leftRDD.spatialPartitionedRDD.context();
        LongAccumulator buildCount = Metrics.createMetric(sparkContext, "buildCount");
        LongAccumulator streamCount = Metrics.createMetric(sparkContext, "streamCount");
        LongAccumulator resultCount = Metrics.createMetric(sparkContext, "resultCount");
        LongAccumulator candidateCount = Metrics.createMetric(sparkContext, "candidateCount");
        SpatialPartitioner partitioner = (SpatialPartitioner)rightRDD.spatialPartitionedRDD.partitioner().get();
        DedupParams dedupParams = partitioner.getDedupParams();
        SparkContext cxt = leftRDD.rawSpatialRDD.context();
        if (joinParams.useIndex) {
            if (rightRDD.indexedRDD != null) {
                RightIndexLookupJudgement judgement = new RightIndexLookupJudgement(joinParams.spatialPredicate, buildCount, streamCount, resultCount, candidateCount);
                joinResult = leftRDD.spatialPartitionedRDD.zipPartitions(rightRDD.indexedRDD, judgement);
            } else if (leftRDD.indexedRDD != null) {
                LeftIndexLookupJudgement judgement = new LeftIndexLookupJudgement(joinParams.spatialPredicate, buildCount, streamCount, resultCount, candidateCount);
                joinResult = leftRDD.indexedRDD.zipPartitions(rightRDD.spatialPartitionedRDD, judgement);
            } else {
                log.warn((Object)"UseIndex is true, but no index exists. Will build index on the fly.");
                DynamicIndexLookupJudgement judgement = new DynamicIndexLookupJudgement(joinParams.spatialPredicate, joinParams.indexType, joinParams.joinBuildSide, buildCount, streamCount, resultCount, candidateCount);
                joinResult = leftRDD.spatialPartitionedRDD.zipPartitions(rightRDD.spatialPartitionedRDD, judgement);
            }
        } else {
            NestedLoopJudgement judgement = new NestedLoopJudgement(joinParams.spatialPredicate, buildCount, streamCount, resultCount, candidateCount);
            joinResult = rightRDD.spatialPartitionedRDD.zipPartitions(leftRDD.spatialPartitionedRDD, judgement);
        }
        return joinResult.mapPartitionsWithIndex(new DuplicatesFilter((Broadcast<DedupParams>)new JavaSparkContext(cxt).broadcast((Object)dedupParams)), false).mapToPair((PairFunction & Serializable)pair -> new Tuple2(pair.getKey(), pair.getValue()));
    }

    private static <U extends Geometry, T extends Geometry> void verifyPartitioningNumberMatch(SpatialRDD<T> spatialRDD, SpatialRDD<U> queryRDD) throws Exception {
        Objects.requireNonNull(spatialRDD.spatialPartitionedRDD, "[JoinQuery] spatialRDD SpatialPartitionedRDD is null. Please do spatial partitioning.");
        Objects.requireNonNull(queryRDD.spatialPartitionedRDD, "[JoinQuery] queryRDD SpatialPartitionedRDD is null. Please use the spatialRDD's grids to do spatial partitioning.");
        SpatialPartitioner spatialPartitioner = spatialRDD.getPartitioner();
        SpatialPartitioner queryPartitioner = queryRDD.getPartitioner();
        int spatialNumPart = spatialRDD.spatialPartitionedRDD.getNumPartitions();
        int queryNumPart = queryRDD.spatialPartitionedRDD.getNumPartitions();
        if (spatialNumPart != queryNumPart) {
            throw new IllegalArgumentException("[JoinQuery] numbers of partitions in queryRDD and spatialRDD don't match: " + queryNumPart + " vs. " + spatialNumPart + ". Please make sure they both use the same partitioning otherwise wrong results will appear.");
        }
    }

    public static <U extends Geometry, T extends Geometry> JavaPairRDD<U, T> knnJoin(SpatialRDD<U> queryRDD, SpatialRDD<T> objectRDD, JoinParams joinParams, boolean includeTies, boolean broadcastJoin) throws Exception {
        JavaRDD<Pair<U, T>> joinResult;
        KnnJoinIndexJudgement judgement;
        Broadcast broadcastObjectsTreeIndex;
        Broadcast broadcastQueryObjects;
        JoinQuery.verifyCRSMatch(queryRDD, objectRDD);
        if (!broadcastJoin) {
            JoinQuery.verifyPartitioningNumberMatch(queryRDD, objectRDD);
        }
        SparkContext sparkContext = queryRDD.rawSpatialRDD.context();
        LongAccumulator buildCount = Metrics.createMetric(sparkContext, "buildCount");
        LongAccumulator streamCount = Metrics.createMetric(sparkContext, "streamCount");
        LongAccumulator resultCount = Metrics.createMetric(sparkContext, "resultCount");
        LongAccumulator candidateCount = Metrics.createMetric(sparkContext, "candidateCount");
        if (broadcastJoin && objectRDD.indexedRawRDD != null && objectRDD.indexedRDD == null) {
            ArrayList<UniqueGeometry<Geometry>> uniqueQueryObjects = new ArrayList<UniqueGeometry<Geometry>>();
            for (Geometry queryObject : queryRDD.rawSpatialRDD.collect()) {
                uniqueQueryObjects.add(new UniqueGeometry<Geometry>(queryObject));
            }
            broadcastQueryObjects = JavaSparkContext.fromSparkContext((SparkContext)sparkContext).broadcast(uniqueQueryObjects);
            broadcastObjectsTreeIndex = null;
        } else if (broadcastJoin && objectRDD.indexedRawRDD == null && objectRDD.indexedRDD == null) {
            STRtree strTree = objectRDD.coalesceAndBuildRawIndex(IndexType.RTREE);
            broadcastObjectsTreeIndex = JavaSparkContext.fromSparkContext((SparkContext)sparkContext).broadcast((Object)strTree);
            broadcastQueryObjects = null;
        } else {
            broadcastQueryObjects = null;
            broadcastObjectsTreeIndex = null;
        }
        if (broadcastObjectsTreeIndex == null && broadcastQueryObjects == null) {
            judgement = new KnnJoinIndexJudgement(joinParams.k, joinParams.searchRadius, joinParams.distanceMetric, includeTies, null, null, buildCount, streamCount, resultCount, candidateCount);
            joinResult = queryRDD.spatialPartitionedRDD.zipPartitions(objectRDD.indexedRDD, judgement);
        } else if (broadcastObjectsTreeIndex != null) {
            judgement = new KnnJoinIndexJudgement(joinParams.k, joinParams.searchRadius, joinParams.distanceMetric, includeTies, null, (Broadcast<STRtree>)broadcastObjectsTreeIndex, buildCount, streamCount, resultCount, candidateCount);
            joinResult = queryRDD.rawSpatialRDD.zipPartitions(queryRDD.rawSpatialRDD, judgement);
        } else if (broadcastQueryObjects != null) {
            judgement = new KnnJoinIndexJudgement(joinParams.k, joinParams.searchRadius, joinParams.distanceMetric, includeTies, (Broadcast<List>)broadcastQueryObjects, null, buildCount, streamCount, resultCount, candidateCount);
            joinResult = JoinQuery.querySideBroadcastKNNJoin(objectRDD, joinParams, judgement, includeTies);
        } else {
            throw new IllegalArgumentException("No index found on the input RDDs.");
        }
        return joinResult.mapToPair((PairFunction & Serializable)pair -> new Tuple2(pair.getKey(), pair.getValue()));
    }

    private static <U extends Geometry, T extends Geometry> JavaRDD<Pair<U, T>> querySideBroadcastKNNJoin(SpatialRDD<T> objectRDD, JoinParams joinParams, KnnJoinIndexJudgement judgement, boolean includeTies) {
        JavaRDD joinResultMapped = objectRDD.indexedRawRDD.mapPartitions((FlatMapFunction & Serializable)iterator -> {
            ArrayList results = new ArrayList();
            if (iterator.hasNext()) {
                SpatialIndex spatialIndex = (SpatialIndex)iterator.next();
                Iterator callResult = judgement.call(null, Collections.singletonList(spatialIndex).iterator());
                callResult.forEachRemaining(results::add);
            }
            return results.iterator();
        });
        int k = joinParams.k;
        DistanceMetric distanceMetric = joinParams.distanceMetric;
        JavaRDD joinResult = joinResultMapped.groupBy((Function & Serializable)pair -> (Geometry)pair.getKey()).flatMap((FlatMapFunction & Serializable)pair -> {
            ArrayList topPairs;
            Iterable values = (Iterable)pair._2;
            ArrayList<Pair> sortedPairs = new ArrayList<Pair>();
            for (Pair p : values) {
                Pair newPair = Pair.of((Object)((Geometry)((UniqueGeometry)p.getKey()).getOriginalGeometry()), (Object)p.getValue());
                sortedPairs.add(newPair);
            }
            sortedPairs.sort((p1, p2) -> {
                double distance1 = KnnJoinIndexJudgement.distance((Geometry)p1.getKey(), (Geometry)p1.getValue(), distanceMetric);
                double distance2 = KnnJoinIndexJudgement.distance((Geometry)p2.getKey(), (Geometry)p2.getValue(), distanceMetric);
                return Double.compare(distance1, distance2);
            });
            if (includeTies) {
                topPairs = new ArrayList();
                double kthDistance = -1.0;
                for (int i = 0; i < sortedPairs.size(); ++i) {
                    if (i < k) {
                        topPairs.add(sortedPairs.get(i));
                        if (i != k - 1) continue;
                        kthDistance = KnnJoinIndexJudgement.distance((Geometry)((Pair)sortedPairs.get(i)).getKey(), (Geometry)((Pair)sortedPairs.get(i)).getValue(), distanceMetric);
                        continue;
                    }
                    double currentDistance = KnnJoinIndexJudgement.distance((Geometry)((Pair)sortedPairs.get(i)).getKey(), (Geometry)((Pair)sortedPairs.get(i)).getValue(), distanceMetric);
                    if (currentDistance != kthDistance) break;
                    topPairs.add(sortedPairs.get(i));
                }
                return topPairs.iterator();
            }
            topPairs = new ArrayList();
            for (int i = 0; i < Math.min(k, sortedPairs.size()); ++i) {
                topPairs.add(sortedPairs.get(i));
            }
            return topPairs.iterator();
        });
        return joinResult;
    }

    public static final class JoinParams {
        public final boolean useIndex;
        public final SpatialPredicate spatialPredicate;
        public final IndexType indexType;
        public final JoinBuildSide joinBuildSide;
        public final int k;
        public final DistanceMetric distanceMetric;
        public final Double searchRadius;

        public JoinParams(boolean useIndex, SpatialPredicate spatialPredicate, IndexType polygonIndexType, JoinBuildSide joinBuildSide) {
            this(useIndex, spatialPredicate, polygonIndexType, joinBuildSide, -1, null, null);
        }

        public JoinParams(boolean useIndex, SpatialPredicate spatialPredicate, IndexType polygonIndexType, JoinBuildSide joinBuildSide, int k, DistanceMetric distanceMetric, Double searchRadius) {
            this.useIndex = useIndex;
            this.spatialPredicate = spatialPredicate;
            this.indexType = polygonIndexType;
            this.joinBuildSide = joinBuildSide;
            this.k = k;
            this.distanceMetric = distanceMetric;
            this.searchRadius = searchRadius;
        }

        public JoinParams(boolean useIndex, SpatialPredicate spatialPredicate) {
            this(useIndex, spatialPredicate, IndexType.RTREE, JoinBuildSide.RIGHT);
        }

        @Deprecated
        public JoinParams(boolean useIndex, boolean considerBoundaryIntersection) {
            this(useIndex, considerBoundaryIntersection, IndexType.RTREE, JoinBuildSide.RIGHT);
        }

        @Deprecated
        public JoinParams(boolean useIndex, boolean considerBoundaryIntersection, IndexType polygonIndexType, JoinBuildSide joinBuildSide) {
            this(useIndex, considerBoundaryIntersection ? SpatialPredicate.INTERSECTS : SpatialPredicate.COVERS, polygonIndexType, joinBuildSide);
        }
    }
}

