/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.util.Format;
import ucar.units.ConversionException;
import ucar.units.UnitException;

public class TimeUnit
extends SimpleUnit {
    private double value;
    private double factor = 1.0;
    private String unitString;
    private int hashCode;

    public TimeUnit(String text) throws UnitException {
        if (text == null) {
            this.value = 1.0;
            this.unitString = "secs";
            this.uu = SimpleUnit.makeUnit(this.unitString);
            return;
        }
        StringTokenizer stoker = new StringTokenizer(text);
        int ntoke = stoker.countTokens();
        if (ntoke == 1) {
            this.value = 1.0;
            this.unitString = stoker.nextToken();
        } else if (ntoke == 2) {
            this.value = Double.parseDouble(stoker.nextToken());
            this.unitString = stoker.nextToken();
        } else {
            throw new IllegalArgumentException("Not TimeUnit = " + text);
        }
        this.uu = SimpleUnit.makeUnit(this.unitString);
        this.factor = this.uu.convertTo(1.0, SimpleUnit.secsUnit);
    }

    public TimeUnit(double value, String unitString) throws UnitException {
        this.value = value;
        this.unitString = unitString;
        this.uu = SimpleUnit.makeUnit(unitString);
        this.factor = this.uu.convertTo(1.0, SimpleUnit.secsUnit);
    }

    public TimeUnit(TimeUnit src) {
        this.value = src.getValue();
        this.unitString = src.getUnitString();
        this.uu = src.uu;
        this.factor = src.getFactor();
    }

    @Override
    public double getValue() {
        return this.value;
    }

    public double getFactor() {
        return this.factor;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public String getUnitString() {
        return this.unitString;
    }

    @Override
    public String toString() {
        return Format.d(this.value, 5) + " " + this.unitString;
    }

    public double getValueInSeconds() {
        return this.factor * this.value;
    }

    public double getValueInSeconds(double value) {
        return this.factor * value;
    }

    public void setValueInSeconds(double secs) {
        this.value = secs / this.factor;
    }

    public double convertTo(double value, TimeUnit outputUnit) throws ConversionException {
        return this.uu.convertTo(value, outputUnit.uu);
    }

    public Date add(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(13, (int)this.getValueInSeconds());
        return cal.getTime();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeUnit)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.unitString.hashCode();
            this.hashCode = result = 37 * result + (int)(1000.0 * this.value);
        }
        return this.hashCode;
    }
}

