/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp;

import java.io.Serializable;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeReader;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public abstract class ShapeParser
implements Serializable {
    protected final GeometryFactory geometryFactory;

    protected ShapeParser(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public abstract Geometry parseShape(ShapeReader var1);

    protected static boolean isNoData(double value) {
        return value < -1.0E38 || value == 0.0;
    }

    protected Coordinate[] readCoordinates(ShapeReader reader, int numPoints) {
        Coordinate[] coordinates = new Coordinate[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            double x = reader.readDouble();
            double y = reader.readDouble();
            coordinates[i] = new Coordinate(x, y);
        }
        return coordinates;
    }

    protected Coordinate[] readCoordinatesWithZM(ShapeReader reader, int numPoints) {
        int i;
        double[] x = new double[numPoints];
        double[] y = new double[numPoints];
        double[] z = new double[numPoints];
        double[] m3 = new double[numPoints];
        for (i = 0; i < numPoints; ++i) {
            x[i] = reader.readDouble();
            y[i] = reader.readDouble();
        }
        reader.skip(16);
        for (i = 0; i < numPoints; ++i) {
            z[i] = reader.readDouble();
        }
        reader.skip(16);
        boolean allMNoData = true;
        for (int i2 = 0; i2 < numPoints; ++i2) {
            m3[i2] = reader.readDouble();
            if (ShapeParser.isNoData(m3[i2])) continue;
            allMNoData = false;
        }
        Coordinate[] coordinates = new Coordinate[numPoints];
        if (allMNoData) {
            for (int i3 = 0; i3 < numPoints; ++i3) {
                coordinates[i3] = new Coordinate(x[i3], y[i3], z[i3]);
            }
        } else {
            for (int i4 = 0; i4 < numPoints; ++i4) {
                coordinates[i4] = new CoordinateXYZM(x[i4], y[i4], z[i4], m3[i4]);
            }
        }
        return coordinates;
    }

    protected Coordinate[] readCoordinatesWithM(ShapeReader reader, int numPoints) {
        double[] x = new double[numPoints];
        double[] y = new double[numPoints];
        double[] m3 = new double[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            x[i] = reader.readDouble();
            y[i] = reader.readDouble();
        }
        reader.skip(16);
        boolean allMNoData = true;
        for (int i = 0; i < numPoints; ++i) {
            m3[i] = reader.readDouble();
            if (ShapeParser.isNoData(m3[i])) continue;
            allMNoData = false;
        }
        Coordinate[] coordinates = new Coordinate[numPoints];
        if (allMNoData) {
            for (int i = 0; i < numPoints; ++i) {
                coordinates[i] = new Coordinate(x[i], y[i]);
            }
        } else {
            for (int i = 0; i < numPoints; ++i) {
                coordinates[i] = new CoordinateXYM(x[i], y[i], m3[i]);
            }
        }
        return coordinates;
    }

    protected int[] readOffsets(ShapeReader reader, int numParts, int maxOffset) {
        int[] offsets = new int[numParts + 1];
        for (int i = 0; i < numParts; ++i) {
            offsets[i] = reader.readInt();
        }
        offsets[numParts] = maxOffset;
        return offsets;
    }
}

