/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.sun.media.jai.rmi.ColorModelState;
import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.range.NoDataContainer;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.RemoteImage;
import javax.media.jai.TileCache;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;
import org.apache.sedona.common.raster.serde.AWTRasterSerializer;
import org.apache.sedona.common.raster.serde.KryoUtil;
import org.apache.sedona.common.utils.RasterUtils;

public final class DeepCopiedRenderedImage
implements RenderedImage,
Serializable,
KryoSerializable {
    private transient RenderedImage source;
    private int minX;
    private int minY;
    private int width;
    private int height;
    private int minTileX;
    private int minTileY;
    private int numXTiles;
    private int numYTiles;
    private int tileWidth;
    private int tileHeight;
    private int tileGridXOffset;
    private int tileGridYOffset;
    private transient SampleModel sampleModel = null;
    private transient ColorModel colorModel = null;
    private transient Vector<RenderedImage> sources = null;
    private transient Hashtable<String, Object> properties = null;
    private Rectangle imageBounds;
    private transient Raster imageRaster;
    private static final AWTRasterSerializer awtRasterSerializer = new AWTRasterSerializer();

    public DeepCopiedRenderedImage() {
    }

    public DeepCopiedRenderedImage(RenderedImage source) {
        this(source, true);
    }

    private DeepCopiedRenderedImage(RenderedImage source, boolean checkDataBuffer) {
        DataBuffer db;
        Raster ras;
        if (source == null) {
            throw new IllegalArgumentException("source cannot be null");
        }
        SampleModel sm = source.getSampleModel();
        if (sm != null && SerializerFactory.getSerializer(sm.getClass()) == null) {
            throw new IllegalArgumentException("sample model object is not serializable");
        }
        ColorModel cm = source.getColorModel();
        if (cm != null && SerializerFactory.getSerializer(cm.getClass()) == null) {
            throw new IllegalArgumentException("color model object is not serializable");
        }
        if (checkDataBuffer && (ras = source.getTile(source.getMinTileX(), source.getMinTileY())) != null && (db = ras.getDataBuffer()) != null && SerializerFactory.getSerializer(db.getClass()) == null) {
            throw new IllegalArgumentException("data buffer object is not serializable");
        }
        this.source = source;
        if (source instanceof RemoteImage) {
            throw new IllegalArgumentException("RemoteImage is not supported");
        }
        this.minX = source.getMinX();
        this.minY = source.getMinY();
        this.width = source.getWidth();
        this.height = source.getHeight();
        this.minTileX = source.getMinTileX();
        this.minTileY = source.getMinTileY();
        this.numXTiles = source.getNumXTiles();
        this.numYTiles = source.getNumYTiles();
        this.tileWidth = source.getTileWidth();
        this.tileHeight = source.getTileHeight();
        this.tileGridXOffset = source.getTileGridXOffset();
        this.tileGridYOffset = source.getTileGridYOffset();
        this.sampleModel = source.getSampleModel();
        this.colorModel = source.getColorModel();
        this.sources = new Vector();
        this.sources.add(source);
        this.properties = new Hashtable();
        String[] propertyNames = source.getPropertyNames();
        if (propertyNames != null) {
            for (String propertyName : propertyNames) {
                this.properties.put(propertyName, source.getProperty(propertyName));
            }
        }
        this.imageBounds = new Rectangle(this.minX, this.minY, this.width, this.height);
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public Raster getData() {
        if (this.source == null) {
            return this.getData(this.imageBounds);
        }
        return this.source.getData();
    }

    @Override
    public Raster getData(Rectangle rect) {
        if (this.source == null) {
            return this.imageRaster.createChild(rect.x, rect.y, rect.width, rect.height, rect.x, rect.y, null);
        }
        return this.source.getData(rect);
    }

    @Override
    public WritableRaster copyData(WritableRaster dest) {
        if (this.source == null) {
            Rectangle region;
            if (dest == null) {
                region = this.imageBounds;
                SampleModel destSM = this.getSampleModel().createCompatibleSampleModel(region.width, region.height);
                dest = Raster.createWritableRaster(destSM, new Point(region.x, region.y));
            } else {
                region = dest.getBounds().intersection(this.imageBounds);
            }
            if (!region.isEmpty()) {
                int startTileX = PlanarImage.XToTileX((int)region.x, (int)this.tileGridXOffset, (int)this.tileWidth);
                int startTileY = PlanarImage.YToTileY((int)region.y, (int)this.tileGridYOffset, (int)this.tileHeight);
                int endTileX = PlanarImage.XToTileX((int)(region.x + region.width - 1), (int)this.tileGridXOffset, (int)this.tileWidth);
                int endTileY = PlanarImage.YToTileY((int)(region.y + region.height - 1), (int)this.tileGridYOffset, (int)this.tileHeight);
                SampleModel[] sampleModels = new SampleModel[]{this.getSampleModel()};
                int tagID = RasterAccessor.findCompatibleTag((SampleModel[])sampleModels, (SampleModel)dest.getSampleModel());
                RasterFormatTag srcTag = new RasterFormatTag(this.getSampleModel(), tagID);
                RasterFormatTag dstTag = new RasterFormatTag(dest.getSampleModel(), tagID);
                for (int ty = startTileY; ty <= endTileY; ++ty) {
                    for (int tx = startTileX; tx <= endTileX; ++tx) {
                        Raster tile = this.getTile(tx, ty);
                        Rectangle subRegion = region.intersection(tile.getBounds());
                        RasterAccessor s2 = new RasterAccessor(tile, subRegion, srcTag, this.getColorModel());
                        RasterAccessor d = new RasterAccessor((Raster)dest, subRegion, dstTag, null);
                        ImageUtil.copyRaster((RasterAccessor)s2, (RasterAccessor)d);
                    }
                }
            }
            return dest;
        }
        return this.source.copyData(dest);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getMinTileX() {
        return this.minTileX;
    }

    @Override
    public int getMinTileY() {
        return this.minTileY;
    }

    @Override
    public int getMinX() {
        return this.minX;
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    @Override
    public int getNumXTiles() {
        return this.numXTiles;
    }

    @Override
    public int getNumYTiles() {
        return this.numYTiles;
    }

    @Override
    public Object getProperty(String name) {
        Object property = this.properties.get(name);
        return property == null ? Image.UndefinedProperty : property;
    }

    @Override
    public String[] getPropertyNames() {
        String[] names = null;
        if (!this.properties.isEmpty()) {
            names = new String[this.properties.size()];
            Enumeration<String> keys = this.properties.keys();
            int index = 0;
            while (keys.hasMoreElements()) {
                names[index++] = keys.nextElement();
            }
        }
        return names;
    }

    @Override
    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    @Override
    public Vector<RenderedImage> getSources() {
        return this.sources;
    }

    @Override
    public Raster getTile(int tileX, int tileY) {
        if (this.source == null) {
            Raster tile;
            TileCache cache = JAI.getDefaultInstance().getTileCache();
            if (cache != null && (tile = cache.getTile((RenderedImage)this, tileX, tileY)) != null) {
                return tile;
            }
            Rectangle imageBounds = new Rectangle(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
            Rectangle destRect = imageBounds.intersection(new Rectangle(this.tileXToX(tileX), this.tileYToY(tileY), this.getTileWidth(), this.getTileHeight()));
            Raster tile2 = this.getData(destRect);
            if (cache != null) {
                cache.add((RenderedImage)this, tileX, tileY, tile2);
            }
            return tile2;
        }
        return this.source.getTile(tileX, tileY);
    }

    private int tileXToX(int tx) {
        return PlanarImage.tileXToX((int)tx, (int)this.getTileGridXOffset(), (int)this.getTileWidth());
    }

    private int tileYToY(int ty) {
        return PlanarImage.tileYToY((int)ty, (int)this.getTileGridYOffset(), (int)this.getTileHeight());
    }

    @Override
    public int getTileGridXOffset() {
        return this.tileGridXOffset;
    }

    @Override
    public int getTileGridYOffset() {
        return this.tileGridYOffset;
    }

    @Override
    public int getTileHeight() {
        return this.tileHeight;
    }

    @Override
    public int getTileWidth() {
        return this.tileWidth;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        Hashtable<String, Object> propertyTable = this.getSerializableProperties();
        out.writeObject(SerializerFactory.getState((Object)this.colorModel, null));
        out.writeObject(propertyTable);
        if (this.source != null) {
            Raster serializedRaster = RasterUtils.getRaster(this.source);
            out.writeObject(SerializerFactory.getState((Object)serializedRaster, null));
        } else {
            out.writeObject(SerializerFactory.getState((Object)this.imageRaster, null));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.source = null;
        in.defaultReadObject();
        SerializableState cmState = (SerializableState)in.readObject();
        this.colorModel = (ColorModel)cmState.getObject();
        this.properties = (Hashtable)in.readObject();
        for (String key : this.properties.keySet()) {
            Object value = this.properties.get(key);
            if (!(value instanceof SingleValueNoDataContainer)) continue;
            SingleValueNoDataContainer noDataContainer = (SingleValueNoDataContainer)value;
            this.properties.put(key, new NoDataContainer(noDataContainer.singleValue));
        }
        SerializableState rasState = (SerializableState)in.readObject();
        this.imageRaster = (Raster)rasState.getObject();
        this.sampleModel = this.imageRaster.getSampleModel();
        this.tileWidth = this.width;
        this.tileHeight = this.height;
        this.numXTiles = 1;
        this.numYTiles = 1;
        this.minTileX = 0;
        this.minTileY = 0;
        this.tileGridXOffset = this.minX;
        this.tileGridYOffset = this.minY;
    }

    private Hashtable<String, Object> getSerializableProperties() {
        Hashtable propertyTable = this.properties;
        boolean propertiesCloned = false;
        Enumeration<String> keys = propertyTable.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object value = this.properties.get(key);
            if (value instanceof Serializable) continue;
            if (!propertiesCloned) {
                propertyTable = (Hashtable)this.properties.clone();
                propertiesCloned = true;
            }
            if (value instanceof NoDataContainer) {
                NoDataContainer noDataContainer = (NoDataContainer)value;
                propertyTable.put(key, new SingleValueNoDataContainer(noDataContainer.getAsSingleValue()));
                continue;
            }
            propertyTable.remove(key);
        }
        return propertyTable;
    }

    public static void registerKryo(Kryo kryo) {
        kryo.register(ColorModelState.class, (Serializer)new JavaSerializer());
    }

    public void write(Kryo kryo, Output output) {
        output.writeInt(this.minX);
        output.writeInt(this.minY);
        output.writeInt(this.width);
        output.writeInt(this.height);
        Hashtable<String, Object> propertyTable = this.getSerializableProperties();
        KryoUtil.writeObjectWithLength(kryo, output, propertyTable);
        SerializableState colorModelState = SerializerFactory.getState((Object)this.colorModel, null);
        KryoUtil.writeObjectWithLength(kryo, output, colorModelState);
        Raster serializedRaster = this.source != null ? RasterUtils.getRaster(this.source) : this.imageRaster;
        awtRasterSerializer.write(kryo, output, serializedRaster);
    }

    public void read(Kryo kryo, Input input) {
        this.minX = input.readInt();
        this.minY = input.readInt();
        this.width = input.readInt();
        this.height = input.readInt();
        this.imageBounds = new Rectangle(this.minX, this.minY, this.width, this.height);
        input.readInt();
        this.properties = (Hashtable)kryo.readObject(input, Hashtable.class);
        for (String key : this.properties.keySet()) {
            Object value = this.properties.get(key);
            if (!(value instanceof SingleValueNoDataContainer)) continue;
            SingleValueNoDataContainer noDataContainer = (SingleValueNoDataContainer)value;
            this.properties.put(key, new NoDataContainer(noDataContainer.singleValue));
        }
        input.readInt();
        ColorModelState cmState = (ColorModelState)kryo.readObject(input, ColorModelState.class);
        this.colorModel = (ColorModel)cmState.getObject();
        this.imageRaster = awtRasterSerializer.read(kryo, input, (Class)Raster.class);
        this.sampleModel = this.imageRaster.getSampleModel();
        this.tileWidth = this.width;
        this.tileHeight = this.height;
        this.numXTiles = 1;
        this.numYTiles = 1;
        this.minTileX = 0;
        this.minTileY = 0;
        this.tileGridXOffset = this.minX;
        this.tileGridYOffset = this.minY;
    }

    private static class SingleValueNoDataContainer
    implements Serializable {
        private final double singleValue;

        SingleValueNoDataContainer(double value) {
            this.singleValue = value;
        }
    }
}

