/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.datasources.osmpbf.iterators;

import java.io.IOException;
import java.util.Iterator;
import java.util.zip.DataFormatException;
import org.apache.sedona.sql.datasources.osmpbf.DenseNodeIterator;
import org.apache.sedona.sql.datasources.osmpbf.ParseUtils;
import org.apache.sedona.sql.datasources.osmpbf.build.Fileformat;
import org.apache.sedona.sql.datasources.osmpbf.build.Osmformat;
import org.apache.sedona.sql.datasources.osmpbf.extractors.DenseNodeExtractor;
import org.apache.sedona.sql.datasources.osmpbf.extractors.RelationExtractor;
import org.apache.sedona.sql.datasources.osmpbf.extractors.WaysExtractor;
import org.apache.sedona.sql.datasources.osmpbf.model.OSMEntity;
import org.apache.sedona.sql.datasources.osmpbf.model.OsmNode;

public class BlobIterator
implements Iterator<OSMEntity> {
    Fileformat.Blob blob;
    Osmformat.PrimitiveBlock primitiveBlock;
    int primitiveGroupIdx;
    int osmEntityIdx;
    DenseNodeIterator denseNodesIterator;
    Osmformat.PrimitiveGroup currentPrimitiveGroup;

    public BlobIterator(Fileformat.Blob blob) throws DataFormatException, IOException {
        this.primitiveBlock = Osmformat.PrimitiveBlock.parseFrom(ParseUtils.dataInputStreamBlob(blob));
        this.primitiveGroupIdx = 0;
        this.osmEntityIdx = 0;
        this.currentPrimitiveGroup = this.primitiveBlock.getPrimitivegroup(this.primitiveGroupIdx);
        this.blob = blob;
    }

    @Override
    public boolean hasNext() {
        return this.primitiveBlock.getPrimitivegroupList().size() != this.primitiveGroupIdx;
    }

    @Override
    public OSMEntity next() {
        if (this.currentPrimitiveGroup == null) {
            return null;
        }
        if (!this.currentPrimitiveGroup.getRelationsList().isEmpty()) {
            return this.extractRelationPrimitiveGroup();
        }
        if (!this.currentPrimitiveGroup.getNodesList().isEmpty()) {
            return null;
        }
        if (!this.currentPrimitiveGroup.getWaysList().isEmpty()) {
            return this.extractWayPrimitiveGroup();
        }
        if (!this.currentPrimitiveGroup.getChangesetsList().isEmpty()) {
            return null;
        }
        if (this.currentPrimitiveGroup.getDense() != null) {
            return this.extractDenseNodePrimitiveGroup();
        }
        return null;
    }

    public OSMEntity extractDenseNodePrimitiveGroup() {
        if (this.denseNodesIterator == null) {
            this.denseNodesIterator = new DenseNodeIterator(this.currentPrimitiveGroup.getDense().getIdCount(), this.primitiveBlock.getStringtable(), new DenseNodeExtractor(this.currentPrimitiveGroup.getDense(), this.primitiveBlock.getLatOffset(), this.primitiveBlock.getLonOffset(), this.primitiveBlock.getGranularity()));
        }
        OsmNode node = this.denseNodesIterator.next();
        if (!this.denseNodesIterator.hasNext()) {
            this.denseNodesIterator = null;
            this.nextEntity();
        }
        return node;
    }

    public OSMEntity extractWayPrimitiveGroup() {
        ++this.osmEntityIdx;
        if (this.currentPrimitiveGroup.getWaysList().size() == this.osmEntityIdx) {
            this.nextEntity();
        }
        return new WaysExtractor(this.currentPrimitiveGroup, this.primitiveBlock.getStringtable()).extract(this.osmEntityIdx);
    }

    public OSMEntity extractRelationPrimitiveGroup() {
        ++this.osmEntityIdx;
        if (this.currentPrimitiveGroup.getRelationsList().size() == this.osmEntityIdx) {
            this.nextEntity();
        }
        Osmformat.StringTable stringTable = this.primitiveBlock.getStringtable();
        return new RelationExtractor(this.currentPrimitiveGroup, stringTable).extract(this.osmEntityIdx);
    }

    public void nextEntity() {
        ++this.primitiveGroupIdx;
        this.osmEntityIdx = 0;
    }
}

