/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.LatLonRect;

public class CollectionInfo {
    public LatLonRect bbox;
    private CalendarDateRange dateRange;
    public double minTime = Double.MAX_VALUE;
    public double maxTime = -1.7976931348623157E308;
    public int nobs;
    public int nfeatures;
    private boolean complete;

    public CollectionInfo() {
    }

    public CollectionInfo(LatLonRect bbox, CalendarDateRange dateRange, int nfeatures, int nobs) {
        this.bbox = bbox;
        this.dateRange = dateRange;
        this.nfeatures = nfeatures;
        this.nobs = nobs;
    }

    public void extend(CollectionInfo info) {
        if (info.nobs == 0) {
            return;
        }
        this.nobs += info.nobs;
        ++this.nfeatures;
        if (this.bbox == null) {
            this.bbox = info.bbox;
        } else if (info.bbox != null) {
            this.bbox.extend(info.bbox);
        }
        this.minTime = Math.min(this.minTime, info.minTime);
        this.maxTime = Math.max(this.maxTime, info.maxTime);
    }

    public CalendarDateRange getCalendarDateRange(CalendarDateUnit timeUnit) {
        if (this.nobs == 0) {
            return null;
        }
        if (this.dateRange != null) {
            return this.dateRange;
        }
        if (timeUnit != null && this.minTime <= this.maxTime) {
            this.dateRange = CalendarDateRange.of(timeUnit.makeCalendarDate(this.minTime), timeUnit.makeCalendarDate(this.maxTime));
        }
        return this.dateRange;
    }

    public void setCalendarDateRange(CalendarDateRange dateRange) {
        this.dateRange = dateRange;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete() {
        if (this.nobs > 0) {
            this.complete = true;
        }
    }

    public String toString() {
        return "CollectionInfo{bbox=" + this.bbox + ", dateRange=" + this.getCalendarDateRange(null) + ", nfeatures=" + this.nfeatures + ", nobs=" + this.nobs + ", complete=" + this.complete + '}';
    }
}

