/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.knnJudgement;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.strtree.GeometryItemDistance;
import org.locationtech.jts.index.strtree.STRtree;

public class KnnJudgementUsingIndex<U extends Geometry, T extends Geometry>
implements FlatMapFunction<Iterator<SpatialIndex>, T>,
Serializable {
    int k;
    U queryCenter;

    public KnnJudgementUsingIndex(U queryCenter, int k) {
        this.queryCenter = queryCenter;
        this.k = k;
    }

    public Iterator<T> call(Iterator<SpatialIndex> treeIndexes) throws Exception {
        SpatialIndex treeIndex = treeIndexes.next();
        if (!(treeIndex instanceof STRtree)) {
            throw new Exception("[KnnJudgementUsingIndex][Call] QuadTree index doesn't support KNN search.");
        }
        Object[] localK = ((STRtree)treeIndex).nearestNeighbour(((Geometry)this.queryCenter).getEnvelopeInternal(), this.queryCenter, new GeometryItemDistance(), this.k);
        ArrayList<Geometry> result = new ArrayList<Geometry>();
        for (int i = 0; i < localK.length; ++i) {
            result.add((Geometry)localK[i]);
        }
        return result.iterator();
    }
}

