/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.filesystem.MFileOS;
import thredds.inventory.MFile;
import thredds.inventory.MFileProvider;
import ucar.nc2.internal.ncml.NcmlReader;

public class MFiles {
    private static final Logger logger = LoggerFactory.getLogger(NcmlReader.class);

    @Nullable
    public static MFile create(String location) {
        MFileProvider mFileProvider = null;
        for (MFileProvider provider : ServiceLoader.load(MFileProvider.class)) {
            if (!provider.canProvide(location)) continue;
            mFileProvider = provider;
            break;
        }
        MFile mfile = null;
        try {
            mfile = mFileProvider != null ? mFileProvider.create(location) : MFileOS.getExistingFile(location);
        }
        catch (IOException ioe) {
            logger.error("Error creating MFile at {}.", (Object)location, (Object)ioe);
        }
        return mfile;
    }
}

