/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v16;

import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhTreeHelper;
import ch.ethz.globis.phtree.util.PhTreeStats;
import ch.ethz.globis.phtree.util.StringBuilderLn;
import ch.ethz.globis.phtree.util.unsynced.LongArrayOps;
import ch.ethz.globis.phtree.v16.PhTree16;
import ch.ethz.globis.phtree.v16.bst.BSTIteratorAll;
import ch.ethz.globis.phtree.v16.bst.BSTreePage;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;

public class Node {
    private byte maxLeafN;
    private byte maxInnerN;
    private int entryCnt = 0;
    private byte postLenStored = 0;
    private byte infixLenStored = 0;
    private BSTreePage root;
    private static int N_GOOD = 0;
    private static int N = 0;
    public static int statNLeaves = 0;
    public static int statNInner = 0;

    Node() {
    }

    private void initNode(int infixLenClassic, int postLenClassic, int dims, PhTree16<?> tree) {
        this.infixLenStored = (byte)(infixLenClassic + 1);
        this.postLenStored = (byte)(postLenClassic + 1);
        this.entryCnt = 0;
        switch (dims) {
            case 1: {
                this.maxLeafN = (byte)2;
                this.maxInnerN = (byte)3;
                break;
            }
            case 2: {
                this.maxLeafN = (byte)4;
                this.maxInnerN = (byte)3;
                break;
            }
            case 3: {
                this.maxLeafN = (byte)8;
                this.maxInnerN = (byte)3;
                break;
            }
            case 4: {
                this.maxLeafN = (byte)16;
                this.maxInnerN = (byte)3;
                break;
            }
            case 5: {
                this.maxLeafN = (byte)16;
                this.maxInnerN = (byte)5;
                break;
            }
            case 6: {
                this.maxLeafN = (byte)16;
                this.maxInnerN = (byte)7;
                break;
            }
            case 7: {
                this.maxLeafN = (byte)16;
                this.maxInnerN = (byte)11;
                break;
            }
            case 8: {
                this.maxLeafN = (byte)16;
                this.maxInnerN = (byte)21;
                break;
            }
            case 9: {
                this.maxLeafN = (byte)32;
                this.maxInnerN = (byte)21;
                break;
            }
            case 10: {
                this.maxLeafN = (byte)32;
                this.maxInnerN = (byte)36;
                break;
            }
            case 11: {
                this.maxLeafN = (byte)32;
                this.maxInnerN = (byte)71;
                break;
            }
            case 12: {
                this.maxLeafN = (byte)64;
                this.maxInnerN = (byte)71;
                break;
            }
            default: {
                this.maxLeafN = (byte)100;
                this.maxInnerN = (byte)100;
            }
        }
        this.root = this.bstCreateRoot(tree);
    }

    public static Node createNode(int dims, int infixLenClassic, int postLenClassic, PhTree16<?> tree) {
        Node n = tree.nodePool().get();
        n.initNode(infixLenClassic, postLenClassic, dims, tree);
        return n;
    }

    private void discardNode(PhTree16<?> tree) {
        this.entryCnt = 0;
        this.getRoot().clear();
        tree.bstPool().reportFreeNode(this.root);
        this.root = null;
        tree.nodePool().offer(this);
    }

    Object doInsertIfMatching(long[] keyToMatch, Object newValueToInsert, PhTree16<?> tree) {
        long hcPos = PhTreeHelper.posInArray(keyToMatch, this.getPostLen());
        Object v = this.addEntry(hcPos, keyToMatch, newValueToInsert, tree);
        if (v == null) {
            tree.increaseNrEntries();
        }
        return v;
    }

    Object doIfMatching(long[] keyToMatch, boolean getOnly, Node parent, PhTree16.UpdateInfo insertRequired, PhTree16<?> tree) {
        long hcPos = PhTreeHelper.posInArray(keyToMatch, this.getPostLen());
        if (getOnly) {
            BSTEntry e = this.getEntry(hcPos, keyToMatch);
            return e != null ? e.getValue() : null;
        }
        Object v = this.removeEntry(hcPos, keyToMatch, insertRequired, tree);
        if (v != null && !(v instanceof Node)) {
            tree.decreaseNrEntries();
            if (this.getEntryCount() == 1) {
                this.mergeIntoParentNt(keyToMatch, parent, tree);
            }
        }
        return v;
    }

    private long calcInfixMask(int subPostLen) {
        return -1L << subPostLen + 1;
    }

    public Node createNode(long[] key1, Object val1, long[] key2, Object val2, int mcb, PhTree16<?> tree) {
        int newLocalInfLen = this.getPostLen() - mcb;
        int newPostLen = mcb - 1;
        Node newNode = Node.createNode(key1.length, newLocalInfLen, newPostLen, tree);
        long posSub1 = PhTreeHelper.posInArray(key1, newPostLen);
        long posSub2 = PhTreeHelper.posInArray(key2, newPostLen);
        BSTEntry e1 = newNode.createEntry(posSub1, key1, val1, tree);
        BSTEntry e2 = newNode.createEntry(posSub2, key2, val2, tree);
        if (posSub1 < posSub2) {
            newNode.root.init(e1, e2);
        } else {
            newNode.root.init(e2, e1);
        }
        newNode.entryCnt = 2;
        return newNode;
    }

    private BSTEntry createEntry(long hcPos, long[] newKey, Object value, PhTree16<?> tree) {
        if (value instanceof Node) {
            Node node = (Node)value;
            int newSubInfixLen = this.postLenStored() - node.postLenStored() - 1;
            node.setInfixLen(newSubInfixLen);
        }
        BSTEntry e = tree.bstPool().getEntry();
        e.set(hcPos, newKey, value);
        return e;
    }

    private static int calcConflictingBits(long[] v1, long[] v2, long mask) {
        long diff = 0L;
        for (int i = 0; i < v1.length; ++i) {
            diff |= v1[i] ^ v2[i];
        }
        return 64 - Long.numberOfLeadingZeros(diff & mask);
    }

    public static int calcConflictingBits(long[] v1, long[] v2) {
        long diff = 0L;
        for (int i = 0; i < v1.length; ++i) {
            diff |= v1[i] ^ v2[i];
        }
        return 64 - Long.numberOfLeadingZeros(diff);
    }

    private void mergeIntoParentNt(long[] key, Node parent, PhTree16<?> tree) {
        if (parent == null || this.getEntryCount() > 2) {
            return;
        }
        BSTEntry nte = this.root.getFirstValue();
        long posInParent = PhTreeHelper.posInArray(key, parent.getPostLen());
        if (nte.getValue() instanceof Node) {
            long[] newPost = nte.getKdKey();
            Node sub2 = (Node)nte.getValue();
            int newInfixLen = this.getInfixLen() + 1 + sub2.getInfixLen();
            sub2.setInfixLen(newInfixLen);
            parent.replaceEntry(posInParent, newPost, sub2);
        } else {
            parent.replaceEntry(posInParent, nte.getKdKey(), nte.getValue());
        }
        this.discardNode(tree);
    }

    private boolean checkInfix(int infixLen, long[] keyToTest, long[] rangeMin, long[] rangeMax) {
        if (infixLen == 0) {
            return true;
        }
        long compMask = Node.mask1100(this.postLenStored() - infixLen);
        for (int dim = 0; dim < keyToTest.length; ++dim) {
            long in = keyToTest[dim] & compMask;
            if (in <= rangeMax[dim] && in >= (rangeMin[dim] & compMask)) continue;
            return false;
        }
        return true;
    }

    private static long mask1100(int zeroBits) {
        return zeroBits == 64 ? 0L : -1L << zeroBits;
    }

    <T> boolean checkAndGetEntry(BSTEntry candidate, PhEntry<T> result, long[] rangeMin, long[] rangeMax) {
        Object value = candidate.getValue();
        if (value instanceof Node) {
            Node sub = (Node)value;
            if (!this.checkInfix(sub.getInfixLen(), candidate.getKdKey(), rangeMin, rangeMax)) {
                return false;
            }
            result.setKeyInternal(candidate.getKdKey());
            result.setNodeInternal(sub);
            return true;
        }
        if (LongArrayOps.checkRange(candidate.getKdKey(), rangeMin, rangeMax)) {
            result.setKeyInternal(candidate.getKdKey());
            result.setValueInternal(value);
            return true;
        }
        return false;
    }

    public int getEntryCount() {
        return this.entryCnt;
    }

    public void decEntryCount() {
        --this.entryCnt;
    }

    public void decEntryCountGlobal(PhTree16<?> tree) {
        --this.entryCnt;
        tree.decreaseNrEntries();
    }

    public void incEntryCount() {
        ++this.entryCnt;
    }

    public static void incEntryCountTree(PhTree16<?> tree) {
        tree.increaseNrEntries();
    }

    public int getInfixLen() {
        return this.infixLenStored() - 1;
    }

    private int infixLenStored() {
        return this.infixLenStored;
    }

    void setInfixLen(int newInfLen) {
        this.infixLenStored = (byte)(newInfLen + 1);
    }

    public int getPostLen() {
        return this.postLenStored - 1;
    }

    int postLenStored() {
        return this.postLenStored;
    }

    private BSTreePage bstCreateRoot(PhTree16<?> tree) {
        return this.bstCreatePage(null, true, null, tree);
    }

    public final BSTEntry bstGetOrCreate(long key, PhTree16<?> tree) {
        BSTreePage page = this.getRoot();
        if (page.isLeaf()) {
            BSTEntry e = page.getOrCreate(key, null, -1, this);
            if (e.getKdKey() == null && e.getValue() instanceof BSTreePage) {
                BSTreePage newPage = (BSTreePage)e.getValue();
                this.root = BSTreePage.create(this, null, page, newPage, tree);
                e.setValue(null);
            }
            return e;
        }
        Object o = page;
        while (o instanceof BSTreePage && !((BSTreePage)o).isLeaf()) {
            o = ((BSTreePage)o).getOrCreate(key, this);
        }
        return (BSTEntry)o;
    }

    public final void bstSetRoot(BSTreePage newRoot) {
        this.root = newRoot;
    }

    public BSTEntry bstRemove(long key, long[] kdKey, PhTree16.UpdateInfo ui, PhTree16<?> tree) {
        BSTreePage rootPage = this.getRoot();
        if (rootPage.isLeaf()) {
            return rootPage.remove(key, kdKey, this, ui);
        }
        BSTEntry result = rootPage.findAndRemove(key, kdKey, this, ui);
        if (rootPage.getNKeys() == 0) {
            this.root = rootPage.getFirstSubPage();
            this.root.setParent(null);
            tree.bstPool().reportFreeNode(rootPage);
        }
        return result;
    }

    public <T> Object bstCompute(long key, long[] kdKey, PhTree16<?> tree, boolean doIfAbsent, BiFunction<long[], ? super T, ? extends T> mappingFunction) {
        BSTreePage page = this.getRoot();
        int pos = -1;
        while (!page.isLeaf()) {
            pos = page.binarySearchInnerNode(key);
            page = page.getSubPages()[pos];
        }
        Object result = page.computeLeaf(key, kdKey, pos, this, doIfAbsent, mappingFunction);
        BSTreePage rootPage = this.getRoot();
        if (!rootPage.isLeaf() && rootPage.getNKeys() == 0) {
            this.root = rootPage.getFirstSubPage();
            this.root.setParent(null);
            tree.bstPool().reportFreeNode(rootPage);
        }
        return result;
    }

    public BSTEntry bstGet(long key) {
        BSTreePage page;
        for (page = this.getRoot(); page != null && !page.isLeaf(); page = page.findSubPage(key)) {
        }
        if (page == null) {
            return null;
        }
        return page.getValueFromLeaf(key);
    }

    public BSTreePage bstCreatePage(BSTreePage parent, boolean isLeaf, BSTreePage leftPredecessor, PhTree16<?> tree) {
        return BSTreePage.create(this, parent, isLeaf, leftPredecessor, tree);
    }

    public BSTreePage getRoot() {
        return this.root;
    }

    public void bstUpdateRoot(BSTreePage newRoot) {
        this.root = newRoot;
    }

    public String toStringTree() {
        StringBuilderLn sb = new StringBuilderLn();
        if (this.root != null) {
            this.root.toStringTree(sb, "");
        }
        return sb.toString();
    }

    public BSTIteratorAll iterator() {
        return new BSTIteratorAll().reset(this.getRoot());
    }

    public BSTStats getStats() {
        BSTStats stats = new BSTStats();
        if (this.root != null) {
            this.root.getStats(stats);
        }
        return stats;
    }

    public int maxLeafN() {
        return this.maxLeafN;
    }

    public int maxInnerN() {
        return this.maxInnerN;
    }

    Object addEntry(long hcPos, long[] kdKey, Object value, PhTree16<?> tree) {
        BSTEntry be = this.bstGetOrCreate(hcPos, tree);
        if (be.getKdKey() == null) {
            be.set(hcPos, kdKey, value);
            return null;
        }
        return this.handleCollision(be, kdKey, value, tree);
    }

    private Object handleCollision(BSTEntry existingE, long[] kdKey, Object value, PhTree16<?> tree) {
        Object localVal = existingE.getValue();
        if (localVal instanceof Node) {
            Node subNode = (Node)localVal;
            if (subNode.getInfixLen() > 0) {
                long mask = this.calcInfixMask(subNode.getPostLen());
                return this.insertSplit(existingE, kdKey, value, mask, tree);
            }
            return localVal;
        }
        if (this.getPostLen() > 0) {
            return this.insertSplit(existingE, kdKey, value, -1L, tree);
        }
        existingE.set(existingE.getKey(), kdKey, value);
        return localVal;
    }

    private Object insertSplit(BSTEntry currentEntry, long[] newKey, Object newValue, long mask, PhTree16<?> tree) {
        if (mask == 0L) {
            return currentEntry.getValue();
        }
        long[] localKdKey = currentEntry.getKdKey();
        Object currentValue = currentEntry.getValue();
        int maxConflictingBits = Node.calcConflictingBits(newKey, localKdKey, mask);
        if (maxConflictingBits == 0) {
            if (!(currentValue instanceof Node)) {
                currentEntry.set(currentEntry.getKey(), newKey, newValue);
            }
            return currentValue;
        }
        Node newNode = this.createNode(newKey, newValue, localKdKey, currentValue, maxConflictingBits, tree);
        currentEntry.set(currentEntry.getKey(), tree.longPool().arrayClone(localKdKey), newNode);
        return null;
    }

    private void replaceEntry(long hcPos, long[] kdKey, Object value) {
        BSTEntry be = this.bstGet(hcPos);
        be.set(hcPos, kdKey, value);
    }

    Object removeEntry(long hcPos, long[] keyToMatch, Node parent, PhTree16<?> tree) {
        Object v = this.removeEntry(hcPos, keyToMatch, (PhTree16.UpdateInfo)null, tree);
        if (v != null && !(v instanceof Node)) {
            tree.decreaseNrEntries();
            if (this.getEntryCount() == 1) {
                this.mergeIntoParentNt(keyToMatch, parent, tree);
            }
        }
        return v;
    }

    <T> Object computeEntry(long hcPos, long[] keyToMatch, Node parent, PhTree16<?> tree, boolean doIfAbsent, BiFunction<long[], ? super T, ? extends T> mappingFunction) {
        Object v = this.bstCompute(hcPos, keyToMatch, tree, doIfAbsent, mappingFunction);
        if (this.getEntryCount() == 1) {
            this.mergeIntoParentNt(keyToMatch, parent, tree);
        }
        return v;
    }

    private Object removeEntry(long hcPos, long[] key, PhTree16.UpdateInfo ui, PhTree16<?> tree) {
        BSTEntry prev = this.bstRemove(hcPos, key, ui, tree);
        return prev == null ? null : prev.getValue();
    }

    public REMOVE_OP bstInternalRemoveCallback(BSTEntry currentEntry, long[] key, PhTree16.UpdateInfo ui) {
        if (this.matches(currentEntry, key)) {
            if (currentEntry.getValue() instanceof Node) {
                return REMOVE_OP.KEEP_RETURN;
            }
            if (ui != null) {
                int bitPosOfDiff = Node.calcConflictingBits(key, ui.newKey, -1L);
                if (bitPosOfDiff <= this.getPostLen()) {
                    currentEntry.set(currentEntry.getKey(), ui.newKey, currentEntry.getValue());
                    return REMOVE_OP.KEEP_RETURN;
                }
                ui.insertRequired = bitPosOfDiff;
            }
            return REMOVE_OP.REMOVE_RETURN;
        }
        return REMOVE_OP.KEEP_RETURN_NULL;
    }

    BSTEntry getEntry(long hcPos, long[] keyToMatch) {
        BSTEntry be = this.bstGet(hcPos);
        if (be == null) {
            return null;
        }
        if (keyToMatch != null && !this.matches(be, keyToMatch)) {
            return null;
        }
        return be;
    }

    public boolean matches(BSTEntry be, long[] keyToMatch) {
        if (be.getValue() instanceof Node) {
            Node sub = (Node)be.getValue();
            if (sub.getInfixLen() > 0) {
                long mask = this.calcInfixMask(sub.getPostLen());
                return Node.checkKdKey(be.getKdKey(), keyToMatch, mask);
            }
            return true;
        }
        return Node.checkKdKey(be.getKdKey(), keyToMatch);
    }

    private static boolean checkKdKey(long[] allKeys, long[] keyToMatch, long mask) {
        for (int i = 0; i < keyToMatch.length; ++i) {
            if (((allKeys[i] ^ keyToMatch[i]) & mask) == 0L) continue;
            return false;
        }
        return true;
    }

    private static boolean checkKdKey(long[] allKeys, long[] keyToMatch) {
        for (int i = 0; i < keyToMatch.length; ++i) {
            if ((allKeys[i] ^ keyToMatch[i]) == 0L) continue;
            return false;
        }
        return true;
    }

    void getStats(PhTreeStats stats, List<BSTEntry> entries) {
        BSTIteratorAll iter = this.iterator();
        while (iter.hasNextEntry()) {
            entries.add(iter.nextEntry());
        }
        BSTStats bstStats = this.getStats();
        stats.nAHC += bstStats.nNodesInner;
        stats.nNT += bstStats.nNodesLeaf;
        stats.nNtNodes += bstStats.capacityLeaf;
    }

    public static class BSTEntry {
        private long key;
        private long[] kdKey;
        private Object value;

        public BSTEntry(long key, long[] k, Object v) {
            this.key = key;
            this.kdKey = k;
            this.value = v;
        }

        public BSTEntry() {
        }

        public long getKey() {
            return this.key;
        }

        public long[] getKdKey() {
            return this.kdKey;
        }

        public Object getValue() {
            return this.value;
        }

        public void set(long key, long[] kdKey, Object value) {
            this.key = key;
            this.kdKey = kdKey;
            this.value = value;
        }

        public String toString() {
            return (this.kdKey == null ? null : Arrays.toString(this.kdKey)) + "->" + this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    public static enum REMOVE_OP {
        REMOVE_RETURN,
        KEEP_RETURN,
        KEEP_RETURN_NULL;

    }

    public static class BSTStats {
        public int nNodesInner = 0;
        public int nNodesLeaf = 0;
        public int capacityInner = 0;
        public int capacityLeaf = 0;
        public int nEntriesInner = 0;
        public int nEntriesLeaf = 0;

        public String toString() {
            return "nNodesI=" + this.nNodesInner + ";nNodesL=" + this.nNodesLeaf + ";capacityI=" + this.capacityInner + ";capacityL=" + this.capacityLeaf + ";nEntriesI=" + this.nEntriesInner + ";nEntriesL=" + this.nEntriesLeaf + ";fillRatioI=" + BSTStats.round((double)this.nEntriesInner / (double)this.capacityInner) + ";fillRatioL=" + BSTStats.round((double)this.nEntriesLeaf / (double)this.capacityLeaf) + ";fillRatio=" + BSTStats.round((double)(this.nEntriesInner + this.nEntriesLeaf) / (double)(this.capacityInner + this.capacityLeaf));
        }

        private static double round(double d) {
            return (double)((int)(d * 100.0 + 0.5)) / 100.0;
        }
    }
}

